package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePersistentVolumeClaim invokes the retailcloud.DeletePersistentVolumeClaim API synchronously
func (client *Client) DeletePersistentVolumeClaim(request *DeletePersistentVolumeClaimRequest) (response *DeletePersistentVolumeClaimResponse, err error) {
	response = CreateDeletePersistentVolumeClaimResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePersistentVolumeClaimWithChan invokes the retailcloud.DeletePersistentVolumeClaim API asynchronously
func (client *Client) DeletePersistentVolumeClaimWithChan(request *DeletePersistentVolumeClaimRequest) (<-chan *DeletePersistentVolumeClaimResponse, <-chan error) {
	responseChan := make(chan *DeletePersistentVolumeClaimResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePersistentVolumeClaim(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePersistentVolumeClaimWithCallback invokes the retailcloud.DeletePersistentVolumeClaim API asynchronously
func (client *Client) DeletePersistentVolumeClaimWithCallback(request *DeletePersistentVolumeClaimRequest, callback func(response *DeletePersistentVolumeClaimResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePersistentVolumeClaimResponse
		var err error
		defer close(result)
		response, err = client.DeletePersistentVolumeClaim(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePersistentVolumeClaimRequest is the request struct for api DeletePersistentVolumeClaim
type DeletePersistentVolumeClaimRequest struct {
	*requests.RpcRequest
	PersistentVolumeClaimName string           `position:"Query" name:"PersistentVolumeClaimName"`
	AppId                     requests.Integer `position:"Query" name:"AppId"`
	EnvId                     requests.Integer `position:"Query" name:"EnvId"`
}

// DeletePersistentVolumeClaimResponse is the response struct for api DeletePersistentVolumeClaim
type DeletePersistentVolumeClaimResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDeletePersistentVolumeClaimRequest creates a request to invoke DeletePersistentVolumeClaim API
func CreateDeletePersistentVolumeClaimRequest() (request *DeletePersistentVolumeClaimRequest) {
	request = &DeletePersistentVolumeClaimRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DeletePersistentVolumeClaim", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePersistentVolumeClaimResponse creates a response to parse from DeletePersistentVolumeClaim response
func CreateDeletePersistentVolumeClaimResponse() (response *DeletePersistentVolumeClaimResponse) {
	response = &DeletePersistentVolumeClaimResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
