package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGWSInstances invokes the ehpc.DescribeGWSInstances API synchronously
func (client *Client) DescribeGWSInstances(request *DescribeGWSInstancesRequest) (response *DescribeGWSInstancesResponse, err error) {
	response = CreateDescribeGWSInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGWSInstancesWithChan invokes the ehpc.DescribeGWSInstances API asynchronously
func (client *Client) DescribeGWSInstancesWithChan(request *DescribeGWSInstancesRequest) (<-chan *DescribeGWSInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeGWSInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGWSInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGWSInstancesWithCallback invokes the ehpc.DescribeGWSInstances API asynchronously
func (client *Client) DescribeGWSInstancesWithCallback(request *DescribeGWSInstancesRequest, callback func(response *DescribeGWSInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGWSInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGWSInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGWSInstancesRequest is the request struct for api DescribeGWSInstances
type DescribeGWSInstancesRequest struct {
	*requests.RpcRequest
	ClusterId  string           `position:"Query" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	UserUid    requests.Integer `position:"Query" name:"UserUid"`
	UserName   string           `position:"Query" name:"UserName"`
}

// DescribeGWSInstancesResponse is the response struct for api DescribeGWSInstances
type DescribeGWSInstancesResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	Instances  Instances `json:"Instances" xml:"Instances"`
}

// CreateDescribeGWSInstancesRequest creates a request to invoke DescribeGWSInstances API
func CreateDescribeGWSInstancesRequest() (request *DescribeGWSInstancesRequest) {
	request = &DescribeGWSInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "DescribeGWSInstances", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeGWSInstancesResponse creates a response to parse from DescribeGWSInstances response
func CreateDescribeGWSInstancesResponse() (response *DescribeGWSInstancesResponse) {
	response = &DescribeGWSInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
