package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertPipelineMember invokes the devops_rdc.InsertPipelineMember API synchronously
func (client *Client) InsertPipelineMember(request *InsertPipelineMemberRequest) (response *InsertPipelineMemberResponse, err error) {
	response = CreateInsertPipelineMemberResponse()
	err = client.DoAction(request, response)
	return
}

// InsertPipelineMemberWithChan invokes the devops_rdc.InsertPipelineMember API asynchronously
func (client *Client) InsertPipelineMemberWithChan(request *InsertPipelineMemberRequest) (<-chan *InsertPipelineMemberResponse, <-chan error) {
	responseChan := make(chan *InsertPipelineMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertPipelineMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertPipelineMemberWithCallback invokes the devops_rdc.InsertPipelineMember API asynchronously
func (client *Client) InsertPipelineMemberWithCallback(request *InsertPipelineMemberRequest, callback func(response *InsertPipelineMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertPipelineMemberResponse
		var err error
		defer close(result)
		response, err = client.InsertPipelineMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertPipelineMemberRequest is the request struct for api InsertPipelineMember
type InsertPipelineMemberRequest struct {
	*requests.RpcRequest
	RoleName   string           `position:"Body" name:"RoleName"`
	UserPk     string           `position:"Body" name:"UserPk"`
	UserId     string           `position:"Body" name:"UserId"`
	OrgId      string           `position:"Query" name:"OrgId"`
	PipelineId requests.Integer `position:"Query" name:"PipelineId"`
}

// InsertPipelineMemberResponse is the response struct for api InsertPipelineMember
type InsertPipelineMemberResponse struct {
	*responses.BaseResponse
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Object       bool   `json:"Object" xml:"Object"`
}

// CreateInsertPipelineMemberRequest creates a request to invoke InsertPipelineMember API
func CreateInsertPipelineMemberRequest() (request *InsertPipelineMemberRequest) {
	request = &InsertPipelineMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "InsertPipelineMember", "", "")
	request.Method = requests.POST
	return
}

// CreateInsertPipelineMemberResponse creates a response to parse from InsertPipelineMember response
func CreateInsertPipelineMemberResponse() (response *InsertPipelineMemberResponse) {
	response = &InsertPipelineMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
