package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDomainConfig invokes the ddospro.ListDomainConfig API synchronously
// api document: https://help.aliyun.com/api/ddospro/listdomainconfig.html
func (client *Client) ListDomainConfig(request *ListDomainConfigRequest) (response *ListDomainConfigResponse, err error) {
	response = CreateListDomainConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ListDomainConfigWithChan invokes the ddospro.ListDomainConfig API asynchronously
// api document: https://help.aliyun.com/api/ddospro/listdomainconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDomainConfigWithChan(request *ListDomainConfigRequest) (<-chan *ListDomainConfigResponse, <-chan error) {
	responseChan := make(chan *ListDomainConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDomainConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDomainConfigWithCallback invokes the ddospro.ListDomainConfig API asynchronously
// api document: https://help.aliyun.com/api/ddospro/listdomainconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListDomainConfigWithCallback(request *ListDomainConfigRequest, callback func(response *ListDomainConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDomainConfigResponse
		var err error
		defer close(result)
		response, err = client.ListDomainConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDomainConfigRequest is the request struct for api ListDomainConfig
type ListDomainConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Domain          string           `position:"Query" name:"Domain"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
}

// ListDomainConfigResponse is the response struct for api ListDomainConfig
type ListDomainConfigResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Total      int        `json:"Total" xml:"Total"`
	ConfigList ConfigList `json:"ConfigList" xml:"ConfigList"`
}

// CreateListDomainConfigRequest creates a request to invoke ListDomainConfig API
func CreateListDomainConfigRequest() (request *ListDomainConfigRequest) {
	request = &ListDomainConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "ListDomainConfig", "", "")
	return
}

// CreateListDomainConfigResponse creates a response to parse from ListDomainConfig response
func CreateListDomainConfigResponse() (response *ListDomainConfigResponse) {
	response = &ListDomainConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
