package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPhotoStores invokes the cloudphoto.ListPhotoStores API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotostores.html
func (client *Client) ListPhotoStores(request *ListPhotoStoresRequest) (response *ListPhotoStoresResponse, err error) {
	response = CreateListPhotoStoresResponse()
	err = client.DoAction(request, response)
	return
}

// ListPhotoStoresWithChan invokes the cloudphoto.ListPhotoStores API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotostores.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotoStoresWithChan(request *ListPhotoStoresRequest) (<-chan *ListPhotoStoresResponse, <-chan error) {
	responseChan := make(chan *ListPhotoStoresResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPhotoStores(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPhotoStoresWithCallback invokes the cloudphoto.ListPhotoStores API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/listphotostores.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPhotoStoresWithCallback(request *ListPhotoStoresRequest, callback func(response *ListPhotoStoresResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPhotoStoresResponse
		var err error
		defer close(result)
		response, err = client.ListPhotoStores(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPhotoStoresRequest is the request struct for api ListPhotoStores
type ListPhotoStoresRequest struct {
	*requests.RpcRequest
}

// ListPhotoStoresResponse is the response struct for api ListPhotoStores
type ListPhotoStoresResponse struct {
	*responses.BaseResponse
	Code        string       `json:"Code" xml:"Code"`
	Message     string       `json:"Message" xml:"Message"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	Action      string       `json:"Action" xml:"Action"`
	PhotoStores []PhotoStore `json:"PhotoStores" xml:"PhotoStores"`
}

// CreateListPhotoStoresRequest creates a request to invoke ListPhotoStores API
func CreateListPhotoStoresRequest() (request *ListPhotoStoresRequest) {
	request = &ListPhotoStoresRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "ListPhotoStores", "cloudphoto", "openAPI")
	return
}

// CreateListPhotoStoresResponse creates a response to parse from ListPhotoStores response
func CreateListPhotoStoresResponse() (response *ListPhotoStoresResponse) {
	response = &ListPhotoStoresResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
