package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateNumberGroup invokes the cloudcallcenter.CreateNumberGroup API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createnumbergroup.html
func (client *Client) CreateNumberGroup(request *CreateNumberGroupRequest) (response *CreateNumberGroupResponse, err error) {
	response = CreateCreateNumberGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateNumberGroupWithChan invokes the cloudcallcenter.CreateNumberGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createnumbergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNumberGroupWithChan(request *CreateNumberGroupRequest) (<-chan *CreateNumberGroupResponse, <-chan error) {
	responseChan := make(chan *CreateNumberGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateNumberGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateNumberGroupWithCallback invokes the cloudcallcenter.CreateNumberGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createnumbergroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateNumberGroupWithCallback(request *CreateNumberGroupRequest, callback func(response *CreateNumberGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateNumberGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateNumberGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateNumberGroupRequest is the request struct for api CreateNumberGroup
type CreateNumberGroupRequest struct {
	*requests.RpcRequest
	NumberGroupName string    `position:"Query" name:"NumberGroupName"`
	Description     string    `position:"Query" name:"Description"`
	ToAddNumbers    *[]string `position:"Query" name:"ToAddNumbers"  type:"Repeated"`
}

// CreateNumberGroupResponse is the response struct for api CreateNumberGroup
type CreateNumberGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateNumberGroupRequest creates a request to invoke CreateNumberGroup API
func CreateCreateNumberGroupRequest() (request *CreateNumberGroupRequest) {
	request = &CreateNumberGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateNumberGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateNumberGroupResponse creates a response to parse from CreateNumberGroup response
func CreateCreateNumberGroupResponse() (response *CreateNumberGroupResponse) {
	response = &CreateNumberGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
