package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_CELUnion = map[string]string{
	"":               "CELUnion demonstrates how to use a discriminated union and how to validate it using CEL.",
	"type":           "type determines which of the union members should be populated.",
	"requiredMember": "requiredMember is a union member that is required.",
	"optionalMember": "optionalMember is a union member that is optional.",
}

func (CELUnion) SwaggerDoc() map[string]string {
	return map_CELUnion
}

var map_EvolvingUnion = map[string]string{
	"type": "type is the discriminator. It has different values for Default and for TechPreviewNoUpgrade",
}

func (EvolvingUnion) SwaggerDoc() map[string]string {
	return map_EvolvingUnion
}

var map_StableConfigType = map[string]string{
	"":         "StableConfigType is a stable config type that may include TechPreviewNoUpgrade fields.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"spec":     "spec is the specification of the desired behavior of the StableConfigType.",
	"status":   "status is the most recently observed status of the StableConfigType.",
}

func (StableConfigType) SwaggerDoc() map[string]string {
	return map_StableConfigType
}

var map_StableConfigTypeList = map[string]string{
	"":         "StableConfigTypeList contains a list of StableConfigTypes.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
}

func (StableConfigTypeList) SwaggerDoc() map[string]string {
	return map_StableConfigTypeList
}

var map_StableConfigTypeSpec = map[string]string{
	"":                       "StableConfigTypeSpec is the desired state",
	"coolNewField":           "coolNewField is a field that is for tech preview only.  On normal clusters this shouldn't be present",
	"stableField":            "stableField is a field that is present on default clusters and on tech preview clusters\n\nIf empty, the platform will choose a good default, which may change over time without notice.",
	"immutableField":         "immutableField is a field that is immutable once the object has been created. It is required at all times.",
	"optionalImmutableField": "optionalImmutableField is a field that is immutable once set. It is optional but may not be changed once set.",
	"evolvingUnion":          "evolvingUnion demonstrates how to phase in new values into discriminated union",
	"celUnion":               "celUnion demonstrates how to validate a discrminated union using CEL",
}

func (StableConfigTypeSpec) SwaggerDoc() map[string]string {
	return map_StableConfigTypeSpec
}

var map_StableConfigTypeStatus = map[string]string{
	"":               "StableConfigTypeStatus defines the observed status of the StableConfigType.",
	"conditions":     "Represents the observations of a foo's current state. Known .status.conditions.type are: \"Available\", \"Progressing\", and \"Degraded\"",
	"immutableField": "immutableField is a field that is immutable once the object has been created. It is required at all times.",
}

func (StableConfigTypeStatus) SwaggerDoc() map[string]string {
	return map_StableConfigTypeStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
