pub const ext = @import("ext.zig");
const webkitwebprocessextension = @This();

const std = @import("std");
const compat = @import("compat");
const soup = @import("soup3");
const gio = @import("gio2");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const javascriptcore = @import("javascriptcore6");
const gtk = @import("gtk4");
const gsk = @import("gsk4");
const graphene = @import("graphene1");
const gdk = @import("gdk4");
const cairo = @import("cairo1");
const pangocairo = @import("pangocairo1");
const pango = @import("pango1");
const harfbuzz = @import("harfbuzz0");
const freetype2 = @import("freetype22");
const gdkpixbuf = @import("gdkpixbuf2");
/// Represents the context menu in a `WebKitWebView`.
///
/// `webkitwebprocessextension.ContextMenu` represents a context menu containing
/// `webkitwebprocessextension.ContextMenuItem`<!-- -->s in a `WebKitWebView`.
///
/// When a `WebKitWebView` is about to display the context menu, it
/// emits the `WebKitWebView.signals.context`-menu signal, which has the
/// `webkitwebprocessextension.ContextMenu` as an argument. You can modify it, adding new
/// submenus that you can create with `webkitwebprocessextension.ContextMenu.new`, adding
/// new `webkitwebprocessextension.ContextMenuItem`<!-- -->s with
/// `webkitwebprocessextension.ContextMenu.prepend`, `webkitwebprocessextension.ContextMenu.append` or
/// `webkitwebprocessextension.ContextMenu.insert`, maybe after having removed the
/// existing ones with `webkitwebprocessextension.ContextMenu.removeAll`.
pub const ContextMenu = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.ContextMenuClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `webkitwebprocessextension.ContextMenu` object.
    ///
    /// Creates a new `webkitwebprocessextension.ContextMenu` object to be used as a submenu of an existing
    /// `webkitwebprocessextension.ContextMenu`. The context menu of a `WebKitWebView` is created by the view
    /// and passed as an argument of `WebKitWebView.signals.context`-menu signal.
    /// To add items to the menu use `webkitwebprocessextension.ContextMenu.prepend`,
    /// `webkitwebprocessextension.ContextMenu.append` or `webkitwebprocessextension.ContextMenu.insert`.
    /// See also `webkitwebprocessextension.ContextMenu.newWithItems` to create a `webkitwebprocessextension.ContextMenu` with
    /// a list of initial items.
    extern fn webkit_context_menu_new() *webkitwebprocessextension.ContextMenu;
    pub const new = webkit_context_menu_new;

    /// Creates a new `webkitwebprocessextension.ContextMenu` object with the given items.
    ///
    /// Creates a new `webkitwebprocessextension.ContextMenu` object to be used as a submenu of an existing
    /// `webkitwebprocessextension.ContextMenu` with the given initial items.
    /// See also `webkitwebprocessextension.ContextMenu.new`
    extern fn webkit_context_menu_new_with_items(p_items: *glib.List) *webkitwebprocessextension.ContextMenu;
    pub const newWithItems = webkit_context_menu_new_with_items;

    /// Adds `item` at the end of the `menu`.
    extern fn webkit_context_menu_append(p_menu: *ContextMenu, p_item: *webkitwebprocessextension.ContextMenuItem) void;
    pub const append = webkit_context_menu_append;

    /// Gets the first item in the `menu`.
    extern fn webkit_context_menu_first(p_menu: *ContextMenu) *webkitwebprocessextension.ContextMenuItem;
    pub const first = webkit_context_menu_first;

    /// Gets the `gdk.Event` that triggered the context menu. This function only returns a valid
    /// `gdk.Event` when called for a `webkitwebprocessextension.ContextMenu` passed to `WebKitWebView.signals.context`-menu
    /// signal; in all other cases, `NULL` is returned.
    ///
    /// The returned `gdk.Event` is expected to be one of the following types:
    /// <itemizedlist>
    /// <listitem><para>
    /// a `GdkEventButton` of type `GDK_BUTTON_PRESS` when the context menu was triggered with mouse.
    /// </para></listitem>
    /// <listitem><para>
    /// a `GdkEventKey` of type `GDK_KEY_PRESS` if the keyboard was used to show the menu.
    /// </para></listitem>
    /// <listitem><para>
    /// a generic `gdk.Event` of type `GDK_NOTHING` when the `gtk.Widget.signals.popup`-menu signal was used to show the context menu.
    /// </para></listitem>
    /// </itemizedlist>
    extern fn webkit_context_menu_get_event(p_menu: *ContextMenu) *gdk.Event;
    pub const getEvent = webkit_context_menu_get_event;

    /// Gets the item at the given position in the `menu`.
    extern fn webkit_context_menu_get_item_at_position(p_menu: *ContextMenu, p_position: c_uint) *webkitwebprocessextension.ContextMenuItem;
    pub const getItemAtPosition = webkit_context_menu_get_item_at_position;

    /// Returns the item list of `menu`.
    extern fn webkit_context_menu_get_items(p_menu: *ContextMenu) *glib.List;
    pub const getItems = webkit_context_menu_get_items;

    /// Gets the length of the `menu`.
    extern fn webkit_context_menu_get_n_items(p_menu: *ContextMenu) c_uint;
    pub const getNItems = webkit_context_menu_get_n_items;

    /// Gets the user data of `menu`.
    ///
    /// This function can be used from the UI Process to get user data previously set
    /// from the Web Process with `webkitwebprocessextension.ContextMenu.setUserData`.
    extern fn webkit_context_menu_get_user_data(p_menu: *ContextMenu) *glib.Variant;
    pub const getUserData = webkit_context_menu_get_user_data;

    /// Inserts `item` into the `menu` at the given position.
    ///
    /// If `position` is negative, or is larger than the number of items
    /// in the `webkitwebprocessextension.ContextMenu`, the item is added on to the end of
    /// the `menu`. The first position is 0.
    extern fn webkit_context_menu_insert(p_menu: *ContextMenu, p_item: *webkitwebprocessextension.ContextMenuItem, p_position: c_int) void;
    pub const insert = webkit_context_menu_insert;

    /// Gets the last item in the `menu`.
    extern fn webkit_context_menu_last(p_menu: *ContextMenu) *webkitwebprocessextension.ContextMenuItem;
    pub const last = webkit_context_menu_last;

    /// Moves `item` to the given position in the `menu`.
    ///
    /// If `position` is negative, or is larger than the number of items
    /// in the `webkitwebprocessextension.ContextMenu`, the item is added on to the end of
    /// the `menu`.
    /// The first position is 0.
    extern fn webkit_context_menu_move_item(p_menu: *ContextMenu, p_item: *webkitwebprocessextension.ContextMenuItem, p_position: c_int) void;
    pub const moveItem = webkit_context_menu_move_item;

    /// Adds `item` at the beginning of the `menu`.
    extern fn webkit_context_menu_prepend(p_menu: *ContextMenu, p_item: *webkitwebprocessextension.ContextMenuItem) void;
    pub const prepend = webkit_context_menu_prepend;

    /// Removes `item` from the `menu`.
    ///
    /// See also `webkitwebprocessextension.ContextMenu.removeAll` to remove all items.
    extern fn webkit_context_menu_remove(p_menu: *ContextMenu, p_item: *webkitwebprocessextension.ContextMenuItem) void;
    pub const remove = webkit_context_menu_remove;

    /// Removes all items of the `menu`.
    extern fn webkit_context_menu_remove_all(p_menu: *ContextMenu) void;
    pub const removeAll = webkit_context_menu_remove_all;

    /// Sets user data to `menu`.
    ///
    /// This function can be used from a Web Process extension to set user data
    /// that can be retrieved from the UI Process using `webkitwebprocessextension.ContextMenu.getUserData`.
    /// If the `user_data` `glib.Variant` is floating, it is consumed.
    extern fn webkit_context_menu_set_user_data(p_menu: *ContextMenu, p_user_data: *glib.Variant) void;
    pub const setUserData = webkit_context_menu_set_user_data;

    extern fn webkit_context_menu_get_type() usize;
    pub const getGObjectType = webkit_context_menu_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.ContextMenu) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.ContextMenu) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContextMenu, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// One item of a `webkitwebprocessextension.ContextMenu`.
///
/// The `webkitwebprocessextension.ContextMenu` is composed of `webkitwebprocessextension.ContextMenuItem`<!--
/// -->s. These items can be created from a `GtkAction`, from a
/// `webkitwebprocessextension.ContextMenuAction` or from a `webkitwebprocessextension.ContextMenuAction` and a
/// label. These `webkitwebprocessextension.ContextMenuAction`<!-- -->s denote stock actions
/// for the items. You can also create separators and submenus.
pub const ContextMenuItem = opaque {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.ContextMenuItemClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `webkitwebprocessextension.ContextMenuItem` for the given `action` and `label`.
    ///
    /// On activation
    /// `target` will be passed as parameter to the callback.
    extern fn webkit_context_menu_item_new_from_gaction(p_action: *gio.Action, p_label: [*:0]const u8, p_target: ?*glib.Variant) *webkitwebprocessextension.ContextMenuItem;
    pub const newFromGaction = webkit_context_menu_item_new_from_gaction;

    /// Creates a new `webkitwebprocessextension.ContextMenuItem` for the given stock action.
    ///
    /// Stock actions are handled automatically by WebKit so that, for example,
    /// when a menu item created with a `WEBKIT_CONTEXT_MENU_ACTION_STOP` is
    /// activated the action associated will be handled by WebKit and the current
    /// load operation will be stopped. You can get the `gio.Action` of a
    /// `webkitwebprocessextension.ContextMenuItem` created with a `webkitwebprocessextension.ContextMenuAction` with
    /// `webkitwebprocessextension.ContextMenuItem.getGaction` and connect to the `gio.SimpleAction.signals.activate` signal
    /// to be notified when the item is activated, but you can't prevent the associated
    /// action from being performed.
    extern fn webkit_context_menu_item_new_from_stock_action(p_action: webkitwebprocessextension.ContextMenuAction) *webkitwebprocessextension.ContextMenuItem;
    pub const newFromStockAction = webkit_context_menu_item_new_from_stock_action;

    /// Creates a new `webkitwebprocessextension.ContextMenuItem` for the given stock action using the given `label`.
    ///
    /// Stock actions have a predefined label, this method can be used to create a
    /// `webkitwebprocessextension.ContextMenuItem` for a `webkitwebprocessextension.ContextMenuAction` but using a custom label.
    extern fn webkit_context_menu_item_new_from_stock_action_with_label(p_action: webkitwebprocessextension.ContextMenuAction, p_label: [*:0]const u8) *webkitwebprocessextension.ContextMenuItem;
    pub const newFromStockActionWithLabel = webkit_context_menu_item_new_from_stock_action_with_label;

    /// Creates a new `webkitwebprocessextension.ContextMenuItem` representing a separator.
    extern fn webkit_context_menu_item_new_separator() *webkitwebprocessextension.ContextMenuItem;
    pub const newSeparator = webkit_context_menu_item_new_separator;

    /// Creates a new `webkitwebprocessextension.ContextMenuItem` using the given `label` with a submenu.
    extern fn webkit_context_menu_item_new_with_submenu(p_label: [*:0]const u8, p_submenu: *webkitwebprocessextension.ContextMenu) *webkitwebprocessextension.ContextMenuItem;
    pub const newWithSubmenu = webkit_context_menu_item_new_with_submenu;

    /// Gets the action associated to `item` as a `gio.Action`.
    extern fn webkit_context_menu_item_get_gaction(p_item: *ContextMenuItem) *gio.Action;
    pub const getGaction = webkit_context_menu_item_get_gaction;

    /// Gets the `webkitwebprocessextension.ContextMenuAction` of `item`.
    ///
    /// If the `webkitwebprocessextension.ContextMenuItem` was not
    /// created for a stock action `WEBKIT_CONTEXT_MENU_ACTION_CUSTOM` will be
    /// returned. If the `webkitwebprocessextension.ContextMenuItem` is a separator `WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION`
    /// will be returned.
    extern fn webkit_context_menu_item_get_stock_action(p_item: *ContextMenuItem) webkitwebprocessextension.ContextMenuAction;
    pub const getStockAction = webkit_context_menu_item_get_stock_action;

    /// Gets the submenu of `item`.
    extern fn webkit_context_menu_item_get_submenu(p_item: *ContextMenuItem) *webkitwebprocessextension.ContextMenu;
    pub const getSubmenu = webkit_context_menu_item_get_submenu;

    /// Checks whether `item` is a separator.
    extern fn webkit_context_menu_item_is_separator(p_item: *ContextMenuItem) c_int;
    pub const isSeparator = webkit_context_menu_item_is_separator;

    /// Sets or replaces the `item` submenu.
    ///
    /// If `submenu` is `NULL` the current
    /// submenu of `item` is removed.
    extern fn webkit_context_menu_item_set_submenu(p_item: *ContextMenuItem, p_submenu: ?*webkitwebprocessextension.ContextMenu) void;
    pub const setSubmenu = webkit_context_menu_item_set_submenu;

    extern fn webkit_context_menu_item_get_type() usize;
    pub const getGObjectType = webkit_context_menu_item_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.ContextMenuItem) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.ContextMenuItem) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContextMenuItem, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A web page frame.
///
/// Each `WebKitWebPage` has at least one main frame, and can have any number
/// of subframes.
pub const Frame = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.FrameClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Gets the process-unique identifier of this `webkitwebprocessextension.Frame`. No other
    /// frame in the same web process will have the same ID; however, frames
    /// in other web processes may.
    extern fn webkit_frame_get_id(p_frame: *Frame) u64;
    pub const getId = webkit_frame_get_id;

    /// Get the JavaScript execution context of `frame`. Use this function to bridge
    /// between the WebKit and JavaScriptCore APIs.
    extern fn webkit_frame_get_js_context(p_frame: *Frame) *javascriptcore.Context;
    pub const getJsContext = webkit_frame_get_js_context;

    /// Get the JavaScript execution context of `frame` for the given `webkitwebprocessextension.ScriptWorld`.
    extern fn webkit_frame_get_js_context_for_script_world(p_frame: *Frame, p_world: *webkitwebprocessextension.ScriptWorld) *javascriptcore.Context;
    pub const getJsContextForScriptWorld = webkit_frame_get_js_context_for_script_world;

    /// Gets the current active URI of `frame`.
    extern fn webkit_frame_get_uri(p_frame: *Frame) [*:0]const u8;
    pub const getUri = webkit_frame_get_uri;

    /// Gets whether `frame` is the main frame of a `webkitwebprocessextension.WebPage`
    extern fn webkit_frame_is_main_frame(p_frame: *Frame) c_int;
    pub const isMainFrame = webkit_frame_is_main_frame;

    extern fn webkit_frame_get_type() usize;
    pub const getGObjectType = webkit_frame_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.Frame) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.Frame) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Frame, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Result of a Hit Test.
///
/// A Hit Test is an operation to get context information about a given
/// point in a `WebKitWebView`. `webkitwebprocessextension.HitTestResult` represents the
/// result of a Hit Test. It provides context information about what is
/// at the coordinates of the Hit Test, such as if there's a link,
/// an image or a media.
///
/// You can get the context of the HitTestResult with
/// `webkitwebprocessextension.HitTestResult.getContext` that returns a bitmask of
/// `webkitwebprocessextension.HitTestResultContext` flags. You can also use
/// `webkitwebprocessextension.HitTestResult.contextIsLink`, `webkitwebprocessextension.HitTestResult.contextIsImage` and
/// `webkitwebprocessextension.HitTestResult.contextIsMedia` to determine whether there's
/// a link, image or a media element at the coordinates of the Hit Test.
/// Note that it's possible that several `webkitwebprocessextension.HitTestResultContext` flags
/// are active at the same time, for example if there's a link containing an image.
///
/// When the mouse is moved over a `WebKitWebView` a Hit Test is performed
/// for the mouse coordinates and `WebKitWebView.signals.mouse`-target-changed
/// signal is emitted with a `webkitwebprocessextension.HitTestResult`.
pub const HitTestResult = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.HitTestResultClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Bitmask of `webkitwebprocessextension.HitTestResultContext` flags representing
        /// the context of the `webkitwebprocessextension.HitTestResult`.
        pub const context = struct {
            pub const name = "context";

            pub const Type = c_uint;
        };

        /// The URI of the image if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE`
        /// is present in `webkitwebprocessextension.HitTestResult.properties.context`
        pub const image_uri = struct {
            pub const name = "image-uri";

            pub const Type = ?[*:0]u8;
        };

        /// The label of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkitwebprocessextension.HitTestResult.properties.context`
        pub const link_label = struct {
            pub const name = "link-label";

            pub const Type = ?[*:0]u8;
        };

        /// The title of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkitwebprocessextension.HitTestResult.properties.context`
        pub const link_title = struct {
            pub const name = "link-title";

            pub const Type = ?[*:0]u8;
        };

        /// The URI of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkitwebprocessextension.HitTestResult.properties.context`
        pub const link_uri = struct {
            pub const name = "link-uri";

            pub const Type = ?[*:0]u8;
        };

        /// The URI of the media if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA`
        /// is present in `webkitwebprocessextension.HitTestResult.properties.context`
        pub const media_uri = struct {
            pub const name = "media-uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_EDITABLE` flag is present in
    /// `webkitwebprocessextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_editable(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsEditable = webkit_hit_test_result_context_is_editable;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE` flag is present in
    /// `webkitwebprocessextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_image(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsImage = webkit_hit_test_result_context_is_image;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK` flag is present in
    /// `webkitwebprocessextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_link(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsLink = webkit_hit_test_result_context_is_link;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA` flag is present in
    /// `webkitwebprocessextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_media(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsMedia = webkit_hit_test_result_context_is_media;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SCROLLBAR` flag is present in
    /// `webkitwebprocessextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_scrollbar(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsScrollbar = webkit_hit_test_result_context_is_scrollbar;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SELECTION` flag is present in
    /// `webkitwebprocessextension.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_selection(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsSelection = webkit_hit_test_result_context_is_selection;

    /// Gets the value of the `webkitwebprocessextension.HitTestResult.properties.context` property.
    extern fn webkit_hit_test_result_get_context(p_hit_test_result: *HitTestResult) c_uint;
    pub const getContext = webkit_hit_test_result_get_context;

    /// Gets the value of the `webkitwebprocessextension.HitTestResult.properties.image`-uri property.
    extern fn webkit_hit_test_result_get_image_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getImageUri = webkit_hit_test_result_get_image_uri;

    /// Gets the value of the `webkitwebprocessextension.HitTestResult.properties.link`-label property.
    extern fn webkit_hit_test_result_get_link_label(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkLabel = webkit_hit_test_result_get_link_label;

    /// Gets the value of the `webkitwebprocessextension.HitTestResult.properties.link`-title property.
    extern fn webkit_hit_test_result_get_link_title(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkTitle = webkit_hit_test_result_get_link_title;

    /// Gets the value of the `webkitwebprocessextension.HitTestResult.properties.link`-uri property.
    extern fn webkit_hit_test_result_get_link_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkUri = webkit_hit_test_result_get_link_uri;

    /// Gets the value of the `webkitwebprocessextension.HitTestResult.properties.media`-uri property.
    extern fn webkit_hit_test_result_get_media_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getMediaUri = webkit_hit_test_result_get_media_uri;

    extern fn webkit_hit_test_result_get_type() usize;
    pub const getGObjectType = webkit_hit_test_result_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.HitTestResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.HitTestResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *HitTestResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ScriptWorld = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.ScriptWorldClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted when the JavaScript window object in a `webkitwebprocessextension.ScriptWorld` has been
        /// cleared. This is the preferred place to set custom properties on the window
        /// object using the JavaScriptCore API. You can get the window object of `frame`
        /// from the JavaScript execution context of `world` that is returned by
        /// `webkitwebprocessextension.Frame.getJsContextForScriptWorld`.
        pub const window_object_cleared = struct {
            pub const name = "window-object-cleared";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_page: *webkitwebprocessextension.WebPage, p_frame: *webkitwebprocessextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ScriptWorld, p_instance))),
                    gobject.signalLookup("window-object-cleared", ScriptWorld.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the default `webkitwebprocessextension.ScriptWorld`. This is the normal script world
    /// where all scripts are executed by default.
    /// You can get the JavaScript execution context of a `webkitwebprocessextension.ScriptWorld`
    /// for a given `webkitwebprocessextension.Frame` with `webkit_frame_get_javascript_context_for_script_world`.
    extern fn webkit_script_world_get_default() *webkitwebprocessextension.ScriptWorld;
    pub const getDefault = webkit_script_world_get_default;

    /// Creates a new isolated `webkitwebprocessextension.ScriptWorld`. Scripts executed in
    /// isolated worlds have access to the DOM but not to other variable
    /// or functions created by the page.
    /// The `webkitwebprocessextension.ScriptWorld` is created with a generated unique name. Use
    /// `webkitwebprocessextension.ScriptWorld.newWithName` if you want to create it with a
    /// custom name.
    /// You can get the JavaScript execution context of a `webkitwebprocessextension.ScriptWorld`
    /// for a given `webkitwebprocessextension.Frame` with `webkit_frame_get_javascript_context_for_script_world`.
    extern fn webkit_script_world_new() *webkitwebprocessextension.ScriptWorld;
    pub const new = webkit_script_world_new;

    /// Creates a new isolated `webkitwebprocessextension.ScriptWorld` with a name. Scripts executed in
    /// isolated worlds have access to the DOM but not to other variable
    /// or functions created by the page.
    /// You can get the JavaScript execution context of a `webkitwebprocessextension.ScriptWorld`
    /// for a given `webkitwebprocessextension.Frame` with `webkit_frame_get_javascript_context_for_script_world`.
    extern fn webkit_script_world_new_with_name(p_name: [*:0]const u8) *webkitwebprocessextension.ScriptWorld;
    pub const newWithName = webkit_script_world_new_with_name;

    /// Get the name of a `webkitwebprocessextension.ScriptWorld`.
    extern fn webkit_script_world_get_name(p_world: *ScriptWorld) [*:0]const u8;
    pub const getName = webkit_script_world_get_name;

    extern fn webkit_script_world_get_type() usize;
    pub const getGObjectType = webkit_script_world_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.ScriptWorld) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.ScriptWorld) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ScriptWorld, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a URI request.
///
/// A `webkitwebprocessextension.URIRequest` can be created with a URI using the
/// `webkitwebprocessextension.URIRequest.new` method, and you can get the URI of an
/// existing request with the `webkitwebprocessextension.URIRequest.getUri` one.
pub const URIRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.URIRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The URI to which the request will be made.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `webkitwebprocessextension.URIRequest` for the given URI.
    extern fn webkit_uri_request_new(p_uri: [*:0]const u8) *webkitwebprocessextension.URIRequest;
    pub const new = webkit_uri_request_new;

    /// Get the HTTP headers of a `webkitwebprocessextension.URIRequest` as a `soup.MessageHeaders`.
    extern fn webkit_uri_request_get_http_headers(p_request: *URIRequest) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_request_get_http_headers;

    /// Get the HTTP method of the `webkitwebprocessextension.URIRequest`.
    extern fn webkit_uri_request_get_http_method(p_request: *URIRequest) [*:0]const u8;
    pub const getHttpMethod = webkit_uri_request_get_http_method;

    /// Obtains the request URI.
    extern fn webkit_uri_request_get_uri(p_request: *URIRequest) [*:0]const u8;
    pub const getUri = webkit_uri_request_get_uri;

    /// Set the URI of `request`
    extern fn webkit_uri_request_set_uri(p_request: *URIRequest, p_uri: [*:0]const u8) void;
    pub const setUri = webkit_uri_request_set_uri;

    extern fn webkit_uri_request_get_type() usize;
    pub const getGObjectType = webkit_uri_request_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.URIRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.URIRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URIRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents an URI response.
///
/// A `webkitwebprocessextension.URIResponse` contains information such as the URI, the
/// status code, the content length, the mime type, the HTTP status or
/// the suggested filename.
pub const URIResponse = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.URIResponseClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The expected content length of the response.
        pub const content_length = struct {
            pub const name = "content-length";

            pub const Type = u64;
        };

        /// The HTTP headers of the response, or `NULL` if the response is not an HTTP response.
        pub const http_headers = struct {
            pub const name = "http-headers";

            pub const Type = ?*soup.MessageHeaders;
        };

        /// The MIME type of the response.
        pub const mime_type = struct {
            pub const name = "mime-type";

            pub const Type = ?[*:0]u8;
        };

        /// The status code of the response as returned by the server.
        pub const status_code = struct {
            pub const name = "status-code";

            pub const Type = c_uint;
        };

        /// The suggested filename for the URI response.
        pub const suggested_filename = struct {
            pub const name = "suggested-filename";

            pub const Type = ?[*:0]u8;
        };

        /// The URI for which the response was made.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Get the expected content length of the `webkitwebprocessextension.URIResponse`.
    ///
    /// It can be 0 if the server provided an incorrect or missing Content-Length.
    extern fn webkit_uri_response_get_content_length(p_response: *URIResponse) u64;
    pub const getContentLength = webkit_uri_response_get_content_length;

    /// Get the HTTP headers of a `webkitwebprocessextension.URIResponse` as a `soup.MessageHeaders`.
    extern fn webkit_uri_response_get_http_headers(p_response: *URIResponse) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_response_get_http_headers;

    /// Gets the MIME type of the response.
    extern fn webkit_uri_response_get_mime_type(p_response: *URIResponse) [*:0]const u8;
    pub const getMimeType = webkit_uri_response_get_mime_type;

    /// Get the status code of the `webkitwebprocessextension.URIResponse`.
    ///
    /// Get the status code of the `webkitwebprocessextension.URIResponse` as returned by
    /// the server. It will normally be a `SoupKnownStatusCode`, for
    /// example `SOUP_STATUS_OK`, though the server can respond with any
    /// unsigned integer.
    extern fn webkit_uri_response_get_status_code(p_response: *URIResponse) c_uint;
    pub const getStatusCode = webkit_uri_response_get_status_code;

    /// Get the suggested filename for `response`.
    ///
    /// Get the suggested filename for `response`, as specified by
    /// the 'Content-Disposition' HTTP header, or `NULL` if it's not
    /// present.
    extern fn webkit_uri_response_get_suggested_filename(p_response: *URIResponse) [*:0]const u8;
    pub const getSuggestedFilename = webkit_uri_response_get_suggested_filename;

    /// Gets the URI which resulted in the response.
    extern fn webkit_uri_response_get_uri(p_response: *URIResponse) [*:0]const u8;
    pub const getUri = webkit_uri_response_get_uri;

    extern fn webkit_uri_response_get_type() usize;
    pub const getGObjectType = webkit_uri_response_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.URIResponse) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.URIResponse) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URIResponse, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Message that can be sent between the UI process and web process extensions.
///
/// A WebKitUserMessage is a message that can be used for the communication between the UI process
/// and web process extensions. A WebKitUserMessage always has a name, and it can also include parameters and
/// UNIX file descriptors. Messages can be sent from a `WebKitWebContext` to all web process extensions,
/// from a web process extension to its corresponding `WebKitWebContext`, and from a `WebKitWebView` to its
/// corresponding `webkitwebprocessextension.WebPage` (and vice versa). One to one messages can be replied to directly with
/// `webkitwebprocessextension.UserMessage.sendReply`.
pub const UserMessage = opaque {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.UserMessageClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The UNIX file descriptors of the user message.
        pub const fd_list = struct {
            pub const name = "fd-list";

            pub const Type = ?*gio.UnixFDList;
        };

        /// The name of the user message.
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// The parameters of the user message as a `glib.Variant`, or `NULL`
        /// if the message doesn't include parameters. Note that only complete types are
        /// allowed.
        pub const parameters = struct {
            pub const name = "parameters";

            pub const Type = ?*glib.Variant;
        };
    };

    pub const signals = struct {};

    /// Gets the quark for the domain of user message errors.
    extern fn webkit_user_message_error_quark() glib.Quark;
    pub const errorQuark = webkit_user_message_error_quark;

    /// Create a new `webkitwebprocessextension.UserMessage` with `name`.
    extern fn webkit_user_message_new(p_name: [*:0]const u8, p_parameters: ?*glib.Variant) *webkitwebprocessextension.UserMessage;
    pub const new = webkit_user_message_new;

    /// Create a new `webkitwebprocessextension.UserMessage` including also a list of UNIX file descriptors to be sent.
    extern fn webkit_user_message_new_with_fd_list(p_name: [*:0]const u8, p_parameters: ?*glib.Variant, p_fd_list: ?*gio.UnixFDList) *webkitwebprocessextension.UserMessage;
    pub const newWithFdList = webkit_user_message_new_with_fd_list;

    /// Get the `message` list of file descritpor.
    extern fn webkit_user_message_get_fd_list(p_message: *UserMessage) ?*gio.UnixFDList;
    pub const getFdList = webkit_user_message_get_fd_list;

    /// Get the `message` name.
    extern fn webkit_user_message_get_name(p_message: *UserMessage) [*:0]const u8;
    pub const getName = webkit_user_message_get_name;

    /// Get the `message` parameters.
    extern fn webkit_user_message_get_parameters(p_message: *UserMessage) ?*glib.Variant;
    pub const getParameters = webkit_user_message_get_parameters;

    /// Send a reply to an user message.
    ///
    /// If `reply` is floating, it's consumed.
    /// You can only send a reply to a `webkitwebprocessextension.UserMessage` that has been
    /// received.
    extern fn webkit_user_message_send_reply(p_message: *UserMessage, p_reply: *webkitwebprocessextension.UserMessage) void;
    pub const sendReply = webkit_user_message_send_reply;

    extern fn webkit_user_message_get_type() usize;
    pub const getGObjectType = webkit_user_message_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.UserMessage) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.UserMessage) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *UserMessage, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Access to editing capabilities of a `webkitwebprocessextension.WebPage`.
///
/// The WebKitWebEditor provides access to various editing capabilities of
/// a `webkitwebprocessextension.WebPage` such as a possibility to react to the current selection in
/// `webkitwebprocessextension.WebPage`.
pub const WebEditor = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.WebEditorClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted for every selection change inside a `webkitwebprocessextension.WebPage`
        /// as well as for every caret position change as the caret is a collapsed
        /// selection.
        pub const selection_changed = struct {
            pub const name = "selection-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebEditor, p_instance))),
                    gobject.signalLookup("selection-changed", WebEditor.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets the `webkitwebprocessextension.WebPage` that is associated with the `webkitwebprocessextension.WebEditor`.
    extern fn webkit_web_editor_get_page(p_editor: *WebEditor) *webkitwebprocessextension.WebPage;
    pub const getPage = webkit_web_editor_get_page;

    extern fn webkit_web_editor_get_type() usize;
    pub const getGObjectType = webkit_web_editor_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.WebEditor) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.WebEditor) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebEditor, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Form manager of a `webkitwebprocessextension.WebPage` in a `webkitwebprocessextension.ScriptWorld`
pub const WebFormManager = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.WebFormManagerClass;
    f_parent: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted after form elements (or form associated elements) are associated to `frame`.
        /// This is useful to implement form auto filling for web pages where form fields are added
        /// dynamically. This signal might be emitted multiple times for the same frame.
        ///
        /// Note that this signal could be also emitted when form controls are moved between forms. In
        /// that case, the `elements` array carries the list of those elements which have moved.
        ///
        /// Clients should take a reference to the members of the `elements` array if it is desired to
        /// keep them alive after the signal handler returns.
        pub const form_controls_associated = struct {
            pub const name = "form-controls-associated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_frame: *webkitwebprocessextension.Frame, p_elements: [*]*javascriptcore.Value, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebFormManager, p_instance))),
                    gobject.signalLookup("form-controls-associated", WebFormManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the DOM submit event is about to be fired for `form`.
        /// JavaScript code may rely on the submit event to detect that the user has clicked
        /// on a submit button, and to possibly cancel the form submission before
        /// `webkitwebprocessextension.WebFormManager.signals.will`-submit-form signal is emitted.
        /// However, beware that, for historical reasons, the submit event is not emitted at
        /// all if the form submission is triggered by JavaScript. For these reasons,
        /// this signal may not be used to reliably detect whether a form will be submitted.
        /// Instead, use it to detect if a user has clicked on a form's submit button even if
        /// JavaScript later cancels the form submission, or to read the values of the form's
        /// fields even if JavaScript later clears certain fields before submitting. This may
        /// be needed, for example, to implement a robust browser password manager, as some
        /// misguided websites may use such techniques to attempt to thwart password managers.
        pub const will_send_submit_event = struct {
            pub const name = "will-send-submit-event";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_form: *javascriptcore.Value, p_source_frame: *webkitwebprocessextension.Frame, p_target_frame: *webkitwebprocessextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebFormManager, p_instance))),
                    gobject.signalLookup("will-send-submit-event", WebFormManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when `form` will imminently be submitted. It can no longer
        /// be cancelled. This event always occurs immediately before a form is submitted to
        /// its target, so use this event to reliably detect when a form is submitted. This
        /// signal is emitted after `webkitwebprocessextension.WebFormManager.signals.will`-send-submit-event if that
        /// signal is emitted.
        pub const will_submit_form = struct {
            pub const name = "will-submit-form";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_form: *javascriptcore.Value, p_source_frame: *webkitwebprocessextension.Frame, p_target_frame: *webkitwebprocessextension.Frame, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebFormManager, p_instance))),
                    gobject.signalLookup("will-submit-form", WebFormManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Set the value of an HTML input element as if it had been edited by
    /// the user, triggering a change event, and set it as filled automatically.
    /// If `element` is not an HTML input element this function does nothing.
    extern fn webkit_web_form_manager_input_element_auto_fill(p_element: *javascriptcore.Value, p_value: [*:0]const u8) void;
    pub const inputElementAutoFill = webkit_web_form_manager_input_element_auto_fill;

    /// Get whether `element` is an HTML input element that has been filled automatically.
    extern fn webkit_web_form_manager_input_element_is_auto_filled(p_element: *javascriptcore.Value) c_int;
    pub const inputElementIsAutoFilled = webkit_web_form_manager_input_element_is_auto_filled;

    /// Get whether `element` is an HTML text input element that has been edited by a user action.
    extern fn webkit_web_form_manager_input_element_is_user_edited(p_element: *javascriptcore.Value) c_int;
    pub const inputElementIsUserEdited = webkit_web_form_manager_input_element_is_user_edited;

    extern fn webkit_web_form_manager_get_type() usize;
    pub const getGObjectType = webkit_web_form_manager_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.WebFormManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.WebFormManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebFormManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Result of a Hit Test (Web Process Extensions).
///
/// WebKitWebHitTestResult extends `webkitwebprocessextension.HitTestResult` to provide information
/// about the `WebKitDOMNode` in the coordinates of the Hit Test.
pub const WebHitTestResult = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.WebHitTestResultClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Check whether there is an editable element at the hit test position.
    ///
    /// Checks whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_EDITABLE` flag is present in
    /// the context flags.
    extern fn webkit_web_hit_test_result_context_is_editable(p_web_hit_test_result: *WebHitTestResult) c_int;
    pub const contextIsEditable = webkit_web_hit_test_result_context_is_editable;

    /// Check whether there is an image element at the hit test position.
    ///
    /// Checks whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE` flag is present in
    /// the context flags.
    extern fn webkit_web_hit_test_result_context_is_image(p_web_hit_test_result: *WebHitTestResult) c_int;
    pub const contextIsImage = webkit_web_hit_test_result_context_is_image;

    /// Check whether there is a link element at the hit test position.
    ///
    /// Checks whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK` flag is present in
    /// the context flags.
    extern fn webkit_web_hit_test_result_context_is_link(p_web_hit_test_result: *WebHitTestResult) c_int;
    pub const contextIsLink = webkit_web_hit_test_result_context_is_link;

    /// Check whether there is a media element at the hit test position.
    ///
    /// Checks whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA` flag is present in
    /// the context flags.
    extern fn webkit_web_hit_test_result_context_is_media(p_web_hit_test_result: *WebHitTestResult) c_int;
    pub const contextIsMedia = webkit_web_hit_test_result_context_is_media;

    /// Check whether there is a scrollbar at the hit test position.
    ///
    /// Checks whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SCROLLBAR` flag is present in
    /// the context flags.
    extern fn webkit_web_hit_test_result_context_is_scrollbar(p_web_hit_test_result: *WebHitTestResult) c_int;
    pub const contextIsScrollbar = webkit_web_hit_test_result_context_is_scrollbar;

    /// Check whether there is a selected element at the hit test position.
    ///
    /// Checks whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SELECTION` flag is present in
    /// the context flags.
    extern fn webkit_web_hit_test_result_context_is_selection(p_web_hit_test_result: *WebHitTestResult) c_int;
    pub const contextIsSelection = webkit_web_hit_test_result_context_is_selection;

    /// Gets the the context flags for the hit test result.
    extern fn webkit_web_hit_test_result_get_context(p_web_hit_test_result: *WebHitTestResult) c_uint;
    pub const getContext = webkit_web_hit_test_result_get_context;

    /// Obtains the URI associated with the image element at the hit test position.
    extern fn webkit_web_hit_test_result_get_image_uri(p_web_hit_test_result: *WebHitTestResult) [*:0]const u8;
    pub const getImageUri = webkit_web_hit_test_result_get_image_uri;

    /// Get the `javascriptcore.Value` for the DOM node in `world` at the coordinates of the Hit Test.
    extern fn webkit_web_hit_test_result_get_js_node(p_web_hit_test_result: *WebHitTestResult, p_world: ?*webkitwebprocessextension.ScriptWorld) ?*javascriptcore.Value;
    pub const getJsNode = webkit_web_hit_test_result_get_js_node;

    /// Obtains the label associated with the link element at the hit test position.
    extern fn webkit_web_hit_test_result_get_link_label(p_web_hit_test_result: *WebHitTestResult) [*:0]const u8;
    pub const getLinkLabel = webkit_web_hit_test_result_get_link_label;

    /// Obtains the title associated with the link element at the hit test position.
    extern fn webkit_web_hit_test_result_get_link_title(p_web_hit_test_result: *WebHitTestResult) [*:0]const u8;
    pub const getLinkTitle = webkit_web_hit_test_result_get_link_title;

    /// Obtains the URI associated with the link element at the hit test position.
    extern fn webkit_web_hit_test_result_get_link_uri(p_web_hit_test_result: *WebHitTestResult) [*:0]const u8;
    pub const getLinkUri = webkit_web_hit_test_result_get_link_uri;

    /// Obtains the URI associated with the media element at the hit test position.
    extern fn webkit_web_hit_test_result_get_media_uri(p_web_hit_test_result: *WebHitTestResult) [*:0]const u8;
    pub const getMediaUri = webkit_web_hit_test_result_get_media_uri;

    extern fn webkit_web_hit_test_result_get_type() usize;
    pub const getGObjectType = webkit_web_hit_test_result_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.WebHitTestResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.WebHitTestResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebHitTestResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A loaded web page.
pub const WebPage = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.WebPageClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The current active URI of the `webkitwebprocessextension.WebPage`.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// Emitted when a message is sent to the console. This can be a message
        /// produced by the use of JavaScript console API, a JavaScript exception,
        /// a security error or other errors, warnings, debug or log messages.
        /// The `console_message` contains information of the message.
        pub const console_message_sent = struct {
            pub const name = "console-message-sent";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_console_message: *webkitwebprocessextension.ConsoleMessage, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("console-message-sent", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted before a context menu is displayed in the UI Process to
        /// give the application a chance to customize the proposed menu,
        /// build its own context menu or pass user data to the UI Process.
        /// This signal is useful when the information available in the UI Process
        /// is not enough to build or customize the context menu, for example, to
        /// add menu entries depending on the node at the coordinates of the
        /// `hit_test_result`. Otherwise, it's recommended to use `WebKitWebView.signals.context`-menu
        /// signal instead.
        pub const context_menu = struct {
            pub const name = "context-menu";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_context_menu: *webkitwebprocessextension.ContextMenu, p_hit_test_result: *webkitwebprocessextension.WebHitTestResult, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("context-menu", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the DOM document of a `webkitwebprocessextension.WebPage` has been
        /// loaded.
        ///
        /// You can wait for this signal to get the DOM document
        pub const document_loaded = struct {
            pub const name = "document-loaded";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("document-loaded", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when `request` is about to be sent to
        /// the server. This signal can be used to modify the `webkitwebprocessextension.URIRequest`
        /// that will be sent to the server. You can also cancel the resource load
        /// operation by connecting to this signal and returning `TRUE`.
        ///
        /// In case of a server redirection this signal is
        /// emitted again with the `request` argument containing the new
        /// request to be sent to the server due to the redirection and the
        /// `redirected_response` parameter containing the response
        /// received by the server for the initial request.
        ///
        /// Modifications to the `webkitwebprocessextension.URIRequest` and its associated
        /// `soup.MessageHeaders` will be taken into account when the request
        /// is sent over the network.
        pub const send_request = struct {
            pub const name = "send-request";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkitwebprocessextension.URIRequest, p_redirected_response: *webkitwebprocessextension.URIResponse, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("send-request", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkitwebprocessextension.UserMessage` is received from the
        /// `WebKitWebView` corresponding to `web_page`. You can reply to the message
        /// using `webkitwebprocessextension.UserMessage.sendReply`.
        ///
        /// You can handle the user message asynchronously by calling `gobject.Object.ref` on
        /// `message` and returning `TRUE`. If the last reference of `message` is removed
        /// and the message has been replied, the operation in the `WebKitWebView` will
        /// finish with error `WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE`.
        pub const user_message_received = struct {
            pub const name = "user-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_message: *webkitwebprocessextension.UserMessage, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebPage, p_instance))),
                    gobject.signalLookup("user-message-received", WebPage.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets the `webkitwebprocessextension.WebEditor` of a `webkitwebprocessextension.WebPage`.
    extern fn webkit_web_page_get_editor(p_web_page: *WebPage) *webkitwebprocessextension.WebEditor;
    pub const getEditor = webkit_web_page_get_editor;

    /// Get the `webkitwebprocessextension.WebFormManager` of `web_page` in `world`.
    extern fn webkit_web_page_get_form_manager(p_web_page: *WebPage, p_world: ?*webkitwebprocessextension.ScriptWorld) *webkitwebprocessextension.WebFormManager;
    pub const getFormManager = webkit_web_page_get_form_manager;

    /// Get the identifier of the `webkitwebprocessextension.WebPage`
    extern fn webkit_web_page_get_id(p_web_page: *WebPage) u64;
    pub const getId = webkit_web_page_get_id;

    /// Returns the main frame of a `webkitwebprocessextension.WebPage`.
    extern fn webkit_web_page_get_main_frame(p_web_page: *WebPage) *webkitwebprocessextension.Frame;
    pub const getMainFrame = webkit_web_page_get_main_frame;

    /// Returns the current active URI of `web_page`.
    ///
    /// You can monitor the active URI by connecting to the notify::uri
    /// signal of `web_page`.
    extern fn webkit_web_page_get_uri(p_web_page: *WebPage) [*:0]const u8;
    pub const getUri = webkit_web_page_get_uri;

    /// Send `message` to the `WebKitWebView` corresponding to `web_page`. If `message` is floating, it's consumed.
    ///
    /// If you don't expect any reply, or you simply want to ignore it, you can pass `NULL` as `callback`.
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkitwebprocessextension.WebPage.sendMessageToViewFinish` to get the message reply.
    extern fn webkit_web_page_send_message_to_view(p_web_page: *WebPage, p_message: *webkitwebprocessextension.UserMessage, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const sendMessageToView = webkit_web_page_send_message_to_view;

    /// Finish an asynchronous operation started with `webkitwebprocessextension.WebPage.sendMessageToView`.
    extern fn webkit_web_page_send_message_to_view_finish(p_web_page: *WebPage, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkitwebprocessextension.UserMessage;
    pub const sendMessageToViewFinish = webkit_web_page_send_message_to_view_finish;

    extern fn webkit_web_page_get_type() usize;
    pub const getGObjectType = webkit_web_page_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.WebPage) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.WebPage) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebPage, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents an extension of the web process.
///
/// WebKitWebProcessExtension is a loadable module for the web process. It allows you to execute code in the
/// web process and being able to use the DOM API, to change any request or to inject custom
/// JavaScript code, for example.
///
/// To create a WebKitWebProcessExtension you should write a module with an initialization function that could
/// be either `webkit_web_process_extension_initialize` with prototype `webkitwebprocessextension.WebProcessExtensionInitializeFunction` or
/// `webkit_web_process_extension_initialize_with_user_data` with prototype `webkitwebprocessextension.WebProcessExtensionInitializeWithUserDataFunction`.
/// This function has to be public and it has to use the `G_MODULE_EXPORT` macro. It is called when the
/// web process is initialized.
///
/// ```c
/// static void
/// web_page_created_callback (WebKitWebProcessExtension *extension,
///                            WebKitWebPage             *web_page,
///                            gpointer                   user_data)
/// {
///     g_print ("Page `d` created for `s`\n",
///              webkit_web_page_get_id (web_page),
///              webkit_web_page_get_uri (web_page));
/// }
///
/// G_MODULE_EXPORT void
/// webkit_web_process_extension_initialize (WebKitWebProcessExtension *extension)
/// {
///     g_signal_connect (extension, "page-created",
///                       G_CALLBACK (web_page_created_callback),
///                       NULL);
/// }
/// ```
///
/// The previous piece of code shows a trivial example of an extension that notifies when
/// a `webkitwebprocessextension.WebPage` is created.
///
/// WebKit has to know where it can find the created WebKitWebProcessExtension. To do so you
/// should use the `webkit_web_context_set_web_extensions_directory` function. The signal
/// `WebKitWebContext.signals.initialize`-web-extensions is the recommended place to call it.
///
/// To provide the initialization data used by the `webkit_web_process_extension_initialize_with_user_data`
/// function, you have to call `webkit_web_context_set_web_extensions_initialization_user_data` with
/// the desired data as parameter. You can see an example of this in the following piece of code:
///
/// ```c
/// `define` WEB_EXTENSIONS_DIRECTORY // ...
///
/// static void
/// initialize_web_extensions (WebKitWebContext *context,
///                            gpointer          user_data)
/// {
///   // Web Extensions get a different ID for each Web Process
///   static guint32 unique_id = 0;
///
///   webkit_web_context_set_web_extensions_directory (
///      context, WEB_EXTENSIONS_DIRECTORY);
///   webkit_web_context_set_web_extensions_initialization_user_data (
///      context, g_variant_new_uint32 (unique_id++));
/// }
///
/// int main (int argc, char **argv)
/// {
///   g_signal_connect (webkit_web_context_get_default (),
///                    "initialize-web-extensions",
///                     G_CALLBACK (initialize_web_extensions),
///                     NULL);
///
///   GtkWidget *view = webkit_web_view_new ();
///
///   // ...
/// }
/// ```
pub const WebProcessExtension = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkitwebprocessextension.WebProcessExtensionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when a new `webkitwebprocessextension.WebPage` is created in
        /// the Web Process.
        pub const page_created = struct {
            pub const name = "page-created";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_web_page: *webkitwebprocessextension.WebPage, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebProcessExtension, p_instance))),
                    gobject.signalLookup("page-created", WebProcessExtension.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkitwebprocessextension.UserMessage` is received from the
        /// `WebKitWebContext` corresponding to `extension`. Messages sent by `WebKitWebContext`
        /// are always broadcasted to all web extensions and they can't be
        /// replied to. Calling `webkitwebprocessextension.UserMessage.sendReply` will do nothing.
        pub const user_message_received = struct {
            pub const name = "user-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_message: *webkitwebprocessextension.UserMessage, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebProcessExtension, p_instance))),
                    gobject.signalLookup("user-message-received", WebProcessExtension.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the web page of the given `page_id`.
    extern fn webkit_web_process_extension_get_page(p_extension: *WebProcessExtension, p_page_id: u64) *webkitwebprocessextension.WebPage;
    pub const getPage = webkit_web_process_extension_get_page;

    /// Send `message` to the `WebKitWebContext` corresponding to `extension`. If `message` is floating, it's consumed.
    ///
    /// If you don't expect any reply, or you simply want to ignore it, you can pass `NULL` as `calback`.
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkitwebprocessextension.WebProcessExtension.sendMessageToContextFinish` to get the message reply.
    extern fn webkit_web_process_extension_send_message_to_context(p_extension: *WebProcessExtension, p_message: *webkitwebprocessextension.UserMessage, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const sendMessageToContext = webkit_web_process_extension_send_message_to_context;

    /// Finish an asynchronous operation started with `webkitwebprocessextension.WebProcessExtension.sendMessageToContext`.
    extern fn webkit_web_process_extension_send_message_to_context_finish(p_extension: *WebProcessExtension, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkitwebprocessextension.UserMessage;
    pub const sendMessageToContextFinish = webkit_web_process_extension_send_message_to_context_finish;

    extern fn webkit_web_process_extension_get_type() usize;
    pub const getGObjectType = webkit_web_process_extension_get_type;

    extern fn g_object_ref(p_self: *webkitwebprocessextension.WebProcessExtension) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkitwebprocessextension.WebProcessExtension) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebProcessExtension, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ConsoleMessage = opaque {
    /// Make a copy of `console_message`.
    extern fn webkit_console_message_copy(p_console_message: *ConsoleMessage) *webkitwebprocessextension.ConsoleMessage;
    pub const copy = webkit_console_message_copy;

    /// Free the `webkitwebprocessextension.ConsoleMessage`
    extern fn webkit_console_message_free(p_console_message: *ConsoleMessage) void;
    pub const free = webkit_console_message_free;

    /// Gets the log level of a `webkitwebprocessextension.ConsoleMessage`
    extern fn webkit_console_message_get_level(p_console_message: *ConsoleMessage) webkitwebprocessextension.ConsoleMessageLevel;
    pub const getLevel = webkit_console_message_get_level;

    /// Gets the line number of a `webkitwebprocessextension.ConsoleMessage`
    extern fn webkit_console_message_get_line(p_console_message: *ConsoleMessage) c_uint;
    pub const getLine = webkit_console_message_get_line;

    /// Gets the source of a `webkitwebprocessextension.ConsoleMessage`
    extern fn webkit_console_message_get_source(p_console_message: *ConsoleMessage) webkitwebprocessextension.ConsoleMessageSource;
    pub const getSource = webkit_console_message_get_source;

    /// Gets the source identifier of a `webkitwebprocessextension.ConsoleMessage`
    extern fn webkit_console_message_get_source_id(p_console_message: *ConsoleMessage) [*:0]const u8;
    pub const getSourceId = webkit_console_message_get_source_id;

    /// Gets the text message of a `webkitwebprocessextension.ConsoleMessage`
    extern fn webkit_console_message_get_text(p_console_message: *ConsoleMessage) [*:0]const u8;
    pub const getText = webkit_console_message_get_text;

    extern fn webkit_console_message_get_type() usize;
    pub const getGObjectType = webkit_console_message_get_type;
};

pub const ContextMenuClass = extern struct {
    pub const Instance = webkitwebprocessextension.ContextMenu;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *ContextMenuClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContextMenuItemClass = extern struct {
    pub const Instance = webkitwebprocessextension.ContextMenuItem;

    f_parent_class: gobject.InitiallyUnownedClass,

    pub fn as(p_instance: *ContextMenuItemClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const FrameClass = extern struct {
    pub const Instance = webkitwebprocessextension.Frame;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *FrameClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const HitTestResultClass = extern struct {
    pub const Instance = webkitwebprocessextension.HitTestResult;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *HitTestResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ScriptWorldClass = extern struct {
    pub const Instance = webkitwebprocessextension.ScriptWorld;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *ScriptWorldClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URIRequestClass = extern struct {
    pub const Instance = webkitwebprocessextension.URIRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *URIRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URIResponseClass = extern struct {
    pub const Instance = webkitwebprocessextension.URIResponse;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *URIResponseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const UserMessageClass = extern struct {
    pub const Instance = webkitwebprocessextension.UserMessage;

    f_parent_class: gobject.InitiallyUnownedClass,

    pub fn as(p_instance: *UserMessageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebEditorClass = extern struct {
    pub const Instance = webkitwebprocessextension.WebEditor;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebEditorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebFormManagerClass = extern struct {
    pub const Instance = webkitwebprocessextension.WebFormManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebFormManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebHitTestResultClass = extern struct {
    pub const Instance = webkitwebprocessextension.WebHitTestResult;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebHitTestResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebPageClass = extern struct {
    pub const Instance = webkitwebprocessextension.WebPage;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebPageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebProcessExtensionClass = extern struct {
    pub const Instance = webkitwebprocessextension.WebProcessExtension;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebProcessExtensionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Enum values used to denote the various levels of console messages.
pub const ConsoleMessageLevel = enum(c_int) {
    info = 0,
    log = 1,
    warning = 2,
    @"error" = 3,
    debug = 4,
    _,

    extern fn webkit_console_message_level_get_type() usize;
    pub const getGObjectType = webkit_console_message_level_get_type;
};

/// Enum values used to denote the various sources of console messages.
pub const ConsoleMessageSource = enum(c_int) {
    javascript = 0,
    network = 1,
    console_api = 2,
    security = 3,
    other = 4,
    _,

    extern fn webkit_console_message_source_get_type() usize;
    pub const getGObjectType = webkit_console_message_source_get_type;
};

/// Enum values used to denote the stock actions for
/// `webkitwebprocessextension.ContextMenuItem`<!-- -->s
pub const ContextMenuAction = enum(c_int) {
    no_action = 0,
    open_link = 1,
    open_link_in_new_window = 2,
    download_link_to_disk = 3,
    copy_link_to_clipboard = 4,
    open_image_in_new_window = 5,
    download_image_to_disk = 6,
    copy_image_to_clipboard = 7,
    copy_image_url_to_clipboard = 8,
    open_frame_in_new_window = 9,
    go_back = 10,
    go_forward = 11,
    stop = 12,
    reload = 13,
    copy = 14,
    cut = 15,
    paste = 16,
    delete = 17,
    select_all = 18,
    input_methods = 19,
    unicode = 20,
    spelling_guess = 21,
    no_guesses_found = 22,
    ignore_spelling = 23,
    learn_spelling = 24,
    ignore_grammar = 25,
    font_menu = 26,
    bold = 27,
    italic = 28,
    underline = 29,
    outline = 30,
    inspect_element = 31,
    open_video_in_new_window = 32,
    open_audio_in_new_window = 33,
    copy_video_link_to_clipboard = 34,
    copy_audio_link_to_clipboard = 35,
    toggle_media_controls = 36,
    toggle_media_loop = 37,
    enter_video_fullscreen = 38,
    media_play = 39,
    media_pause = 40,
    media_mute = 41,
    download_video_to_disk = 42,
    download_audio_to_disk = 43,
    insert_emoji = 44,
    paste_as_plain_text = 45,
    custom = 10000,
    _,
};

/// Enum values used to denote errors happening when sending user messages.
pub const UserMessageError = enum(c_int) {
    user_message_unhandled_message = 0,
    _,
};

/// Enum values with flags representing the context of a `webkitwebprocessextension.HitTestResult`.
pub const HitTestResultContext = packed struct(c_uint) {
    _padding0: bool = false,
    document: bool = false,
    link: bool = false,
    image: bool = false,
    media: bool = false,
    editable: bool = false,
    scrollbar: bool = false,
    selection: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_document: HitTestResultContext = @bitCast(@as(c_uint, 2));
    const flags_link: HitTestResultContext = @bitCast(@as(c_uint, 4));
    const flags_image: HitTestResultContext = @bitCast(@as(c_uint, 8));
    const flags_media: HitTestResultContext = @bitCast(@as(c_uint, 16));
    const flags_editable: HitTestResultContext = @bitCast(@as(c_uint, 32));
    const flags_scrollbar: HitTestResultContext = @bitCast(@as(c_uint, 64));
    const flags_selection: HitTestResultContext = @bitCast(@as(c_uint, 128));
};

/// Type definition for a function that will be called to initialize
/// the web extension when the web process starts.
pub const WebProcessExtensionInitializeFunction = *const fn (p_extension: *webkitwebprocessextension.WebProcessExtension) callconv(.C) void;

/// Type definition for a function that will be called to initialize
/// the web extensions when the web process starts, and which receives
/// as additional argument the user data set with
/// `webkit_web_context_set_web_process_extensions_initialization_user_data`.
pub const WebProcessExtensionInitializeWithUserDataFunction = *const fn (p_extension: *webkitwebprocessextension.WebProcessExtension, p_user_data: *const glib.Variant) callconv(.C) void;
