pub const ext = @import("ext.zig");
const cudagst = @This();

const std = @import("std");
const compat = @import("compat");
pub const array = *anyopaque;

pub const context = *anyopaque;

pub const device = c_int;

pub const deviceptr = usize;

pub const event = *anyopaque;

pub const function = *anyopaque;

pub const graphicsResource = *anyopaque;

pub const memGenericAllocationHandle = c_ulonglong;

pub const mipmappedArray = *anyopaque;

pub const module = *anyopaque;

pub const stream = *anyopaque;

pub const texObject = u64;

pub const DA_MEMCPY2D = extern struct {
    f_srcXInBytes: usize,
    f_srcY: usize,
    f_srcMemoryType: cudagst.memorytype,
    f_srcHost: ?*const anyopaque,
    f_srcDevice: cudagst.deviceptr,
    f_srcArray: cudagst.array,
    f_srcPitch: usize,
    f_dstXInBytes: usize,
    f_dstY: usize,
    f_dstMemoryType: cudagst.memorytype,
    f_dstHost: ?*anyopaque,
    f_dstDevice: cudagst.deviceptr,
    f_dstArray: cudagst.array,
    f_dstPitch: usize,
    f_WidthInBytes: usize,
    f_Height: usize,
};

pub const DA_RESOURCE_DESC = extern struct {
    f_resType: cudagst.resourcetype,
    anon0: extern union {
        anon0: extern struct {
            f_hArray: cudagst.array,
        },
        anon1: extern struct {
            f_hMipmappedArray: cudagst.mipmappedArray,
        },
        anon2: extern struct {
            f_devPtr: cudagst.deviceptr,
            f_format: cudagst.array_format,
            f_numChannels: c_uint,
            f_sizeInBytes: usize,
        },
        anon3: extern struct {
            f_devPtr: cudagst.deviceptr,
            f_format: cudagst.array_format,
            f_numChannels: c_uint,
            f_width: usize,
            f_height: usize,
            f_pitchInBytes: usize,
        },
        anon4: extern struct {
            f_reserved: [32]c_int,
        },
    },
    f_flags: c_uint,
};

pub const DA_RESOURCE_VIEW_DESC = extern struct {
    f_format: cudagst.resourceViewFormat,
    f_width: usize,
    f_height: usize,
    f_depth: usize,
    f_firstMipmapLevel: c_uint,
    f_lastMipmapLevel: c_uint,
    f_firstLayer: c_uint,
    f_lastLayer: c_uint,
    f_reserved: [16]c_uint,
};

pub const DA_TEXTURE_DESC = extern struct {
    f_addressMode: [3]cudagst.address_mode,
    f_filterMode: cudagst.filter_mode,
    f_flags: c_uint,
    f_maxAnisotropy: c_uint,
    f_mipmapFilterMode: cudagst.filter_mode,
    f_mipmapLevelBias: f32,
    f_minMipmapLevelClamp: f32,
    f_maxMipmapLevelClamp: f32,
    f_borderColor: [4]f32,
    f_reserved: [12]c_int,
};

pub const ipcEventHandle = extern struct {
    f_reserved: [64]u8,
};

pub const ipcMemHandle = extern struct {
    f_reserved: [64]u8,
};

pub const memAccessDesc = extern struct {
    f_location: cudagst.memLocation,
    f_flags: cudagst.memAccess_flags,
};

pub const memAllocationProp = extern struct {
    f_type: cudagst.memAllocationType,
    f_requestedHandleTypes: cudagst.memAllocationHandleType,
    f_location: cudagst.memLocation,
    f_win32HandleMetaData: ?*anyopaque,
    f_allocFlags: cudagst.memAllocationPropAllocFlags,
};

pub const memAllocationPropAllocFlags = extern struct {
    f_compressionType: u8,
    f_gpuDirectRDMACapable: u8,
    f_usage: c_ushort,
    f_reserved: [4]u8,
};

pub const memLocation = extern struct {
    f_type: cudagst.memLocationType,
    f_id: c_int,
};

pub const GLDeviceList = enum(c_int) {
    gl_device_list_all = 1,
    _,
};

pub const address_mode = enum(c_int) {
    wrap = 0,
    clamp = 1,
    mirror = 2,
    border = 3,
    _,
};

pub const array_format = enum(c_int) {
    int8 = 1,
    int16 = 2,
    _,
};

pub const device_attribute = enum(c_int) {
    texture_alignment = 14,
    unified_addressing = 41,
    compute_capability_major = 75,
    compute_capability_minor = 76,
    virtual_memory_management_supported = 102,
    handle_type_posix_file_descriptor_supported = 103,
    handle_type_win32_handle_supported = 104,
    handle_type_win32_kmt_handle_supported = 105,
    _,
};

pub const event_flags = enum(c_int) {
    default = 0,
    blocking_sync = 1,
    disable_timing = 2,
    interprocess = 4,
    _,
};

pub const filter_mode = enum(c_int) {
    point = 0,
    linear = 1,
    _,
};

pub const graphicsMapResourceFlags = enum(c_int) {
    none = 0,
    read_only = 1,
    write_discard = 2,
    _,
};

pub const graphicsRegisterFlags = enum(c_int) {
    none = 0,
    read_only = 1,
    write_discard = 2,
    surface_load_store = 4,
    texture_gather = 8,
    _,
};

pub const ipcMem_flags = enum(c_int) {
    ipc_mem_lazy_enable_peer_access = 1,
    _,
};

pub const memAccess_flags = enum(c_int) {
    none = 0,
    read = 1,
    readwrite = 3,
    max = 2147483647,
    _,
};

pub const memAllocationGranularity_flags = enum(c_int) {
    minimum = 0,
    recommended = 1,
    _,
};

pub const memAllocationHandleType = enum(c_int) {
    none = 0,
    posix_file_descriptor = 1,
    win32 = 2,
    win32_kmt = 4,
    max = 2147483647,
    _,
};

pub const memAllocationType = enum(c_int) {
    invalid = 0,
    pinned = 1,
    max = 2147483647,
    _,
};

pub const memLocationType = enum(c_int) {
    invalid = 0,
    device = 1,
    max = 2147483647,
    _,
};

pub const memorytype = enum(c_int) {
    host = 1,
    device = 2,
    array = 3,
    unified = 4,
    _,
};

pub const resourceViewFormat = enum(c_int) {
    res_view_format_none = 0,
    _,
};

pub const resourcetype = enum(c_int) {
    array = 0,
    mipmapped_array = 1,
    linear = 2,
    pitch2d = 3,
    _,
};

pub const result = enum(c_int) {
    success = 0,
    error_no_device = 100,
    error_already_mapped = 208,
    error_not_supported = 801,
    _,
};

pub const stream_flags = enum(c_int) {
    default = 0,
    non_blocking = 1,
    _,
};

pub const IPC_HANDLE_SIZE = 64;
pub const TRSF_READ_AS_INTEGER = 1;
pub const VERSION = 10000;
