/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type;

import java.security.spec.AlgorithmParameterSpec;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.ecc.ecdh.ECDH;
import org.pgpainless.key.generation.type.ecc.ecdsa.ECDSA;
import org.pgpainless.key.generation.type.eddsa.EdDSA;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RSA;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDH;
import org.pgpainless.key.generation.type.xdh.XDHSpec;

public interface KeyType {
    public String getName();

    public PublicKeyAlgorithm getAlgorithm();

    public int getBitStrength();

    public AlgorithmParameterSpec getAlgorithmSpec();

    default public boolean canSign() {
        return this.getAlgorithm().isSigningCapable();
    }

    default public boolean canCertify() {
        return this.canSign();
    }

    default public boolean canAuthenticate() {
        return this.canSign();
    }

    default public boolean canEncryptCommunication() {
        return this.getAlgorithm().isEncryptionCapable();
    }

    default public boolean canEncryptStorage() {
        return this.getAlgorithm().isEncryptionCapable();
    }

    public static KeyType RSA(RsaLength length) {
        return RSA.withLength(length);
    }

    public static KeyType ECDH(EllipticCurve curve) {
        return ECDH.fromCurve(curve);
    }

    public static KeyType ECDSA(EllipticCurve curve) {
        return ECDSA.fromCurve(curve);
    }

    public static KeyType EDDSA(EdDSACurve curve) {
        return EdDSA.fromCurve(curve);
    }

    public static KeyType XDH(XDHSpec curve) {
        return XDH.fromSpec(curve);
    }
}

