// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package testing

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

func (t *SimpleTypeTree) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{169}); err != nil {
		return err
	}

	// t.Dog (string) (string)
	if len("Dog") > 8192 {
		return xerrors.Errorf("Value in field \"Dog\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Dog"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Dog")); err != nil {
		return err
	}

	if len(t.Dog) > 8192 {
		return xerrors.Errorf("Value in field t.Dog was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Dog))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Dog)); err != nil {
		return err
	}

	// t.Test ([][]uint8) (slice)
	if len("Test") > 8192 {
		return xerrors.Errorf("Value in field \"Test\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Test"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Test")); err != nil {
		return err
	}

	if len(t.Test) > 8192 {
		return xerrors.Errorf("Slice value in field t.Test was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Test))); err != nil {
		return err
	}
	for _, v := range t.Test {
		if len(v) > 2097152 {
			return xerrors.Errorf("Byte array in field v was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(v))); err != nil {
			return err
		}

		if _, err := cw.Write(v); err != nil {
			return err
		}

	}

	// t.Stuff (testing.SimpleTypeTree) (struct)
	if len("Stuff") > 8192 {
		return xerrors.Errorf("Value in field \"Stuff\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Stuff"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Stuff")); err != nil {
		return err
	}

	if err := t.Stuff.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Others ([]uint64) (slice)
	if len("Others") > 8192 {
		return xerrors.Errorf("Value in field \"Others\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Others"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Others")); err != nil {
		return err
	}

	if len(t.Others) > 8192 {
		return xerrors.Errorf("Slice value in field t.Others was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Others))); err != nil {
		return err
	}
	for _, v := range t.Others {

		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
			return err
		}

	}

	// t.Stufff (testing.SimpleTypeTwo) (struct)
	if len("Stufff") > 8192 {
		return xerrors.Errorf("Value in field \"Stufff\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Stufff"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Stufff")); err != nil {
		return err
	}

	if err := t.Stufff.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.BoolPtr (bool) (bool)
	if len("BoolPtr") > 8192 {
		return xerrors.Errorf("Value in field \"BoolPtr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("BoolPtr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("BoolPtr")); err != nil {
		return err
	}

	if t.BoolPtr == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteBool(w, *t.BoolPtr); err != nil {
			return err
		}
	}

	// t.NotPizza (uint64) (uint64)
	if len("NotPizza") > 8192 {
		return xerrors.Errorf("Value in field \"NotPizza\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NotPizza"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NotPizza")); err != nil {
		return err
	}

	if t.NotPizza == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(*t.NotPizza)); err != nil {
			return err
		}
	}

	// t.StringPtr (string) (string)
	if len("StringPtr") > 8192 {
		return xerrors.Errorf("Value in field \"StringPtr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("StringPtr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("StringPtr")); err != nil {
		return err
	}

	if t.StringPtr == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if len(*t.StringPtr) > 8192 {
			return xerrors.Errorf("Value in field t.StringPtr was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.StringPtr))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(*t.StringPtr)); err != nil {
			return err
		}
	}

	// t.SixtyThreeBitIntegerWithASignBit (int64) (int64)
	if len("SixtyThreeBitIntegerWithASignBit") > 8192 {
		return xerrors.Errorf("Value in field \"SixtyThreeBitIntegerWithASignBit\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("SixtyThreeBitIntegerWithASignBit"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("SixtyThreeBitIntegerWithASignBit")); err != nil {
		return err
	}

	if t.SixtyThreeBitIntegerWithASignBit >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.SixtyThreeBitIntegerWithASignBit)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.SixtyThreeBitIntegerWithASignBit-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *SimpleTypeTree) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SimpleTypeTree{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SimpleTypeTree: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Dog (string) (string)
		case "Dog":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Dog = string(sval)
			}
			// t.Test ([][]uint8) (slice)
		case "Test":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Test: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Test = make([][]uint8, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}

					if extra > 2097152 {
						return fmt.Errorf("t.Test[i]: byte array too large (%d)", extra)
					}
					if maj != cbg.MajByteString {
						return fmt.Errorf("expected byte array")
					}

					if extra > 0 {
						t.Test[i] = make([]uint8, extra)
					}

					if _, err := io.ReadFull(cr, t.Test[i]); err != nil {
						return err
					}

				}
			}
			// t.Stuff (testing.SimpleTypeTree) (struct)
		case "Stuff":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Stuff = new(SimpleTypeTree)
					if err := t.Stuff.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Stuff pointer: %w", err)
					}
				}

			}
			// t.Others ([]uint64) (slice)
		case "Others":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Others: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Others = make([]uint64, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						maj, extra, err = cr.ReadHeader()
						if err != nil {
							return err
						}
						if maj != cbg.MajUnsignedInt {
							return fmt.Errorf("wrong type for uint64 field")
						}
						t.Others[i] = uint64(extra)

					}

				}
			}
			// t.Stufff (testing.SimpleTypeTwo) (struct)
		case "Stufff":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					t.Stufff = new(SimpleTypeTwo)
					if err := t.Stufff.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling t.Stufff pointer: %w", err)
					}
				}

			}
			// t.BoolPtr (bool) (bool)
		case "BoolPtr":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}
					if maj != cbg.MajOther {
						return fmt.Errorf("booleans must be major type 7")
					}

					var val bool
					switch extra {
					case 20:
						val = false
					case 21:
						val = true
					default:
						return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
					}
					t.BoolPtr = &val
				}
			}
			// t.NotPizza (uint64) (uint64)
		case "NotPizza":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}
					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}
					if maj != cbg.MajUnsignedInt {
						return fmt.Errorf("wrong type for uint64 field")
					}
					typed := uint64(extra)
					t.NotPizza = &typed
				}

			}
			// t.StringPtr (string) (string)
		case "StringPtr":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					t.StringPtr = (*string)(&sval)
				}
			}
			// t.SixtyThreeBitIntegerWithASignBit (int64) (int64)
		case "SixtyThreeBitIntegerWithASignBit":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.SixtyThreeBitIntegerWithASignBit = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *NeedScratchForMap) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.Thing (bool) (bool)
	if len("Thing") > 8192 {
		return xerrors.Errorf("Value in field \"Thing\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Thing"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Thing")); err != nil {
		return err
	}

	if err := cbg.WriteBool(w, t.Thing); err != nil {
		return err
	}
	return nil
}

func (t *NeedScratchForMap) UnmarshalCBOR(r io.Reader) (err error) {
	*t = NeedScratchForMap{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("NeedScratchForMap: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Thing (bool) (bool)
		case "Thing":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajOther {
				return fmt.Errorf("booleans must be major type 7")
			}
			switch extra {
			case 20:
				t.Thing = false
			case 21:
				t.Thing = true
			default:
				return fmt.Errorf("booleans are either major type 7, value 20 or 21 (got %d)", extra)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SimpleStructV1) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{169}); err != nil {
		return err
	}

	// t.OldMap (map[string]testing.SimpleTypeOne) (map)
	if len("OldMap") > 8192 {
		return xerrors.Errorf("Value in field \"OldMap\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldMap"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldMap")); err != nil {
		return err
	}

	{
		if len(t.OldMap) > 4096 {
			return xerrors.Errorf("cannot marshal t.OldMap map too large")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajMap, uint64(len(t.OldMap))); err != nil {
			return err
		}

		keys := make([]string, 0, len(t.OldMap))
		for k := range t.OldMap {
			keys = append(keys, k)
		}
		sort.Strings(keys)
		for _, k := range keys {
			v := t.OldMap[k]

			if len(k) > 8192 {
				return xerrors.Errorf("Value in field k was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(k))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(k)); err != nil {
				return err
			}

			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.OldNum (uint64) (uint64)
	if len("OldNum") > 8192 {
		return xerrors.Errorf("Value in field \"OldNum\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldNum"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldNum")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.OldNum)); err != nil {
		return err
	}

	// t.OldPtr (cid.Cid) (struct)
	if len("OldPtr") > 8192 {
		return xerrors.Errorf("Value in field \"OldPtr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldPtr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldPtr")); err != nil {
		return err
	}

	if t.OldPtr == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteCid(cw, *t.OldPtr); err != nil {
			return xerrors.Errorf("failed to write cid field t.OldPtr: %w", err)
		}
	}

	// t.OldStr (string) (string)
	if len("OldStr") > 8192 {
		return xerrors.Errorf("Value in field \"OldStr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldStr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldStr")); err != nil {
		return err
	}

	if len(t.OldStr) > 8192 {
		return xerrors.Errorf("Value in field t.OldStr was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.OldStr))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.OldStr)); err != nil {
		return err
	}

	// t.OldArray ([]testing.SimpleTypeOne) (slice)
	if len("OldArray") > 8192 {
		return xerrors.Errorf("Value in field \"OldArray\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldArray"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldArray")); err != nil {
		return err
	}

	if len(t.OldArray) > 8192 {
		return xerrors.Errorf("Slice value in field t.OldArray was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.OldArray))); err != nil {
		return err
	}
	for _, v := range t.OldArray {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.OldBytes ([]uint8) (slice)
	if len("OldBytes") > 8192 {
		return xerrors.Errorf("Value in field \"OldBytes\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldBytes"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldBytes")); err != nil {
		return err
	}

	if len(t.OldBytes) > 2097152 {
		return xerrors.Errorf("Byte array in field t.OldBytes was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.OldBytes))); err != nil {
		return err
	}

	if _, err := cw.Write(t.OldBytes); err != nil {
		return err
	}

	// t.OldStruct (testing.SimpleTypeOne) (struct)
	if len("OldStruct") > 8192 {
		return xerrors.Errorf("Value in field \"OldStruct\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldStruct"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldStruct")); err != nil {
		return err
	}

	if err := t.OldStruct.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.OldCidArray ([]cid.Cid) (slice)
	if len("OldCidArray") > 8192 {
		return xerrors.Errorf("Value in field \"OldCidArray\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldCidArray"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldCidArray")); err != nil {
		return err
	}

	if len(t.OldCidArray) > 8192 {
		return xerrors.Errorf("Slice value in field t.OldCidArray was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.OldCidArray))); err != nil {
		return err
	}
	for _, v := range t.OldCidArray {

		if err := cbg.WriteCid(cw, v); err != nil {
			return xerrors.Errorf("failed to write cid field v: %w", err)
		}

	}

	// t.OldCidPtrArray ([]*cid.Cid) (slice)
	if len("OldCidPtrArray") > 8192 {
		return xerrors.Errorf("Value in field \"OldCidPtrArray\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldCidPtrArray"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldCidPtrArray")); err != nil {
		return err
	}

	if len(t.OldCidPtrArray) > 8192 {
		return xerrors.Errorf("Slice value in field t.OldCidPtrArray was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.OldCidPtrArray))); err != nil {
		return err
	}
	for _, v := range t.OldCidPtrArray {

		if v == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if err := cbg.WriteCid(cw, *v); err != nil {
				return xerrors.Errorf("failed to write cid field v: %w", err)
			}
		}

	}
	return nil
}

func (t *SimpleStructV1) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SimpleStructV1{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SimpleStructV1: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.OldMap (map[string]testing.SimpleTypeOne) (map)
		case "OldMap":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajMap {
				return fmt.Errorf("expected a map (major type 5)")
			}
			if extra > 4096 {
				return fmt.Errorf("t.OldMap: map too large")
			}

			t.OldMap = make(map[string]SimpleTypeOne, extra)

			for i, l := 0, int(extra); i < l; i++ {

				var k string

				{
					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					k = string(sval)
				}

				var v SimpleTypeOne

				{

					if err := v.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling v: %w", err)
					}

				}

				t.OldMap[k] = v

			}
			// t.OldNum (uint64) (uint64)
		case "OldNum":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.OldNum = uint64(extra)

			}
			// t.OldPtr (cid.Cid) (struct)
		case "OldPtr":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					c, err := cbg.ReadCid(cr)
					if err != nil {
						return xerrors.Errorf("failed to read cid field t.OldPtr: %w", err)
					}

					t.OldPtr = &c
				}

			}
			// t.OldStr (string) (string)
		case "OldStr":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.OldStr = string(sval)
			}
			// t.OldArray ([]testing.SimpleTypeOne) (slice)
		case "OldArray":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.OldArray: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.OldArray = make([]SimpleTypeOne, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.OldArray[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.OldArray[i]: %w", err)
						}

					}

				}
			}
			// t.OldBytes ([]uint8) (slice)
		case "OldBytes":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.OldBytes: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.OldBytes = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.OldBytes); err != nil {
				return err
			}

			// t.OldStruct (testing.SimpleTypeOne) (struct)
		case "OldStruct":

			{

				if err := t.OldStruct.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.OldStruct: %w", err)
				}

			}
			// t.OldCidArray ([]cid.Cid) (slice)
		case "OldCidArray":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.OldCidArray: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.OldCidArray = make([]cid.Cid, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						c, err := cbg.ReadCid(cr)
						if err != nil {
							return xerrors.Errorf("failed to read cid field t.OldCidArray[i]: %w", err)
						}

						t.OldCidArray[i] = c

					}

				}
			}
			// t.OldCidPtrArray ([]*cid.Cid) (slice)
		case "OldCidPtrArray":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.OldCidPtrArray: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.OldCidPtrArray = make([]*cid.Cid, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						b, err := cr.ReadByte()
						if err != nil {
							return err
						}
						if b != cbg.CborNull[0] {
							if err := cr.UnreadByte(); err != nil {
								return err
							}

							c, err := cbg.ReadCid(cr)
							if err != nil {
								return xerrors.Errorf("failed to read cid field t.OldCidPtrArray[i]: %w", err)
							}

							t.OldCidPtrArray[i] = &c
						}

					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *SimpleStructV2) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{174}); err != nil {
		return err
	}

	// t.NewMap (map[string]testing.SimpleTypeOne) (map)
	if len("NewMap") > 8192 {
		return xerrors.Errorf("Value in field \"NewMap\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewMap"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewMap")); err != nil {
		return err
	}

	{
		if len(t.NewMap) > 4096 {
			return xerrors.Errorf("cannot marshal t.NewMap map too large")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajMap, uint64(len(t.NewMap))); err != nil {
			return err
		}

		keys := make([]string, 0, len(t.NewMap))
		for k := range t.NewMap {
			keys = append(keys, k)
		}
		sort.Strings(keys)
		for _, k := range keys {
			v := t.NewMap[k]

			if len(k) > 8192 {
				return xerrors.Errorf("Value in field k was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(k))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(k)); err != nil {
				return err
			}

			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.NewNum (uint64) (uint64)
	if len("NewNum") > 8192 {
		return xerrors.Errorf("Value in field \"NewNum\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewNum"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewNum")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.NewNum)); err != nil {
		return err
	}

	// t.NewPtr (cid.Cid) (struct)
	if len("NewPtr") > 8192 {
		return xerrors.Errorf("Value in field \"NewPtr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewPtr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewPtr")); err != nil {
		return err
	}

	if t.NewPtr == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteCid(cw, *t.NewPtr); err != nil {
			return xerrors.Errorf("failed to write cid field t.NewPtr: %w", err)
		}
	}

	// t.NewStr (string) (string)
	if len("NewStr") > 8192 {
		return xerrors.Errorf("Value in field \"NewStr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewStr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewStr")); err != nil {
		return err
	}

	if len(t.NewStr) > 8192 {
		return xerrors.Errorf("Value in field t.NewStr was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.NewStr))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.NewStr)); err != nil {
		return err
	}

	// t.OldMap (map[string]testing.SimpleTypeOne) (map)
	if len("OldMap") > 8192 {
		return xerrors.Errorf("Value in field \"OldMap\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldMap"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldMap")); err != nil {
		return err
	}

	{
		if len(t.OldMap) > 4096 {
			return xerrors.Errorf("cannot marshal t.OldMap map too large")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajMap, uint64(len(t.OldMap))); err != nil {
			return err
		}

		keys := make([]string, 0, len(t.OldMap))
		for k := range t.OldMap {
			keys = append(keys, k)
		}
		sort.Strings(keys)
		for _, k := range keys {
			v := t.OldMap[k]

			if len(k) > 8192 {
				return xerrors.Errorf("Value in field k was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(k))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(k)); err != nil {
				return err
			}

			if err := v.MarshalCBOR(cw); err != nil {
				return err
			}

		}
	}

	// t.OldNum (uint64) (uint64)
	if len("OldNum") > 8192 {
		return xerrors.Errorf("Value in field \"OldNum\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldNum"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldNum")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.OldNum)); err != nil {
		return err
	}

	// t.OldPtr (cid.Cid) (struct)
	if len("OldPtr") > 8192 {
		return xerrors.Errorf("Value in field \"OldPtr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldPtr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldPtr")); err != nil {
		return err
	}

	if t.OldPtr == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cbg.WriteCid(cw, *t.OldPtr); err != nil {
			return xerrors.Errorf("failed to write cid field t.OldPtr: %w", err)
		}
	}

	// t.OldStr (string) (string)
	if len("OldStr") > 8192 {
		return xerrors.Errorf("Value in field \"OldStr\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldStr"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldStr")); err != nil {
		return err
	}

	if len(t.OldStr) > 8192 {
		return xerrors.Errorf("Value in field t.OldStr was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.OldStr))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.OldStr)); err != nil {
		return err
	}

	// t.NewArray ([]testing.SimpleTypeOne) (slice)
	if len("NewArray") > 8192 {
		return xerrors.Errorf("Value in field \"NewArray\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewArray"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewArray")); err != nil {
		return err
	}

	if len(t.NewArray) > 8192 {
		return xerrors.Errorf("Slice value in field t.NewArray was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.NewArray))); err != nil {
		return err
	}
	for _, v := range t.NewArray {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.NewBytes ([]uint8) (slice)
	if len("NewBytes") > 8192 {
		return xerrors.Errorf("Value in field \"NewBytes\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewBytes"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewBytes")); err != nil {
		return err
	}

	if len(t.NewBytes) > 2097152 {
		return xerrors.Errorf("Byte array in field t.NewBytes was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.NewBytes))); err != nil {
		return err
	}

	if _, err := cw.Write(t.NewBytes); err != nil {
		return err
	}

	// t.OldArray ([]testing.SimpleTypeOne) (slice)
	if len("OldArray") > 8192 {
		return xerrors.Errorf("Value in field \"OldArray\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldArray"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldArray")); err != nil {
		return err
	}

	if len(t.OldArray) > 8192 {
		return xerrors.Errorf("Slice value in field t.OldArray was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.OldArray))); err != nil {
		return err
	}
	for _, v := range t.OldArray {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}

	}

	// t.OldBytes ([]uint8) (slice)
	if len("OldBytes") > 8192 {
		return xerrors.Errorf("Value in field \"OldBytes\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldBytes"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldBytes")); err != nil {
		return err
	}

	if len(t.OldBytes) > 2097152 {
		return xerrors.Errorf("Byte array in field t.OldBytes was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.OldBytes))); err != nil {
		return err
	}

	if _, err := cw.Write(t.OldBytes); err != nil {
		return err
	}

	// t.NewStruct (testing.SimpleTypeOne) (struct)
	if len("NewStruct") > 8192 {
		return xerrors.Errorf("Value in field \"NewStruct\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NewStruct"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NewStruct")); err != nil {
		return err
	}

	if err := t.NewStruct.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.OldStruct (testing.SimpleTypeOne) (struct)
	if len("OldStruct") > 8192 {
		return xerrors.Errorf("Value in field \"OldStruct\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("OldStruct"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("OldStruct")); err != nil {
		return err
	}

	if err := t.OldStruct.MarshalCBOR(cw); err != nil {
		return err
	}
	return nil
}

func (t *SimpleStructV2) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SimpleStructV2{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("SimpleStructV2: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.NewMap (map[string]testing.SimpleTypeOne) (map)
		case "NewMap":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajMap {
				return fmt.Errorf("expected a map (major type 5)")
			}
			if extra > 4096 {
				return fmt.Errorf("t.NewMap: map too large")
			}

			t.NewMap = make(map[string]SimpleTypeOne, extra)

			for i, l := 0, int(extra); i < l; i++ {

				var k string

				{
					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					k = string(sval)
				}

				var v SimpleTypeOne

				{

					if err := v.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling v: %w", err)
					}

				}

				t.NewMap[k] = v

			}
			// t.NewNum (uint64) (uint64)
		case "NewNum":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.NewNum = uint64(extra)

			}
			// t.NewPtr (cid.Cid) (struct)
		case "NewPtr":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					c, err := cbg.ReadCid(cr)
					if err != nil {
						return xerrors.Errorf("failed to read cid field t.NewPtr: %w", err)
					}

					t.NewPtr = &c
				}

			}
			// t.NewStr (string) (string)
		case "NewStr":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.NewStr = string(sval)
			}
			// t.OldMap (map[string]testing.SimpleTypeOne) (map)
		case "OldMap":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajMap {
				return fmt.Errorf("expected a map (major type 5)")
			}
			if extra > 4096 {
				return fmt.Errorf("t.OldMap: map too large")
			}

			t.OldMap = make(map[string]SimpleTypeOne, extra)

			for i, l := 0, int(extra); i < l; i++ {

				var k string

				{
					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					k = string(sval)
				}

				var v SimpleTypeOne

				{

					if err := v.UnmarshalCBOR(cr); err != nil {
						return xerrors.Errorf("unmarshaling v: %w", err)
					}

				}

				t.OldMap[k] = v

			}
			// t.OldNum (uint64) (uint64)
		case "OldNum":

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.OldNum = uint64(extra)

			}
			// t.OldPtr (cid.Cid) (struct)
		case "OldPtr":

			{

				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					c, err := cbg.ReadCid(cr)
					if err != nil {
						return xerrors.Errorf("failed to read cid field t.OldPtr: %w", err)
					}

					t.OldPtr = &c
				}

			}
			// t.OldStr (string) (string)
		case "OldStr":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.OldStr = string(sval)
			}
			// t.NewArray ([]testing.SimpleTypeOne) (slice)
		case "NewArray":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.NewArray: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.NewArray = make([]SimpleTypeOne, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.NewArray[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.NewArray[i]: %w", err)
						}

					}

				}
			}
			// t.NewBytes ([]uint8) (slice)
		case "NewBytes":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.NewBytes: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.NewBytes = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.NewBytes); err != nil {
				return err
			}

			// t.OldArray ([]testing.SimpleTypeOne) (slice)
		case "OldArray":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.OldArray: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.OldArray = make([]SimpleTypeOne, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						if err := t.OldArray[i].UnmarshalCBOR(cr); err != nil {
							return xerrors.Errorf("unmarshaling t.OldArray[i]: %w", err)
						}

					}

				}
			}
			// t.OldBytes ([]uint8) (slice)
		case "OldBytes":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.OldBytes: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.OldBytes = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.OldBytes); err != nil {
				return err
			}

			// t.NewStruct (testing.SimpleTypeOne) (struct)
		case "NewStruct":

			{

				if err := t.NewStruct.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.NewStruct: %w", err)
				}

			}
			// t.OldStruct (testing.SimpleTypeOne) (struct)
		case "OldStruct":

			{

				if err := t.OldStruct.UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.OldStruct: %w", err)
				}

			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *RenamedFields) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Foo (int64) (int64)
	if len("foo") > 8192 {
		return xerrors.Errorf("Value in field \"foo\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("foo"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("foo")); err != nil {
		return err
	}

	if t.Foo >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Foo)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Foo-1)); err != nil {
			return err
		}
	}

	// t.Bar (string) (string)
	if len("beep") > 8192 {
		return xerrors.Errorf("Value in field \"beep\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("beep"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("beep")); err != nil {
		return err
	}

	if len(t.Bar) > 8192 {
		return xerrors.Errorf("Value in field t.Bar was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Bar))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Bar)); err != nil {
		return err
	}
	return nil
}

func (t *RenamedFields) UnmarshalCBOR(r io.Reader) (err error) {
	*t = RenamedFields{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("RenamedFields: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Foo (int64) (int64)
		case "foo":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Foo = int64(extraI)
			}
			// t.Bar (string) (string)
		case "beep":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Bar = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *TestEmpty) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)
	fieldCount := 3

	if t.Foo == nil {
		fieldCount--
	}

	if t.Beep == "" {
		fieldCount--
	}

	if _, err := cw.Write(cbg.CborEncodeMajorType(cbg.MajMap, uint64(fieldCount))); err != nil {
		return err
	}

	// t.Cat (int64) (int64)
	if len("Cat") > 8192 {
		return xerrors.Errorf("Value in field \"Cat\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Cat"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Cat")); err != nil {
		return err
	}

	if t.Cat >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Cat)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Cat-1)); err != nil {
			return err
		}
	}

	// t.Foo (string) (string)
	if t.Foo != nil {

		if len("Foo") > 8192 {
			return xerrors.Errorf("Value in field \"Foo\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Foo"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("Foo")); err != nil {
			return err
		}

		if t.Foo == nil {
			if _, err := cw.Write(cbg.CborNull); err != nil {
				return err
			}
		} else {
			if len(*t.Foo) > 8192 {
				return xerrors.Errorf("Value in field t.Foo was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(*t.Foo))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(*t.Foo)); err != nil {
				return err
			}
		}
	}

	// t.Beep (string) (string)
	if t.Beep != "" {

		if len("Beep") > 8192 {
			return xerrors.Errorf("Value in field \"Beep\" was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Beep"))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string("Beep")); err != nil {
			return err
		}

		if len(t.Beep) > 8192 {
			return xerrors.Errorf("Value in field t.Beep was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Beep))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(t.Beep)); err != nil {
			return err
		}
	}
	return nil
}

func (t *TestEmpty) UnmarshalCBOR(r io.Reader) (err error) {
	*t = TestEmpty{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("TestEmpty: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cat (int64) (int64)
		case "Cat":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Cat = int64(extraI)
			}
			// t.Foo (string) (string)
		case "Foo":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					t.Foo = (*string)(&sval)
				}
			}
			// t.Beep (string) (string)
		case "Beep":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Beep = string(sval)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *TestConstField) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{162}); err != nil {
		return err
	}

	// t.Cats (string) (string)
	if len("Cats") > 8192 {
		return xerrors.Errorf("Value in field \"Cats\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Cats"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Cats")); err != nil {
		return err
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("dogsdrool"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("dogsdrool")); err != nil {
		return err
	}

	// t.Thing (int64) (int64)
	if len("Thing") > 8192 {
		return xerrors.Errorf("Value in field \"Thing\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Thing"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Thing")); err != nil {
		return err
	}

	if t.Thing >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Thing)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Thing-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *TestConstField) UnmarshalCBOR(r io.Reader) (err error) {
	*t = TestConstField{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("TestConstField: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cats (string) (string)
		case "Cats":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Cats = string(sval)
			}
			// t.Thing (int64) (int64)
		case "Thing":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Thing = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *TestCanonicalFieldOrder) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{164}); err != nil {
		return err
	}

	// t.Zp (string) (string)
	if len("ap") > 8192 {
		return xerrors.Errorf("Value in field \"ap\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("ap"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("ap")); err != nil {
		return err
	}

	if len(t.Zp) > 8192 {
		return xerrors.Errorf("Value in field t.Zp was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Zp))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Zp)); err != nil {
		return err
	}

	// t.Foo (int64) (int64)
	if len("foo") > 8192 {
		return xerrors.Errorf("Value in field \"foo\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("foo"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("foo")); err != nil {
		return err
	}

	if t.Foo >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Foo)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Foo-1)); err != nil {
			return err
		}
	}

	// t.Bar (string) (string)
	if len("beep") > 8192 {
		return xerrors.Errorf("Value in field \"beep\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("beep"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("beep")); err != nil {
		return err
	}

	if len(t.Bar) > 8192 {
		return xerrors.Errorf("Value in field t.Bar was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Bar))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Bar)); err != nil {
		return err
	}

	// t.Drond (int64) (int64)
	if len("Drond") > 8192 {
		return xerrors.Errorf("Value in field \"Drond\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Drond"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Drond")); err != nil {
		return err
	}

	if t.Drond >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Drond)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Drond-1)); err != nil {
			return err
		}
	}

	return nil
}

func (t *TestCanonicalFieldOrder) UnmarshalCBOR(r io.Reader) (err error) {
	*t = TestCanonicalFieldOrder{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("TestCanonicalFieldOrder: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Zp (string) (string)
		case "ap":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Zp = string(sval)
			}
			// t.Foo (int64) (int64)
		case "foo":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Foo = int64(extraI)
			}
			// t.Bar (string) (string)
		case "beep":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Bar = string(sval)
			}
			// t.Drond (int64) (int64)
		case "Drond":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Drond = int64(extraI)
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *MapStringString) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{161}); err != nil {
		return err
	}

	// t.Snorkleblump (map[string]string) (map)
	if len("Snorkleblump") > 8192 {
		return xerrors.Errorf("Value in field \"Snorkleblump\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Snorkleblump"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Snorkleblump")); err != nil {
		return err
	}

	{
		if len(t.Snorkleblump) > 4096 {
			return xerrors.Errorf("cannot marshal t.Snorkleblump map too large")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajMap, uint64(len(t.Snorkleblump))); err != nil {
			return err
		}

		keys := make([]string, 0, len(t.Snorkleblump))
		for k := range t.Snorkleblump {
			keys = append(keys, k)
		}
		sort.Strings(keys)
		for _, k := range keys {
			v := t.Snorkleblump[k]

			if len(k) > 8192 {
				return xerrors.Errorf("Value in field k was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(k))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(k)); err != nil {
				return err
			}

			if len(v) > 8192 {
				return xerrors.Errorf("Value in field v was too long")
			}

			if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
				return err
			}
			if _, err := cw.WriteString(string(v)); err != nil {
				return err
			}

		}
	}
	return nil
}

func (t *MapStringString) UnmarshalCBOR(r io.Reader) (err error) {
	*t = MapStringString{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("MapStringString: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Snorkleblump (map[string]string) (map)
		case "Snorkleblump":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajMap {
				return fmt.Errorf("expected a map (major type 5)")
			}
			if extra > 4096 {
				return fmt.Errorf("t.Snorkleblump: map too large")
			}

			t.Snorkleblump = make(map[string]string, extra)

			for i, l := 0, int(extra); i < l; i++ {

				var k string

				{
					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					k = string(sval)
				}

				var v string

				{
					sval, err := cbg.ReadStringWithMax(cr, 8192)
					if err != nil {
						return err
					}

					v = string(sval)
				}

				t.Snorkleblump[k] = v

			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
func (t *TestSliceNilPreserve) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write([]byte{166}); err != nil {
		return err
	}

	// t.Cat (string) (string)
	if len("Cat") > 8192 {
		return xerrors.Errorf("Value in field \"Cat\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Cat"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Cat")); err != nil {
		return err
	}

	if len(t.Cat) > 8192 {
		return xerrors.Errorf("Value in field t.Cat was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Cat))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Cat)); err != nil {
		return err
	}

	// t.Not ([]uint64) (slice)
	if len("Not") > 8192 {
		return xerrors.Errorf("Value in field \"Not\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Not"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Not")); err != nil {
		return err
	}

	if len(t.Not) > 8192 {
		return xerrors.Errorf("Slice value in field t.Not was too long")
	}

	if t.Not == nil {
		_, err := w.Write(cbg.CborNull)
		if err != nil {
			return err
		}
	} else {

		if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Not))); err != nil {
			return err
		}
		for _, v := range t.Not {

			if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
				return err
			}

		}

	}

	// t.Beep (int64) (int64)
	if len("Beep") > 8192 {
		return xerrors.Errorf("Value in field \"Beep\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Beep"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Beep")); err != nil {
		return err
	}

	if t.Beep >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Beep)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Beep-1)); err != nil {
			return err
		}
	}

	// t.Other ([]uint8) (slice)
	if len("Other") > 8192 {
		return xerrors.Errorf("Value in field \"Other\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Other"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Other")); err != nil {
		return err
	}

	if len(t.Other) > 2097152 {
		return xerrors.Errorf("Byte array in field t.Other was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Other))); err != nil {
		return err
	}

	if _, err := cw.Write(t.Other); err != nil {
		return err
	}

	// t.Stuff ([]uint64) (slice)
	if len("Stuff") > 8192 {
		return xerrors.Errorf("Value in field \"Stuff\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("Stuff"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("Stuff")); err != nil {
		return err
	}

	if len(t.Stuff) > 8192 {
		return xerrors.Errorf("Slice value in field t.Stuff was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Stuff))); err != nil {
		return err
	}
	for _, v := range t.Stuff {

		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
			return err
		}

	}

	// t.NotOther ([]uint8) (slice)
	if len("NotOther") > 8192 {
		return xerrors.Errorf("Value in field \"NotOther\" was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len("NotOther"))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string("NotOther")); err != nil {
		return err
	}

	if len(t.NotOther) > 2097152 {
		return xerrors.Errorf("Byte array in field t.NotOther was too long")
	}

	if t.NotOther == nil {
		_, err := w.Write(cbg.CborNull)
		if err != nil {
			return err
		}
	} else {

		if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.NotOther))); err != nil {
			return err
		}

		if _, err := cw.Write(t.NotOther); err != nil {
			return err
		}

	}

	return nil
}

func (t *TestSliceNilPreserve) UnmarshalCBOR(r io.Reader) (err error) {
	*t = TestSliceNilPreserve{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajMap {
		return fmt.Errorf("cbor input should be of type map")
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("TestSliceNilPreserve: map struct too large (%d)", extra)
	}

	var name string
	n := extra

	for i := uint64(0); i < n; i++ {

		{
			sval, err := cbg.ReadStringWithMax(cr, 8192)
			if err != nil {
				return err
			}

			name = string(sval)
		}

		switch name {
		// t.Cat (string) (string)
		case "Cat":

			{
				sval, err := cbg.ReadStringWithMax(cr, 8192)
				if err != nil {
					return err
				}

				t.Cat = string(sval)
			}
			// t.Not ([]uint64) (slice)
		case "Not":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}

					if extra > 8192 {
						return fmt.Errorf("t.Not: array too large (%d)", extra)
					}

					if maj != cbg.MajArray {
						return fmt.Errorf("expected cbor array")
					}

					t.Not = make([]uint64, extra)

					for i := 0; i < int(extra); i++ {
						{
							var maj byte
							var extra uint64
							var err error
							_ = maj
							_ = extra
							_ = err

							{

								maj, extra, err = cr.ReadHeader()
								if err != nil {
									return err
								}
								if maj != cbg.MajUnsignedInt {
									return fmt.Errorf("wrong type for uint64 field")
								}
								t.Not[i] = uint64(extra)

							}

						}
					}

				}
			}
			// t.Beep (int64) (int64)
		case "Beep":
			{
				maj, extra, err := cr.ReadHeader()
				if err != nil {
					return err
				}
				var extraI int64
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.Beep = int64(extraI)
			}
			// t.Other ([]uint8) (slice)
		case "Other":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 2097152 {
				return fmt.Errorf("t.Other: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.Other = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.Other); err != nil {
				return err
			}

			// t.Stuff ([]uint64) (slice)
		case "Stuff":

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > 8192 {
				return fmt.Errorf("t.Stuff: array too large (%d)", extra)
			}

			if maj != cbg.MajArray {
				return fmt.Errorf("expected cbor array")
			}

			if extra > 0 {
				t.Stuff = make([]uint64, extra)
			}

			for i := 0; i < int(extra); i++ {
				{
					var maj byte
					var extra uint64
					var err error
					_ = maj
					_ = extra
					_ = err

					{

						maj, extra, err = cr.ReadHeader()
						if err != nil {
							return err
						}
						if maj != cbg.MajUnsignedInt {
							return fmt.Errorf("wrong type for uint64 field")
						}
						t.Stuff[i] = uint64(extra)

					}

				}
			}
			// t.NotOther ([]uint8) (slice)
		case "NotOther":

			{
				b, err := cr.ReadByte()
				if err != nil {
					return err
				}
				if b != cbg.CborNull[0] {
					if err := cr.UnreadByte(); err != nil {
						return err
					}

					maj, extra, err = cr.ReadHeader()
					if err != nil {
						return err
					}

					if extra > 2097152 {
						return fmt.Errorf("t.NotOther: byte array too large (%d)", extra)
					}
					if maj != cbg.MajByteString {
						return fmt.Errorf("expected byte array")
					}

					t.NotOther = make([]uint8, extra)

					if _, err := io.ReadFull(cr, t.NotOther); err != nil {
						return err
					}

				}
			}

		default:
			// Field doesn't exist on this type, so ignore it
			cbg.ScanForLinks(r, func(cid.Cid) {})
		}
	}

	return nil
}
