/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.engine.behavior.ICache;
import org.apache.commons.jcs3.engine.behavior.ICacheEventQueue;

public class CacheListeners<K, V> {
    public final ICache<K, V> cache;
    public final ConcurrentMap<Long, ICacheEventQueue<K, V>> eventQMap = new ConcurrentHashMap<Long, ICacheEventQueue<K, V>>();

    public CacheListeners(ICache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache must not be null");
        }
        this.cache = cache;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n CacheListeners");
        buffer.append("\n Region = " + this.cache.getCacheName());
        buffer.append("\n Event Queue Map ");
        buffer.append("\n size = " + this.eventQMap.size());
        this.eventQMap.forEach((key, value) -> buffer.append("\n Entry: key: ").append(key).append(", value: ").append(value));
        return buffer.toString();
    }
}

