// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1experimental"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// Location describes function and line table debug information.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewLocation function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Location struct {
	orig  *otlpprofiles.Location
	state *internal.State
}

func newLocation(orig *otlpprofiles.Location, state *internal.State) Location {
	return Location{orig: orig, state: state}
}

// NewLocation creates a new empty Location.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewLocation() Location {
	state := internal.StateMutable
	return newLocation(&otlpprofiles.Location{}, &state)
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms Location) MoveTo(dest Location) {
	ms.state.AssertMutable()
	dest.state.AssertMutable()
	*dest.orig = *ms.orig
	*ms.orig = otlpprofiles.Location{}
}

// ID returns the id associated with this Location.
func (ms Location) ID() uint64 {
	return ms.orig.Id
}

// SetID replaces the id associated with this Location.
func (ms Location) SetID(v uint64) {
	ms.state.AssertMutable()
	ms.orig.Id = v
}

// MappingIndex returns the mappingindex associated with this Location.
func (ms Location) MappingIndex() uint64 {
	return ms.orig.MappingIndex
}

// SetMappingIndex replaces the mappingindex associated with this Location.
func (ms Location) SetMappingIndex(v uint64) {
	ms.state.AssertMutable()
	ms.orig.MappingIndex = v
}

// Address returns the address associated with this Location.
func (ms Location) Address() uint64 {
	return ms.orig.Address
}

// SetAddress replaces the address associated with this Location.
func (ms Location) SetAddress(v uint64) {
	ms.state.AssertMutable()
	ms.orig.Address = v
}

// Line returns the Line associated with this Location.
func (ms Location) Line() LineSlice {
	return newLineSlice(&ms.orig.Line, ms.state)
}

// IsFolded returns the isfolded associated with this Location.
func (ms Location) IsFolded() bool {
	return ms.orig.IsFolded
}

// SetIsFolded replaces the isfolded associated with this Location.
func (ms Location) SetIsFolded(v bool) {
	ms.state.AssertMutable()
	ms.orig.IsFolded = v
}

// TypeIndex returns the typeindex associated with this Location.
func (ms Location) TypeIndex() uint32 {
	return ms.orig.TypeIndex
}

// SetTypeIndex replaces the typeindex associated with this Location.
func (ms Location) SetTypeIndex(v uint32) {
	ms.state.AssertMutable()
	ms.orig.TypeIndex = v
}

// Attributes returns the Attributes associated with this Location.
func (ms Location) Attributes() pcommon.UInt64Slice {
	return pcommon.UInt64Slice(internal.NewUInt64Slice(&ms.orig.Attributes, ms.state))
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms Location) CopyTo(dest Location) {
	dest.state.AssertMutable()
	dest.SetID(ms.ID())
	dest.SetMappingIndex(ms.MappingIndex())
	dest.SetAddress(ms.Address())
	ms.Line().CopyTo(dest.Line())
	dest.SetIsFolded(ms.IsFolded())
	dest.SetTypeIndex(ms.TypeIndex())
	ms.Attributes().CopyTo(dest.Attributes())
}
