// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::start_async_invoke::_start_async_invoke_output::StartAsyncInvokeOutputBuilder;

pub use crate::operation::start_async_invoke::_start_async_invoke_input::StartAsyncInvokeInputBuilder;

impl crate::operation::start_async_invoke::builders::StartAsyncInvokeInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::start_async_invoke::StartAsyncInvokeOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_async_invoke::StartAsyncInvokeError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.start_async_invoke();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `StartAsyncInvoke`.
///
/// <p>Starts an asynchronous invocation.</p>
/// <p>This operation requires permission for the <code>bedrock:InvokeModel</code> action.</p><important>
/// <p>To deny all inference access to resources that you specify in the modelId field, you need to deny access to the <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also denies access to the resource through the Converse API actions (<a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>). For more information see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference">Deny access for inference on specific models</a>.</p>
/// </important>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct StartAsyncInvokeFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::start_async_invoke::builders::StartAsyncInvokeInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::start_async_invoke::StartAsyncInvokeOutput,
        crate::operation::start_async_invoke::StartAsyncInvokeError,
    > for StartAsyncInvokeFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::start_async_invoke::StartAsyncInvokeOutput,
            crate::operation::start_async_invoke::StartAsyncInvokeError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl StartAsyncInvokeFluentBuilder {
    /// Creates a new `StartAsyncInvokeFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the StartAsyncInvoke as a reference.
    pub fn as_input(&self) -> &crate::operation::start_async_invoke::builders::StartAsyncInvokeInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_async_invoke::StartAsyncInvokeOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_async_invoke::StartAsyncInvokeError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::start_async_invoke::StartAsyncInvoke::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::start_async_invoke::StartAsyncInvoke::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::start_async_invoke::StartAsyncInvokeOutput,
        crate::operation::start_async_invoke::StartAsyncInvokeError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn client_request_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.client_request_token(input.into());
        self
    }
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn set_client_request_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_client_request_token(input);
        self
    }
    /// <p>Specify idempotency token to ensure that requests are not duplicated.</p>
    pub fn get_client_request_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_client_request_token()
    }
    /// <p>The model to invoke.</p>
    pub fn model_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.model_id(input.into());
        self
    }
    /// <p>The model to invoke.</p>
    pub fn set_model_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_model_id(input);
        self
    }
    /// <p>The model to invoke.</p>
    pub fn get_model_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_model_id()
    }
    /// <p>Input to send to the model.</p>
    pub fn model_input(mut self, input: ::aws_smithy_types::Document) -> Self {
        self.inner = self.inner.model_input(input);
        self
    }
    /// <p>Input to send to the model.</p>
    pub fn set_model_input(mut self, input: ::std::option::Option<::aws_smithy_types::Document>) -> Self {
        self.inner = self.inner.set_model_input(input);
        self
    }
    /// <p>Input to send to the model.</p>
    pub fn get_model_input(&self) -> &::std::option::Option<::aws_smithy_types::Document> {
        self.inner.get_model_input()
    }
    /// <p>Where to store the output.</p>
    pub fn output_data_config(mut self, input: crate::types::AsyncInvokeOutputDataConfig) -> Self {
        self.inner = self.inner.output_data_config(input);
        self
    }
    /// <p>Where to store the output.</p>
    pub fn set_output_data_config(mut self, input: ::std::option::Option<crate::types::AsyncInvokeOutputDataConfig>) -> Self {
        self.inner = self.inner.set_output_data_config(input);
        self
    }
    /// <p>Where to store the output.</p>
    pub fn get_output_data_config(&self) -> &::std::option::Option<crate::types::AsyncInvokeOutputDataConfig> {
        self.inner.get_output_data_config()
    }
    ///
    /// Appends an item to `tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>Tags to apply to the invocation.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        self.inner = self.inner.tags(input);
        self
    }
    /// <p>Tags to apply to the invocation.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.inner = self.inner.set_tags(input);
        self
    }
    /// <p>Tags to apply to the invocation.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        self.inner.get_tags()
    }
}
