//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLTextureType(pub NSUInteger);
impl MTLTextureType {
    pub const MTLTextureType1D: Self = Self(0);
    pub const MTLTextureType1DArray: Self = Self(1);
    pub const MTLTextureType2D: Self = Self(2);
    pub const MTLTextureType2DArray: Self = Self(3);
    pub const MTLTextureType2DMultisample: Self = Self(4);
    #[doc(alias = "MTLTextureTypeCube")]
    pub const Cube: Self = Self(5);
    #[doc(alias = "MTLTextureTypeCubeArray")]
    pub const CubeArray: Self = Self(6);
    pub const MTLTextureType3D: Self = Self(7);
    pub const MTLTextureType2DMultisampleArray: Self = Self(8);
    #[doc(alias = "MTLTextureTypeTextureBuffer")]
    pub const TextureBuffer: Self = Self(9);
}

unsafe impl Encode for MTLTextureType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLTextureType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLTextureSwizzle(pub u8);
impl MTLTextureSwizzle {
    #[doc(alias = "MTLTextureSwizzleZero")]
    pub const Zero: Self = Self(0);
    #[doc(alias = "MTLTextureSwizzleOne")]
    pub const One: Self = Self(1);
    #[doc(alias = "MTLTextureSwizzleRed")]
    pub const Red: Self = Self(2);
    #[doc(alias = "MTLTextureSwizzleGreen")]
    pub const Green: Self = Self(3);
    #[doc(alias = "MTLTextureSwizzleBlue")]
    pub const Blue: Self = Self(4);
    #[doc(alias = "MTLTextureSwizzleAlpha")]
    pub const Alpha: Self = Self(5);
}

unsafe impl Encode for MTLTextureSwizzle {
    const ENCODING: Encoding = u8::ENCODING;
}

unsafe impl RefEncode for MTLTextureSwizzle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLTextureSwizzleChannels {
    pub red: MTLTextureSwizzle,
    pub green: MTLTextureSwizzle,
    pub blue: MTLTextureSwizzle,
    pub alpha: MTLTextureSwizzle,
}

unsafe impl Encode for MTLTextureSwizzleChannels {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <MTLTextureSwizzle>::ENCODING,
            <MTLTextureSwizzle>::ENCODING,
            <MTLTextureSwizzle>::ENCODING,
            <MTLTextureSwizzle>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLTextureSwizzleChannels {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// TODO: pub fn MTLTextureSwizzleChannelsMake(r: MTLTextureSwizzle,g: MTLTextureSwizzle,b: MTLTextureSwizzle,a: MTLTextureSwizzle,) -> MTLTextureSwizzleChannels;

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLSharedTextureHandle;

    unsafe impl ClassType for MTLSharedTextureHandle {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCoding for MTLSharedTextureHandle {}

unsafe impl NSObjectProtocol for MTLSharedTextureHandle {}

unsafe impl NSSecureCoding for MTLSharedTextureHandle {}

extern_methods!(
    unsafe impl MTLSharedTextureHandle {
        #[cfg(feature = "MTLDevice")]
        #[method_id(@__retain_semantics Other device)]
        pub fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        #[method_id(@__retain_semantics Other label)]
        pub fn label(&self) -> Option<Retained<NSString>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLSharedTextureHandle {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLTextureUsage(pub NSUInteger);
bitflags::bitflags! {
    impl MTLTextureUsage: NSUInteger {
        #[doc(alias = "MTLTextureUsageUnknown")]
        const Unknown = 0x0000;
        #[doc(alias = "MTLTextureUsageShaderRead")]
        const ShaderRead = 0x0001;
        #[doc(alias = "MTLTextureUsageShaderWrite")]
        const ShaderWrite = 0x0002;
        #[doc(alias = "MTLTextureUsageRenderTarget")]
        const RenderTarget = 0x0004;
        #[doc(alias = "MTLTextureUsagePixelFormatView")]
        const PixelFormatView = 0x0010;
        #[doc(alias = "MTLTextureUsageShaderAtomic")]
        const ShaderAtomic = 0x0020;
    }
}

unsafe impl Encode for MTLTextureUsage {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLTextureUsage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLTextureCompressionType(pub NSInteger);
impl MTLTextureCompressionType {
    #[doc(alias = "MTLTextureCompressionTypeLossless")]
    pub const Lossless: Self = Self(0);
    #[doc(alias = "MTLTextureCompressionTypeLossy")]
    pub const Lossy: Self = Self(1);
}

unsafe impl Encode for MTLTextureCompressionType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLTextureCompressionType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLTextureDescriptor;

    unsafe impl ClassType for MTLTextureDescriptor {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLTextureDescriptor {}

unsafe impl NSObjectProtocol for MTLTextureDescriptor {}

extern_methods!(
    unsafe impl MTLTextureDescriptor {
        #[cfg(feature = "MTLPixelFormat")]
        #[method_id(@__retain_semantics Other texture2DDescriptorWithPixelFormat:width:height:mipmapped:)]
        pub unsafe fn texture2DDescriptorWithPixelFormat_width_height_mipmapped(
            pixel_format: MTLPixelFormat,
            width: NSUInteger,
            height: NSUInteger,
            mipmapped: bool,
        ) -> Retained<MTLTextureDescriptor>;

        #[cfg(feature = "MTLPixelFormat")]
        #[method_id(@__retain_semantics Other textureCubeDescriptorWithPixelFormat:size:mipmapped:)]
        pub unsafe fn textureCubeDescriptorWithPixelFormat_size_mipmapped(
            pixel_format: MTLPixelFormat,
            size: NSUInteger,
            mipmapped: bool,
        ) -> Retained<MTLTextureDescriptor>;

        #[cfg(all(feature = "MTLPixelFormat", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other textureBufferDescriptorWithPixelFormat:width:resourceOptions:usage:)]
        pub unsafe fn textureBufferDescriptorWithPixelFormat_width_resourceOptions_usage(
            pixel_format: MTLPixelFormat,
            width: NSUInteger,
            resource_options: MTLResourceOptions,
            usage: MTLTextureUsage,
        ) -> Retained<MTLTextureDescriptor>;

        #[method(textureType)]
        pub fn textureType(&self) -> MTLTextureType;

        #[method(setTextureType:)]
        pub fn setTextureType(&self, texture_type: MTLTextureType);

        #[cfg(feature = "MTLPixelFormat")]
        #[method(pixelFormat)]
        pub fn pixelFormat(&self) -> MTLPixelFormat;

        #[cfg(feature = "MTLPixelFormat")]
        #[method(setPixelFormat:)]
        pub fn setPixelFormat(&self, pixel_format: MTLPixelFormat);

        #[method(width)]
        pub fn width(&self) -> NSUInteger;

        #[method(setWidth:)]
        pub unsafe fn setWidth(&self, width: NSUInteger);

        #[method(height)]
        pub fn height(&self) -> NSUInteger;

        #[method(setHeight:)]
        pub unsafe fn setHeight(&self, height: NSUInteger);

        #[method(depth)]
        pub fn depth(&self) -> NSUInteger;

        #[method(setDepth:)]
        pub unsafe fn setDepth(&self, depth: NSUInteger);

        #[method(mipmapLevelCount)]
        pub fn mipmapLevelCount(&self) -> NSUInteger;

        #[method(setMipmapLevelCount:)]
        pub unsafe fn setMipmapLevelCount(&self, mipmap_level_count: NSUInteger);

        #[method(sampleCount)]
        pub fn sampleCount(&self) -> NSUInteger;

        #[method(setSampleCount:)]
        pub unsafe fn setSampleCount(&self, sample_count: NSUInteger);

        #[method(arrayLength)]
        pub fn arrayLength(&self) -> NSUInteger;

        #[method(setArrayLength:)]
        pub unsafe fn setArrayLength(&self, array_length: NSUInteger);

        #[cfg(feature = "MTLResource")]
        #[method(resourceOptions)]
        pub fn resourceOptions(&self) -> MTLResourceOptions;

        #[cfg(feature = "MTLResource")]
        #[method(setResourceOptions:)]
        pub fn setResourceOptions(&self, resource_options: MTLResourceOptions);

        #[cfg(feature = "MTLResource")]
        #[method(cpuCacheMode)]
        pub fn cpuCacheMode(&self) -> MTLCPUCacheMode;

        #[cfg(feature = "MTLResource")]
        #[method(setCpuCacheMode:)]
        pub fn setCpuCacheMode(&self, cpu_cache_mode: MTLCPUCacheMode);

        #[cfg(feature = "MTLResource")]
        #[method(storageMode)]
        pub fn storageMode(&self) -> MTLStorageMode;

        #[cfg(feature = "MTLResource")]
        #[method(setStorageMode:)]
        pub fn setStorageMode(&self, storage_mode: MTLStorageMode);

        #[cfg(feature = "MTLResource")]
        #[method(hazardTrackingMode)]
        pub fn hazardTrackingMode(&self) -> MTLHazardTrackingMode;

        #[cfg(feature = "MTLResource")]
        #[method(setHazardTrackingMode:)]
        pub fn setHazardTrackingMode(&self, hazard_tracking_mode: MTLHazardTrackingMode);

        #[method(usage)]
        pub fn usage(&self) -> MTLTextureUsage;

        #[method(setUsage:)]
        pub fn setUsage(&self, usage: MTLTextureUsage);

        #[method(allowGPUOptimizedContents)]
        pub fn allowGPUOptimizedContents(&self) -> bool;

        #[method(setAllowGPUOptimizedContents:)]
        pub fn setAllowGPUOptimizedContents(&self, allow_gpu_optimized_contents: bool);

        #[method(compressionType)]
        pub unsafe fn compressionType(&self) -> MTLTextureCompressionType;

        #[method(setCompressionType:)]
        pub unsafe fn setCompressionType(&self, compression_type: MTLTextureCompressionType);

        #[method(swizzle)]
        pub fn swizzle(&self) -> MTLTextureSwizzleChannels;

        #[method(setSwizzle:)]
        pub fn setSwizzle(&self, swizzle: MTLTextureSwizzleChannels);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLTextureDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_protocol!(
    #[cfg(feature = "MTLResource")]
    pub unsafe trait MTLTexture: MTLResource + IsRetainable {
        #[deprecated = "Use parentTexture or buffer instead"]
        #[method_id(@__retain_semantics Other rootResource)]
        fn rootResource(&self) -> Option<Retained<ProtocolObject<dyn MTLResource>>>;

        #[method_id(@__retain_semantics Other parentTexture)]
        fn parentTexture(&self) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[method(parentRelativeLevel)]
        fn parentRelativeLevel(&self) -> NSUInteger;

        #[method(parentRelativeSlice)]
        fn parentRelativeSlice(&self) -> NSUInteger;

        #[cfg(feature = "MTLBuffer")]
        #[method_id(@__retain_semantics Other buffer)]
        fn buffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[method(bufferOffset)]
        fn bufferOffset(&self) -> NSUInteger;

        #[method(bufferBytesPerRow)]
        fn bufferBytesPerRow(&self) -> NSUInteger;

        #[method(iosurfacePlane)]
        fn iosurfacePlane(&self) -> NSUInteger;

        #[method(textureType)]
        fn textureType(&self) -> MTLTextureType;

        #[cfg(feature = "MTLPixelFormat")]
        #[method(pixelFormat)]
        fn pixelFormat(&self) -> MTLPixelFormat;

        #[method(width)]
        fn width(&self) -> NSUInteger;

        #[method(height)]
        fn height(&self) -> NSUInteger;

        #[method(depth)]
        fn depth(&self) -> NSUInteger;

        #[method(mipmapLevelCount)]
        fn mipmapLevelCount(&self) -> NSUInteger;

        #[method(sampleCount)]
        fn sampleCount(&self) -> NSUInteger;

        #[method(arrayLength)]
        fn arrayLength(&self) -> NSUInteger;

        #[method(usage)]
        fn usage(&self) -> MTLTextureUsage;

        #[method(isShareable)]
        fn isShareable(&self) -> bool;

        #[method(isFramebufferOnly)]
        fn isFramebufferOnly(&self) -> bool;

        #[optional]
        #[method(firstMipmapInTail)]
        fn firstMipmapInTail(&self) -> NSUInteger;

        #[optional]
        #[method(tailSizeInBytes)]
        fn tailSizeInBytes(&self) -> NSUInteger;

        #[optional]
        #[method(isSparse)]
        fn isSparse(&self) -> bool;

        #[method(allowGPUOptimizedContents)]
        fn allowGPUOptimizedContents(&self) -> bool;

        #[method(compressionType)]
        unsafe fn compressionType(&self) -> MTLTextureCompressionType;

        #[cfg(feature = "MTLTypes")]
        #[method(gpuResourceID)]
        unsafe fn gpuResourceID(&self) -> MTLResourceID;

        #[cfg(feature = "MTLTypes")]
        #[method(getBytes:bytesPerRow:bytesPerImage:fromRegion:mipmapLevel:slice:)]
        unsafe fn getBytes_bytesPerRow_bytesPerImage_fromRegion_mipmapLevel_slice(
            &self,
            pixel_bytes: NonNull<c_void>,
            bytes_per_row: NSUInteger,
            bytes_per_image: NSUInteger,
            region: MTLRegion,
            level: NSUInteger,
            slice: NSUInteger,
        );

        #[cfg(feature = "MTLTypes")]
        #[method(replaceRegion:mipmapLevel:slice:withBytes:bytesPerRow:bytesPerImage:)]
        unsafe fn replaceRegion_mipmapLevel_slice_withBytes_bytesPerRow_bytesPerImage(
            &self,
            region: MTLRegion,
            level: NSUInteger,
            slice: NSUInteger,
            pixel_bytes: NonNull<c_void>,
            bytes_per_row: NSUInteger,
            bytes_per_image: NSUInteger,
        );

        #[cfg(feature = "MTLTypes")]
        #[method(getBytes:bytesPerRow:fromRegion:mipmapLevel:)]
        unsafe fn getBytes_bytesPerRow_fromRegion_mipmapLevel(
            &self,
            pixel_bytes: NonNull<c_void>,
            bytes_per_row: NSUInteger,
            region: MTLRegion,
            level: NSUInteger,
        );

        #[cfg(feature = "MTLTypes")]
        #[method(replaceRegion:mipmapLevel:withBytes:bytesPerRow:)]
        unsafe fn replaceRegion_mipmapLevel_withBytes_bytesPerRow(
            &self,
            region: MTLRegion,
            level: NSUInteger,
            pixel_bytes: NonNull<c_void>,
            bytes_per_row: NSUInteger,
        );

        #[cfg(feature = "MTLPixelFormat")]
        #[method_id(@__retain_semantics New newTextureViewWithPixelFormat:)]
        fn newTextureViewWithPixelFormat(
            &self,
            pixel_format: MTLPixelFormat,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[cfg(feature = "MTLPixelFormat")]
        #[method_id(@__retain_semantics New newTextureViewWithPixelFormat:textureType:levels:slices:)]
        unsafe fn newTextureViewWithPixelFormat_textureType_levels_slices(
            &self,
            pixel_format: MTLPixelFormat,
            texture_type: MTLTextureType,
            level_range: NSRange,
            slice_range: NSRange,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[method_id(@__retain_semantics New newSharedTextureHandle)]
        fn newSharedTextureHandle(&self) -> Option<Retained<MTLSharedTextureHandle>>;

        #[method_id(@__retain_semantics Other remoteStorageTexture)]
        fn remoteStorageTexture(&self) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[cfg(feature = "MTLDevice")]
        #[method_id(@__retain_semantics New newRemoteTextureViewForDevice:)]
        unsafe fn newRemoteTextureViewForDevice(
            &self,
            device: &ProtocolObject<dyn MTLDevice>,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[method(swizzle)]
        fn swizzle(&self) -> MTLTextureSwizzleChannels;

        #[cfg(feature = "MTLPixelFormat")]
        #[method_id(@__retain_semantics New newTextureViewWithPixelFormat:textureType:levels:slices:swizzle:)]
        unsafe fn newTextureViewWithPixelFormat_textureType_levels_slices_swizzle(
            &self,
            pixel_format: MTLPixelFormat,
            texture_type: MTLTextureType,
            level_range: NSRange,
            slice_range: NSRange,
            swizzle: MTLTextureSwizzleChannels,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;
    }

    #[cfg(feature = "MTLResource")]
    unsafe impl ProtocolType for dyn MTLTexture {}
);
