// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <giomm/settings.h>
#include <giomm/private/settings_p.h>


/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gio/gio.h>
#include <glibmm/exceptionhandler.h>
#include <glibmm/vectorutils.h>
#include <giomm/settingsschema.h>

namespace
{
struct SettingsMapSlots
{
  SettingsMapSlots(const Gio::Settings::SlotGetMapping& get_mapping,
    const Gio::Settings::SlotSetMapping& set_mapping)
  : from_setting_to_property(get_mapping), from_property_to_setting(set_mapping)
  {
  }

  Gio::Settings::SlotGetMapping from_setting_to_property;
  Gio::Settings::SlotSetMapping from_property_to_setting;
};

extern "C"
{
// Shall be static. Non-static functions with C linkage get external linkage,
// even if they are defined in an anonymous namespace.
static gboolean
Settings_get_mapping_callback(
  GValue* to_value, GVariant* from_variant, gpointer user_data)
{
  Gio::Settings::SlotGetMapping& the_slot =
    static_cast<SettingsMapSlots*>(user_data)->from_setting_to_property;

  bool result = false;
  try
  {
    result = the_slot(to_value, from_variant);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
  return result;
}

static GVariant*
Settings_set_mapping_callback(
  const GValue* from_value, const GVariantType* expected_type, gpointer user_data)
{
  Gio::Settings::SlotSetMapping& the_slot =
    static_cast<SettingsMapSlots*>(user_data)->from_property_to_setting;

  GVariant* result = nullptr;
  try
  {
    result = the_slot(from_value, expected_type);
  }
  catch (...)
  {
    Glib::exception_handlers_invoke();
  }
  return result;
}

static void
Settings_map_callback_destroy(gpointer user_data)
{
  delete static_cast<SettingsMapSlots*>(user_data);
}
} // extern "C"
} // anonymous namespace

namespace Gio
{

void Settings::bind_value(const Glib::ustring& key,
  Glib::ObjectBase* object, const Glib::ustring& property, BindFlags flags,
  const SlotGetMapping& get_mapping, const SlotSetMapping& set_mapping)
{
  if (get_mapping.empty() && set_mapping.empty())
  {
    // No user-supplied mappings.
    g_settings_bind(gobj(), key.c_str(), object->gobj(),
      property.c_str(), (GSettingsBindFlags)flags);
  }
  else
  {
    // Create copies of the slots. A pointer to this will be passed
    // through the callback's data parameter. It will be deleted
    // when Settings_map_callback_destroy() is called.
    SettingsMapSlots* slots_copy = new SettingsMapSlots(get_mapping, set_mapping);

    g_settings_bind_with_mapping(gobj(), key.c_str(),
      object->gobj(), property.c_str(), (GSettingsBindFlags)flags,
      get_mapping.empty() ? nullptr : &Settings_get_mapping_callback,
      set_mapping.empty() ? nullptr : &Settings_set_mapping_callback, slots_copy,
      &Settings_map_callback_destroy);
  }
}

void
Settings::get_value(const Glib::ustring& key, Glib::VariantBase& value) const
{
  const auto g_value = g_settings_get_value(const_cast<GSettings*>(gobj()), key.c_str());
  if (!g_value)
    return;

  value.init(g_value, false /* don't take a reference */);
}

bool
Settings::get_user_value(const Glib::ustring& key, Glib::VariantBase& value) const
{
  const auto g_value = g_settings_get_user_value(const_cast<GSettings*>(gobj()), key.c_str());
  if (!g_value)
    return false;

  value.init(g_value, false /* don't take a reference */);
  return true;
}

void
Settings::get_default_value(const Glib::ustring& key, Glib::VariantBase& value) const
{
  const auto g_value = g_settings_get_default_value(const_cast<GSettings*>(gobj()), key.c_str());
  if (!g_value)
    return;

  value.init(g_value, false /* don't take a reference */);
}
void
Settings::bind(
  const Glib::ustring& key, const Glib::PropertyProxy_Base& property_proxy, BindFlags flags)
{
  bind(key, property_proxy.get_object(), property_proxy.get_name(), flags);
}

void
Settings::bind_writable(
  const Glib::ustring& key, const Glib::PropertyProxy_Base& property_proxy, bool inverted)
{
  bind_writable(key, property_proxy.get_object(), property_proxy.get_name(), inverted);
}

//static
void Settings::unbind(const Glib::PropertyProxy_Base& property_proxy)
{
  unbind(property_proxy.get_object(), property_proxy.get_name());
}

}

namespace
{


extern "C" {
static void Settings_signal_changed_connect_callback(GSettings* self, const gchar* p0,void* data)
{
  using namespace Gio;
  using SlotType = sigc::slot<void(const Glib::ustring&)>;

  auto obj = dynamic_cast<Settings*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::convert_const_gchar_ptr_to_ustring(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}
} // extern "C"

static const Glib::SignalProxyInfo Settings_signal_changed_info =
{
  "changed",
  (GCallback) &Settings_signal_changed_connect_callback,
  (GCallback) &Settings_signal_changed_connect_callback
};


using Settings_signal_changed_functype = void (*)(GSettings* self, const gchar* p0);
Settings_signal_changed_functype Settings_signal_changed_funcptr;
extern "C" {
static void Settings_signal_changed_default_callback(GSettings* self, const gchar* p0)
{
  Settings_signal_changed_funcptr( self, p0);
}
} // extern "C"


extern "C" {
static gboolean Settings_signal_writable_change_event_connect_callback(GSettings* self, GQuark p0,void* data)
{
  using namespace Gio;
  using SlotType = sigc::slot<bool(GQuark)>;

  auto obj = dynamic_cast<Settings*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Settings_signal_writable_change_event_notify_callback(GSettings* self, GQuark p0, void* data)
{
  using namespace Gio;
  using SlotType = sigc::slot<void(GQuark)>;

  auto obj = dynamic_cast<Settings*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}
} // extern "C"

static const Glib::SignalProxyInfo Settings_signal_writable_change_event_info =
{
  "writable-change-event",
  (GCallback) &Settings_signal_writable_change_event_connect_callback,
  (GCallback) &Settings_signal_writable_change_event_notify_callback
};


using Settings_signal_writable_change_event_functype = gboolean (*)(GSettings* self, GQuark p0);
Settings_signal_writable_change_event_functype Settings_signal_writable_change_event_funcptr;
extern "C" {
static gboolean Settings_signal_writable_change_event_default_callback(GSettings* self, GQuark p0)
{
  return Settings_signal_writable_change_event_funcptr( self, p0);
}
} // extern "C"


extern "C" {
static void Settings_signal_writable_changed_connect_callback(GSettings* self, const gchar* p0,void* data)
{
  using namespace Gio;
  using SlotType = sigc::slot<void(const Glib::ustring&)>;

  auto obj = dynamic_cast<Settings*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::convert_const_gchar_ptr_to_ustring(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}
} // extern "C"

static const Glib::SignalProxyInfo Settings_signal_writable_changed_info =
{
  "writable_changed",
  (GCallback) &Settings_signal_writable_changed_connect_callback,
  (GCallback) &Settings_signal_writable_changed_connect_callback
};


using Settings_signal_writable_changed_functype = void (*)(GSettings* self, const gchar* p0);
Settings_signal_writable_changed_functype Settings_signal_writable_changed_funcptr;
extern "C" {
static void Settings_signal_writable_changed_default_callback(GSettings* self, const gchar* p0)
{
  Settings_signal_writable_changed_funcptr( self, p0);
}
} // extern "C"
} // anonymous namespace

// static
GType Glib::Value<Gio::Settings::BindFlags>::value_type()
{
  return g_settings_bind_flags_get_type();
}


namespace Glib
{

Glib::RefPtr<Gio::Settings> wrap(GSettings* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gio::Settings>( dynamic_cast<Gio::Settings*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& Settings_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Settings_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_settings_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Settings_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->changed = &Settings_signal_changed_default_callback;
  Settings_signal_changed_funcptr = &changed_callback;
  klass->writable_change_event = &Settings_signal_writable_change_event_default_callback;
  Settings_signal_writable_change_event_funcptr = &writable_change_event_callback;
  klass->writable_changed = &Settings_signal_writable_changed_default_callback;
  Settings_signal_writable_changed_funcptr = &writable_changed_callback;
}


void Settings_Class::changed_callback(GSettings* self, const gchar* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_changed(Glib::convert_const_gchar_ptr_to_ustring(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->changed)
    (*base->changed)(self, p0);
}
gboolean Settings_Class::writable_change_event_callback(GSettings* self, GQuark p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_writable_change_event(p0));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->writable_change_event)
    return (*base->writable_change_event)(self, p0);

  using RType = gboolean;
  return RType();
}
void Settings_Class::writable_changed_callback(GSettings* self, const gchar* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_writable_changed(Glib::convert_const_gchar_ptr_to_ustring(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->writable_changed)
    (*base->writable_changed)(self, p0);
}


Glib::ObjectBase* Settings_Class::wrap_new(GObject* object)
{
  return new Settings((GSettings*)object);
}


/* The implementation: */

GSettings* Settings::gobj_copy()
{
  reference();
  return gobj();
}

Settings::Settings(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Settings::Settings(GSettings* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Settings::Settings(Settings&& src) noexcept
: Glib::Object(std::move(src))
{}

Settings& Settings::operator=(Settings&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


Settings::~Settings() noexcept
{}


Settings::CppClassType Settings::settings_class_; // initialize static member

GType Settings::get_type()
{
  return settings_class_.init().get_type();
}


GType Settings::get_base_type()
{
  return g_settings_get_type();
}


Settings::Settings(const Glib::ustring& schema_id)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(settings_class_.init(), "schema_id", schema_id.c_str(), nullptr))
{
  

}

Settings::Settings(const Glib::ustring& schema_id, const Glib::ustring& path)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(settings_class_.init(), "schema_id", schema_id.c_str(), "path", path.c_str(), nullptr))
{
  

}

Glib::RefPtr<Settings> Settings::create(const Glib::ustring& schema_id)
{
  return Glib::make_refptr_for_instance<Settings>( new Settings(schema_id) );
}

Glib::RefPtr<Settings> Settings::create(const Glib::ustring& schema_id, const Glib::ustring& path)
{
  return Glib::make_refptr_for_instance<Settings>( new Settings(schema_id, path) );
}

bool Settings::set_value(const Glib::ustring& key, const Glib::VariantBase& value)
{
  return g_settings_set_value(gobj(), key.c_str(), const_cast<GVariant*>((value).gobj()));
}

int Settings::get_int(const Glib::ustring& key) const
{
  return g_settings_get_int(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_int(const Glib::ustring& key, int value)
{
  return g_settings_set_int(gobj(), key.c_str(), value);
}

gint64 Settings::get_int64(const Glib::ustring& key) const
{
  return g_settings_get_int64(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_int64(const Glib::ustring& key, gint64 value)
{
  return g_settings_set_int64(gobj(), key.c_str(), value);
}

guint Settings::get_uint(const Glib::ustring& key) const
{
  return g_settings_get_uint(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_uint(const Glib::ustring& key, guint value)
{
  return g_settings_set_uint(gobj(), key.c_str(), value);
}

guint64 Settings::get_uint64(const Glib::ustring& key) const
{
  return g_settings_get_uint64(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_uint64(const Glib::ustring& key, guint64 value)
{
  return g_settings_set_uint64(gobj(), key.c_str(), value);
}

bool Settings::get_boolean(const Glib::ustring& key) const
{
  return g_settings_get_boolean(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_boolean(const Glib::ustring& key, bool value)
{
  return g_settings_set_boolean(gobj(), key.c_str(), static_cast<int>(value));
}

Glib::ustring Settings::get_string(const Glib::ustring& key) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(g_settings_get_string(const_cast<GSettings*>(gobj()), key.c_str()));
}

bool Settings::set_string(const Glib::ustring& key, const Glib::ustring& value)
{
  return g_settings_set_string(gobj(), key.c_str(), value.c_str());
}

double Settings::get_double(const Glib::ustring& key) const
{
  return g_settings_get_double(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_double(const Glib::ustring& key, double value)
{
  return g_settings_set_double(gobj(), key.c_str(), value);
}

std::vector<Glib::ustring> Settings::get_string_array(const Glib::ustring& key) const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(g_settings_get_strv(const_cast<GSettings*>(gobj()), key.c_str()), Glib::OWNERSHIP_DEEP);
}

bool Settings::set_string_array(const Glib::ustring& key, const std::vector<Glib::ustring>& value)
{
  return g_settings_set_strv(gobj(), key.c_str(), Glib::ArrayHandler<Glib::ustring>::vector_to_array(value).data());
}

int Settings::get_enum(const Glib::ustring& key) const
{
  return g_settings_get_enum(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_enum(const Glib::ustring& key, int value)
{
  return g_settings_set_enum(gobj(), key.c_str(), value);
}

guint Settings::get_flags(const Glib::ustring& key) const
{
  return g_settings_get_flags(const_cast<GSettings*>(gobj()), key.c_str());
}

bool Settings::set_flags(const Glib::ustring& key, guint value)
{
  return g_settings_set_flags(gobj(), key.c_str(), value);
}

Glib::RefPtr<Settings> Settings::get_child(const Glib::ustring& name)
{
  return Glib::wrap(g_settings_get_child(gobj(), name.c_str()));
}

Glib::RefPtr<const Settings> Settings::get_child(const Glib::ustring& name) const
{
  return const_cast<Settings*>(this)->get_child(name);
}

bool Settings::is_writable(const Glib::ustring& name) const
{
  return g_settings_is_writable(const_cast<GSettings*>(gobj()), name.c_str());
}

void Settings::delay()
{
  g_settings_delay(gobj());
}

void Settings::apply()
{
  g_settings_apply(gobj());
}

void Settings::revert()
{
  g_settings_revert(gobj());
}

bool Settings::get_has_unapplied() const
{
  return g_settings_get_has_unapplied(const_cast<GSettings*>(gobj()));
}

void Settings::reset(const Glib::ustring& key)
{
  g_settings_reset(gobj(), key.c_str());
}

std::vector<Glib::ustring> Settings::list_children() const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(g_settings_list_children(const_cast<GSettings*>(gobj())), Glib::OWNERSHIP_DEEP);
}

void Settings::bind(const Glib::ustring& key, Glib::ObjectBase* object, const Glib::ustring& property, BindFlags flags)
{
  g_settings_bind(gobj(), key.c_str(), (gpointer)object->gobj(), property.c_str(), static_cast<GSettingsBindFlags>(flags));
}

void Settings::bind_writable(const Glib::ustring& key, Glib::ObjectBase* object, const Glib::ustring& property, bool inverted)
{
  g_settings_bind_writable(gobj(), key.c_str(), (gpointer)object->gobj(), property.c_str(), static_cast<int>(inverted));
}

void Settings::unbind(Glib::ObjectBase* object, const Glib::ustring& property)
{
  g_settings_unbind((gpointer)object->gobj(), property.c_str());
}

Glib::RefPtr<Action> Settings::create_action(const Glib::ustring& key)
{
  return Glib::wrap(g_settings_create_action(gobj(), key.c_str()));
}


Glib::SignalProxyDetailed<void(const Glib::ustring&)> Settings::signal_changed(const Glib::ustring& key)
{
  return Glib::SignalProxyDetailed<void(const Glib::ustring&)>(this, &Settings_signal_changed_info, key);
}


Glib::SignalProxy<bool(GQuark)> Settings::signal_writable_change_event()
{
  return Glib::SignalProxy<bool(GQuark) >(this, &Settings_signal_writable_change_event_info);
}


Glib::SignalProxyDetailed<void(const Glib::ustring&)> Settings::signal_writable_changed(const Glib::ustring& key)
{
  return Glib::SignalProxyDetailed<void(const Glib::ustring&)>(this, &Settings_signal_writable_changed_info, key);
}


Glib::PropertyProxy_ReadOnly< bool > Settings::property_delay_apply() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "delay-apply");
}

Glib::PropertyProxy_ReadOnly< bool > Settings::property_has_unapplied() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-unapplied");
}

Glib::PropertyProxy_ReadOnly< std::string > Settings::property_path() const
{
  return Glib::PropertyProxy_ReadOnly< std::string >(this, "path");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Settings::property_schema_id() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "schema-id");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<SettingsSchema>>::value,
  "Type Glib::RefPtr<SettingsSchema> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SettingsSchema> > Settings::property_settings_schema() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SettingsSchema> >(this, "settings-schema");
}


void Gio::Settings::on_changed(const Glib::ustring& key)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->changed)
    (*base->changed)(gobj(),key.c_str());
}
bool Gio::Settings::on_writable_change_event(GQuark key)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->writable_change_event)
    return (*base->writable_change_event)(gobj(),key);

  using RType = bool;
  return RType();
}
void Gio::Settings::on_writable_changed(const Glib::ustring& key)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->writable_changed)
    (*base->writable_changed)(gobj(),key.c_str());
}


} // namespace Gio


