// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A tool result block that contains the results for a tool request that the model previously made.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ToolResultBlock {
    /// <p>The ID of the tool request that this is the result for.</p>
    pub tool_use_id: ::std::string::String,
    /// <p>The content for tool result content block.</p>
    pub content: ::std::vec::Vec<crate::types::ToolResultContentBlock>,
    /// <p>The status for the tool result content block.</p><note>
    /// <p>This field is only supported Anthropic Claude 3 models.</p>
    /// </note>
    pub status: ::std::option::Option<crate::types::ToolResultStatus>,
}
impl ToolResultBlock {
    /// <p>The ID of the tool request that this is the result for.</p>
    pub fn tool_use_id(&self) -> &str {
        use std::ops::Deref;
        self.tool_use_id.deref()
    }
    /// <p>The content for tool result content block.</p>
    pub fn content(&self) -> &[crate::types::ToolResultContentBlock] {
        use std::ops::Deref;
        self.content.deref()
    }
    /// <p>The status for the tool result content block.</p><note>
    /// <p>This field is only supported Anthropic Claude 3 models.</p>
    /// </note>
    pub fn status(&self) -> ::std::option::Option<&crate::types::ToolResultStatus> {
        self.status.as_ref()
    }
}
impl ToolResultBlock {
    /// Creates a new builder-style object to manufacture [`ToolResultBlock`](crate::types::ToolResultBlock).
    pub fn builder() -> crate::types::builders::ToolResultBlockBuilder {
        crate::types::builders::ToolResultBlockBuilder::default()
    }
}

/// A builder for [`ToolResultBlock`](crate::types::ToolResultBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ToolResultBlockBuilder {
    pub(crate) tool_use_id: ::std::option::Option<::std::string::String>,
    pub(crate) content: ::std::option::Option<::std::vec::Vec<crate::types::ToolResultContentBlock>>,
    pub(crate) status: ::std::option::Option<crate::types::ToolResultStatus>,
}
impl ToolResultBlockBuilder {
    /// <p>The ID of the tool request that this is the result for.</p>
    /// This field is required.
    pub fn tool_use_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.tool_use_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ID of the tool request that this is the result for.</p>
    pub fn set_tool_use_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.tool_use_id = input;
        self
    }
    /// <p>The ID of the tool request that this is the result for.</p>
    pub fn get_tool_use_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.tool_use_id
    }
    /// Appends an item to `content`.
    ///
    /// To override the contents of this collection use [`set_content`](Self::set_content).
    ///
    /// <p>The content for tool result content block.</p>
    pub fn content(mut self, input: crate::types::ToolResultContentBlock) -> Self {
        let mut v = self.content.unwrap_or_default();
        v.push(input);
        self.content = ::std::option::Option::Some(v);
        self
    }
    /// <p>The content for tool result content block.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::ToolResultContentBlock>>) -> Self {
        self.content = input;
        self
    }
    /// <p>The content for tool result content block.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::ToolResultContentBlock>> {
        &self.content
    }
    /// <p>The status for the tool result content block.</p><note>
    /// <p>This field is only supported Anthropic Claude 3 models.</p>
    /// </note>
    pub fn status(mut self, input: crate::types::ToolResultStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status for the tool result content block.</p><note>
    /// <p>This field is only supported Anthropic Claude 3 models.</p>
    /// </note>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::ToolResultStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status for the tool result content block.</p><note>
    /// <p>This field is only supported Anthropic Claude 3 models.</p>
    /// </note>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::ToolResultStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`ToolResultBlock`](crate::types::ToolResultBlock).
    /// This method will fail if any of the following fields are not set:
    /// - [`tool_use_id`](crate::types::builders::ToolResultBlockBuilder::tool_use_id)
    /// - [`content`](crate::types::builders::ToolResultBlockBuilder::content)
    pub fn build(self) -> ::std::result::Result<crate::types::ToolResultBlock, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ToolResultBlock {
            tool_use_id: self.tool_use_id.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "tool_use_id",
                    "tool_use_id was not specified but it is required when building ToolResultBlock",
                )
            })?,
            content: self.content.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "content",
                    "content was not specified but it is required when building ToolResultBlock",
                )
            })?,
            status: self.status,
        })
    }
}
