/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import java.io.Serializable;
import mill.api.PathRef;
import mill.moduledefs.Scaladoc;
import scala.Function0;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n * Represents something that can be watched by the Mill build tool. Most often\n * these are [[Watchable.Path]]s, but we use [[Watchable.Value]] to watch the\n * value of arbitrary computations e.g. watching the result of `os.list` to\n * react if a new folder is added.\n */")
@ScalaSignature(bytes="\u0006\u0005\t=c\u0001C A!\u0003\r\tA\u0011#\t\u000b-\u0003A\u0011A'\t\u000bE\u0003a\u0011\u0001*\t\u000bY\u0003a\u0011A,\t\u000ba\u0003A\u0011A-\t\u000bu\u0003a\u0011\u00010\b\rm\u0004\u0005\u0012\u0001\"}\r\u0019y\u0004\t#\u0001C}\"1qp\u0002C\u0001\u0003\u00031a!a\u0001\b\u0001\u0006\u0015\u0001BCA\u0011\u0013\tU\r\u0011\"\u0001\u0002$!Q\u00111F\u0005\u0003\u0012\u0003\u0006I!!\n\t\r}LA\u0011AA\u0017\u0011\u0015\t\u0016\u0002\"\u0001S\u0011\u00151\u0016\u0002\"\u0001X\u0011\u0015i\u0016\u0002\"\u0001_\u0011%\t)$CA\u0001\n\u0003\t9\u0004C\u0005\u0002<%\t\n\u0011\"\u0001\u0002>!I\u00111K\u0005\u0002\u0002\u0013\u0005\u0013Q\u000b\u0005\n\u0003KJ\u0011\u0011!C\u0001\u0003OB\u0011\"a\u001c\n\u0003\u0003%\t!!\u001d\t\u0013\u0005u\u0014\"!A\u0005B\u0005}\u0004\"CAG\u0013\u0005\u0005I\u0011AAH\u0011%\t\u0019*CA\u0001\n\u0003\n)\nC\u0005\u0002\u001a&\t\t\u0011\"\u0011\u0002\u001c\"I\u0011QT\u0005\u0002\u0002\u0013\u0005\u0013q\u0014\u0005\n\u0003CK\u0011\u0011!C!\u0003G;\u0011\"a*\b\u0003\u0003E\t!!+\u0007\u0013\u0005\rq!!A\t\u0002\u0005-\u0006BB@\u001d\t\u0003\t\u0019\rC\u0005\u0002\u001er\t\t\u0011\"\u0012\u0002 \"I\u0011Q\u0019\u000f\u0002\u0002\u0013\u0005\u0015q\u0019\u0005\n\u0003\u0017d\u0012\u0011!CA\u0003\u001bD\u0011\"!7\u001d\u0003\u0003%I!a7\u0007\r\u0005\rx\u0001QAs\u0011)\t9O\tBK\u0002\u0013\u0005\u0011\u0011\u001e\u0005\u000b\u0003c\u0014#\u0011#Q\u0001\n\u0005-\b\u0002\u0003,#\u0005+\u0007I\u0011A,\t\u0013\u0005M(E!E!\u0002\u0013\u0019\u0006\u0002C/#\u0005+\u0007I\u0011\u00010\t\u0013\u0005U(E!E!\u0002\u0013y\u0006BB@#\t\u0003\t9\u0010C\u0003RE\u0011\u0005!\u000bC\u0005\u00026\t\n\t\u0011\"\u0001\u0003\u0002!I\u00111\b\u0012\u0012\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005\u001b\u0011\u0013\u0013!C\u0001\u0005\u001fA\u0011Ba\u0005##\u0003%\tA!\u0006\t\u0013\u0005M#%!A\u0005B\u0005U\u0003\"CA3E\u0005\u0005I\u0011AA4\u0011%\tyGIA\u0001\n\u0003\u0011I\u0002C\u0005\u0002~\t\n\t\u0011\"\u0011\u0002\u0000!I\u0011Q\u0012\u0012\u0002\u0002\u0013\u0005!Q\u0004\u0005\n\u0003'\u0013\u0013\u0011!C!\u0005CA\u0011\"!'#\u0003\u0003%\t%a'\t\u0013\u0005u%%!A\u0005B\u0005}\u0005\"CAQE\u0005\u0005I\u0011\tB\u0013\u000f%\u0011IcBA\u0001\u0012\u0003\u0011YCB\u0005\u0002d\u001e\t\t\u0011#\u0001\u0003.!1q0\u000fC\u0001\u0005kA\u0011\"!(:\u0003\u0003%)%a(\t\u0013\u0005\u0015\u0017(!A\u0005\u0002\n]\u0002\"CAfs\u0005\u0005I\u0011\u0011B \u0011%\tI.OA\u0001\n\u0013\tYNA\u0005XCR\u001c\u0007.\u00192mK*\u0011\u0011IQ\u0001\u0005kRLGNC\u0001D\u0003\u0011i\u0017\u000e\u001c7\u0014\u0005\u0001)\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%AB!osJ+g-\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005q\u0005C\u0001$P\u0013\t\u0001vI\u0001\u0003V]&$\u0018\u0001\u00029pY2$\u0012a\u0015\t\u0003\rRK!!V$\u0003\t1{gnZ\u0001\ng&<g.\u0019;ve\u0016,\u0012aU\u0001\tm\u0006d\u0017\u000eZ1uKR\t!\f\u0005\u0002G7&\u0011Al\u0012\u0002\b\u0005>|G.Z1o\u0003\u0019\u0001(/\u001a;usV\tq\f\u0005\u0002aO:\u0011\u0011-\u001a\t\u0003E\u001ek\u0011a\u0019\u0006\u0003I2\u000ba\u0001\u0010:p_Rt\u0014B\u00014H\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019<\u0005\u0006\u0002\u0001lcJ\u0004\"\u0001\\8\u000e\u00035T!A\u001c\"\u0002\u00155|G-\u001e7fI\u001647/\u0003\u0002q[\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001t\u0003\t\u001drF\u000b\u0016\u000bA)\u0002#+\u001a9sKN,g\u000e^:!g>lW\r\u001e5j]\u001e\u0004C\u000f[1uA\r\fg\u000e\t2fA]\fGo\u00195fI\u0002\u0012\u0017\u0010\t;iK\u0002j\u0015\u000e\u001c7!EVLG\u000e\u001a\u0011u_>dg\u0006I'pgR\u0004sN\u001a;f]*\u0001#\u0006\t;iKN,\u0007%\u0019:fAm[v+\u0019;dQ\u0006\u0014G.\u001a\u0018QCRDW,X:-A\t,H\u000fI<fAU\u001cX\rI.\\/\u0006$8\r[1cY\u0016tc+\u00197vKvk\u0006\u0005^8!o\u0006$8\r\u001b\u0011uQ\u0016T\u0001E\u000b\u0011wC2,X\rI8gA\u0005\u0014(-\u001b;sCJL\beY8naV$\u0018\r^5p]N\u0004SML4/A]\fGo\u00195j]\u001e\u0004C\u000f[3!e\u0016\u001cX\u000f\u001c;!_\u001a\u0004\u0003m\\:/Y&\u001cH\u000f\u0019\u0011u_*\u0001#\u0006\t:fC\u000e$\b%\u001b4!C\u0002rWm\u001e\u0011g_2$WM\u001d\u0011jg\u0002\nG\rZ3e])\u0001#f\f\u0015\u0003\u0001U\u0004\"A^=\u000e\u0003]T!\u0001\u001f\"\u0002\u0007\u0005\u0004\u0018.\u0003\u0002{o\nA\u0011N\u001c;fe:\fG.A\u0005XCR\u001c\u0007.\u00192mKB\u0011QpB\u0007\u0002\u0001N\u0011q!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0014A\u0001U1uQNA\u0011\"RA\u0004\u0003\u0013\ty\u0001\u0005\u0002~\u0001A\u0019a)a\u0003\n\u0007\u00055qIA\u0004Qe>$Wo\u0019;\u0011\t\u0005E\u00111\u0004\b\u0005\u0003'\t9BD\u0002c\u0003+I\u0011\u0001S\u0005\u0004\u000339\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyB\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002\u001a\u001d\u000b\u0011\u0001]\u000b\u0003\u0003K\u00012A^A\u0014\u0013\r\tIc\u001e\u0002\b!\u0006$\bNU3g\u0003\t\u0001\b\u0005\u0006\u0003\u00020\u0005M\u0002cAA\u0019\u00135\tq\u0001C\u0004\u0002\"1\u0001\r!!\n\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003_\tI\u0004C\u0005\u0002\"A\u0001\n\u00111\u0001\u0002&\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA U\u0011\t)#!\u0011,\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0014H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\n9EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA,!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\nA\u0001\\1oO*\u0011\u0011\u0011M\u0001\u0005U\u00064\u0018-C\u0002i\u00037\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001b\u0011\u0007\u0019\u000bY'C\u0002\u0002n\u001d\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u001d\u0002zA\u0019a)!\u001e\n\u0007\u0005]tIA\u0002B]fD\u0011\"a\u001f\u0015\u0003\u0003\u0005\r!!\u001b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\t\u0005\u0004\u0002\u0004\u0006%\u00151O\u0007\u0003\u0003\u000bS1!a\"H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001.\u0002\u0012\"I\u00111\u0010\f\u0002\u0002\u0003\u0007\u00111O\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002X\u0005]\u0005\"CA>/\u0005\u0005\t\u0019AA5\u0003!A\u0017m\u001d5D_\u0012,GCAA5\u0003!!xn\u0015;sS:<GCAA,\u0003\u0019)\u0017/^1mgR\u0019!,!*\t\u0013\u0005m$$!AA\u0002\u0005M\u0014\u0001\u0002)bi\"\u00042!!\r\u001d'\u0015a\u0012QVA]!!\ty+!.\u0002&\u0005=RBAAY\u0015\r\t\u0019lR\u0001\beVtG/[7f\u0013\u0011\t9,!-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\u0011\ty,a\u0018\u0002\u0005%|\u0017\u0002BA\u000f\u0003{#\"!!+\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u0005=\u0012\u0011\u001a\u0005\b\u0003Cy\u0002\u0019AA\u0013\u0003\u001d)h.\u00199qYf$B!a4\u0002VB)a)!5\u0002&%\u0019\u00111[$\u0003\r=\u0003H/[8o\u0011%\t9\u000eIA\u0001\u0002\u0004\ty#A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!8\u0011\t\u0005e\u0013q\\\u0005\u0005\u0003C\fYF\u0001\u0004PE*,7\r\u001e\u0002\u0006-\u0006dW/Z\n\tE\u0015\u000b9!!\u0003\u0002\u0010\u0005\ta-\u0006\u0002\u0002lB!a)!<T\u0013\r\tyo\u0012\u0002\n\rVt7\r^5p]B\n!A\u001a\u0011\u0002\u0015MLwM\\1ukJ,\u0007%A\u0004qe\u0016$H/\u001f\u0011\u0015\u0011\u0005e\u00181`A\u007f\u0003\u007f\u00042!!\r#\u0011\u001d\t9/\u000ba\u0001\u0003WDQAV\u0015A\u0002MCQ!X\u0015A\u0002}#\u0002\"!?\u0003\u0004\t\u0015!q\u0001\u0005\n\u0003O\\\u0003\u0013!a\u0001\u0003WDqAV\u0016\u0011\u0002\u0003\u00071\u000bC\u0004^WA\u0005\t\u0019A0\u0016\u0005\t-!\u0006BAv\u0003\u0003\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0012)\u001a1+!\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0003\u0016\u0004?\u0006\u0005C\u0003BA:\u00057A\u0011\"a\u001f2\u0003\u0003\u0005\r!!\u001b\u0015\u0007i\u0013y\u0002C\u0005\u0002|M\n\t\u00111\u0001\u0002tQ!\u0011q\u000bB\u0012\u0011%\tY\bNA\u0001\u0002\u0004\tI\u0007F\u0002[\u0005OA\u0011\"a\u001f8\u0003\u0003\u0005\r!a\u001d\u0002\u000bY\u000bG.^3\u0011\u0007\u0005E\u0012hE\u0003:\u0005_\tI\f\u0005\u0006\u00020\nE\u00121^*`\u0003sLAAa\r\u00022\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t-B\u0003CA}\u0005s\u0011YD!\u0010\t\u000f\u0005\u001dH\b1\u0001\u0002l\")a\u000b\u0010a\u0001'\")Q\f\u0010a\u0001?R!!\u0011\tB%!\u00151\u0015\u0011\u001bB\"!\u001d1%QIAv'~K1Aa\u0012H\u0005\u0019!V\u000f\u001d7fg!I\u0011q[\u001f\u0002\u0002\u0003\u0007\u0011\u0011 \u0015\u0003\u000fUD#AB;")
public interface Watchable {
    public long poll();

    public long signature();

    default public boolean validate() {
        return this.poll() == this.signature();
    }

    public String pretty();

    public static void $init$(Watchable $this) {
    }

    public static class Path
    implements Watchable,
    Product,
    Serializable {
        private final PathRef p;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        @Override
        public boolean validate() {
            return ((Watchable)this).validate();
        }

        public PathRef p() {
            return this.p;
        }

        @Override
        public long poll() {
            return this.p().recomputeSig();
        }

        @Override
        public long signature() {
            return this.p().sig();
        }

        @Override
        public String pretty() {
            return this.p().toString();
        }

        public Path copy(PathRef p) {
            return new Path(p);
        }

        public PathRef copy$default$1() {
            return this.p();
        }

        @Override
        public String productPrefix() {
            return "Path";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.p();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Path;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "p";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Path)) return false;
            boolean bl = true;
            if (!bl) return false;
            Path path = (Path)x$1;
            PathRef pathRef = this.p();
            PathRef pathRef2 = path.p();
            if (pathRef == null) {
                if (pathRef2 != null) {
                    return false;
                }
            } else if (!((Object)pathRef).equals(pathRef2)) return false;
            if (!path.canEqual(this)) return false;
            return true;
        }

        public Path(PathRef p) {
            this.p = p;
            Watchable.$init$(this);
            Product.$init$(this);
        }
    }

    public static class Value
    implements Watchable,
    Product,
    Serializable {
        private final Function0<Object> f;
        private final long signature;
        private final String pretty;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        @Override
        public boolean validate() {
            return ((Watchable)this).validate();
        }

        public Function0<Object> f() {
            return this.f;
        }

        @Override
        public long signature() {
            return this.signature;
        }

        @Override
        public String pretty() {
            return this.pretty;
        }

        @Override
        public long poll() {
            return this.f().apply$mcJ$sp();
        }

        public Value copy(Function0<Object> f, long signature, String pretty) {
            return new Value(f, signature, pretty);
        }

        public Function0<Object> copy$default$1() {
            return this.f();
        }

        public long copy$default$2() {
            return this.signature();
        }

        public String copy$default$3() {
            return this.pretty();
        }

        @Override
        public String productPrefix() {
            return "Value";
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.f();
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this.signature());
                }
                case 2: {
                    return this.pretty();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Value;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "f";
                }
                case 1: {
                    return "signature";
                }
                case 2: {
                    return "pretty";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.f()));
            n = Statics.mix(n, Statics.longHash(this.signature()));
            n = Statics.mix(n, Statics.anyHash(this.pretty()));
            return Statics.finalizeHash(n, 3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Value)) return false;
            boolean bl = true;
            if (!bl) return false;
            Value value = (Value)x$1;
            if (this.signature() != value.signature()) return false;
            Function0<Object> function0 = this.f();
            Function0<Object> function02 = value.f();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            String string = this.pretty();
            String string2 = value.pretty();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!value.canEqual(this)) return false;
            return true;
        }

        public Value(Function0<Object> f, long signature, String pretty) {
            this.f = f;
            this.signature = signature;
            this.pretty = pretty;
            Watchable.$init$(this);
            Product.$init$(this);
        }
    }
}

