/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.Serializable;
import mill.moduledefs.Scaladoc;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n * Manage the setup, teardown, and caching of objects of type [[V]] safely\n * in a multithreaded environment.\n *\n * The user provides the [[setup]] and [[teardown]] logic along with  a [[maxCacheSize]],\n * and [[CachedFactory]] provides instances of [[V]] as requested using the [[withValue]]\n * method. These instances are automatically constructed on-demand from the give key,\n * cached with an LRU strategy, and destroyed when they are eventually evicted\n *\n * Intended for relatively small caches approximately O(num-threads) in size that\n * will typically get used in a build system, not intended for caching large amounts of entries\n */")
@ScalaSignature(bytes="\u0006\u0005E4QAC\u0006\u0002\u0002AAQ!\b\u0001\u0005\u0002yAQA\r\u0001\u0007\u0002MBQA\u000e\u0001\u0007\u0002]BQA\u0010\u0001\u0007\u0002}Bqa\u0011\u0001A\u0002\u0013%A\tC\u0004U\u0001\u0001\u0007I\u0011B+\t\ra\u0003\u0001\u0015)\u0003F\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u00151\u0007\u0001\"\u0001h\u00055\u0019\u0015m\u00195fI\u001a\u000b7\r^8ss*\u0011A\"D\u0001\u0004CBL'\"\u0001\b\u0002\t5LG\u000e\\\u0002\u0001+\r\t2\u0005M\n\u0004\u0001IQ\u0002CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011a\u0017M\\4\u000b\u0003]\tAA[1wC&\u0011\u0011\u0004\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005MY\u0012B\u0001\u000f\u0015\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u00061A(\u001b8jiz\"\u0012a\b\t\u0005A\u0001\ts&D\u0001\f!\t\u00113\u0005\u0004\u0001\u0005\u000b\u0011\u0002!\u0019A\u0013\u0003\u0003-\u000b\"A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000f9{G\u000f[5oOB\u0011q%L\u0005\u0003]!\u00121!\u00118z!\t\u0011\u0003\u0007B\u00032\u0001\t\u0007QEA\u0001W\u0003\u0015\u0019X\r^;q)\tyC\u0007C\u00036\u0005\u0001\u0007\u0011%A\u0002lKf\f\u0001\u0002^3be\u0012|wO\u001c\u000b\u0004qmb\u0004CA\u0014:\u0013\tQ\u0004F\u0001\u0003V]&$\b\"B\u001b\u0004\u0001\u0004\t\u0003\"B\u001f\u0004\u0001\u0004y\u0013!\u0002<bYV,\u0017\u0001D7bq\u000e\u000b7\r[3TSj,W#\u0001!\u0011\u0005\u001d\n\u0015B\u0001\")\u0005\rIe\u000e^\u0001\nW\u0016Lh+\u00197vKN,\u0012!\u0012\t\u0004\r:\u000bfBA$M\u001d\tA5*D\u0001J\u0015\tQu\"\u0001\u0004=e>|GOP\u0005\u0002S%\u0011Q\nK\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005K\u0001\u0003MSN$(BA')!\u00119#+I\u0018\n\u0005MC#A\u0002+va2,''A\u0007lKf4\u0016\r\\;fg~#S-\u001d\u000b\u0003qYCqa\u0016\u0004\u0002\u0002\u0003\u0007Q)A\u0002yIE\n!b[3z-\u0006dW/Z:!\u0003%9\u0018\u000e\u001e5WC2,X-\u0006\u0002\\=R\u0011A,\u001a\u000b\u0003;\u0002\u0004\"A\t0\u0005\u000b}C!\u0019A\u0013\u0003\u0003ICQ!\u0019\u0005A\u0002\t\fQA\u00197pG.\u0004BaJ20;&\u0011A\r\u000b\u0002\n\rVt7\r^5p]FBQ!\u000e\u0005A\u0002\u0005\nQa\u00197pg\u0016$\u0012\u0001\u000f\u0015\u0005\u0001%lt\u000e\u0005\u0002k[6\t1N\u0003\u0002m\u001b\u0005QQn\u001c3vY\u0016$WMZ:\n\u00059\\'\u0001C*dC2\fGm\\2\"\u0003A\fQQB\u0018+U)\u0001#\u0006I'b]\u0006<W\r\t;iK\u0002\u001aX\r^;qY\u0001\"X-\u0019:e_^tG\u0006I1oI\u0002\u001a\u0017m\u00195j]\u001e\u0004sN\u001a\u0011pE*,7\r^:!_\u001a\u0004C/\u001f9fAm[f+X/!g\u00064W\r\\=\u000bA)\u0002\u0013N\u001c\u0011bA5,H\u000e^5uQJ,\u0017\rZ3eA\u0015tg/\u001b:p]6,g\u000e\u001e\u0018\u000bA)R\u0001E\u000b\u0011UQ\u0016\u0004So]3sAA\u0014xN^5eKN\u0004C\u000f[3!7n\u001bX\r^;q;v\u0003\u0013M\u001c3!7n#X-\u0019:e_^tW,\u0018\u0011m_\u001eL7\rI1m_:<\u0007e^5uQ\u0002\u0002\u0013\rI.\\[\u0006D8)Y2iKNK'0Z/^Y)\u0001#\u0006I1oI\u0002Z6lQ1dQ\u0016$g)Y2u_JLX,\u0018\u0011qe>4\u0018\u000eZ3tA%t7\u000f^1oG\u0016\u001c\be\u001c4!7n3V,\u0018\u0011bg\u0002\u0012X-];fgR,G\rI;tS:<\u0007\u0005\u001e5fAm[v/\u001b;i-\u0006dW/Z/^\u0015\u0001R\u0003%\\3uQ>$g\u0006\t+iKN,\u0007%\u001b8ti\u0006t7-Z:!CJ,\u0007%Y;u_6\fG/[2bY2L\beY8ogR\u0014Xo\u0019;fI\u0002zg.\f3f[\u0006tG\r\t4s_6\u0004C\u000f[3!O&4X\rI6fs2R\u0001E\u000b\u0011dC\u000eDW\r\u001a\u0011xSRD\u0007%\u00198!\u0019J+\u0006e\u001d;sCR,w-\u001f\u0017!C:$\u0007\u0005Z3tiJ|\u00170\u001a3!o\",g\u000e\t;iKf\u0004\u0013M]3!KZ,g\u000e^;bY2L\b%\u001a<jGR,GM\u0003\u0011+\u0015\u0001R\u0003%\u00138uK:$W\r\u001a\u0011g_J\u0004#/\u001a7bi&4X\r\\=!g6\fG\u000e\u001c\u0011dC\u000eDWm\u001d\u0011baB\u0014x\u000e_5nCR,G.\u001f\u0011PQ9,X.\f;ie\u0016\fGm]\u0015!S:\u00043/\u001b>fAQD\u0017\r\u001e\u0006!U\u0001:\u0018\u000e\u001c7!if\u0004\u0018nY1mYf\u0004s-\u001a;!kN,G\rI5oA\u0005\u0004#-^5mI\u0002\u001a\u0018p\u001d;f[2\u0002cn\u001c;!S:$XM\u001c3fI\u00022wN\u001d\u0011dC\u000eD\u0017N\\4!Y\u0006\u0014x-\u001a\u0011b[>,h\u000e^:!_\u001a\u0004SM\u001c;sS\u0016\u001c(\u0002\t\u00160\u0001")
public abstract class CachedFactory<K, V>
implements AutoCloseable {
    private List<Tuple2<K, V>> keyValues = package$.MODULE$.List().empty();

    public abstract V setup(K var1);

    public abstract void teardown(K var1, V var2);

    public abstract int maxCacheSize();

    private List<Tuple2<K, V>> keyValues() {
        return this.keyValues;
    }

    private void keyValues_$eq(List<Tuple2<K, V>> x$1) {
        this.keyValues = x$1;
    }

    public <R> R withValue(K key2, Function1<V, R> block) {
        R r;
        Object object;
        None$ valueOpt;
        None$ none$;
        CachedFactory cachedFactory = this;
        synchronized (cachedFactory) {
            Some some;
            Tuple2 tuple2;
            Option option;
            Option option2 = this.keyValues().iterator().zipWithIndex().collectFirst(new Serializable(null, key2){
                private static final long serialVersionUID = 0L;
                private final Object key$1;

                public final <A1 extends Tuple2<Tuple2<K, V>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        Tuple2<K, V> tuple2 = A1._1();
                        int i = A1._2$mcI$sp();
                        if (tuple2 != null) {
                            K k = tuple2._1();
                            V v = tuple2._2();
                            if (BoxesRunTime.equals(this.key$1, k)) {
                                return (B1)new Tuple2<V, Integer>(v, BoxesRunTime.boxToInteger(i));
                            }
                        }
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Tuple2<K, V>, Object> x1) {
                    K k;
                    Tuple2<K, V> tuple2;
                    Tuple2<Tuple2<K, V>, Object> tuple22 = x1;
                    return tuple22 != null && (tuple2 = tuple22._1()) != null && BoxesRunTime.equals(this.key$1, k = tuple2._1());
                }
                {
                    this.key$1 = key$1;
                }
            });
            if (None$.MODULE$.equals(option2)) {
                option = None$.MODULE$;
            } else if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
                Object v = tuple2._1();
                int i = tuple2._2$mcI$sp();
                this.keyValues_$eq((List)this.keyValues().patch(i, (IterableOnce)Nil$.MODULE$, 1));
                option = new Some(v);
            } else {
                throw new MatchError(option2);
            }
            none$ = option;
        }
        None$ none$2 = valueOpt = none$;
        if (none$2 instanceof Some) {
            Object v;
            Some some = (Some)((Object)none$2);
            object = v = some.value();
        } else if (None$.MODULE$.equals(none$2)) {
            object = this.setup(key2);
        } else {
            throw new MatchError(none$2);
        }
        Object value = object;
        try {
            r = block.apply(value);
        }
        catch (Throwable throwable) {
            CachedFactory cachedFactory2 = this;
            synchronized (cachedFactory2) {
                Tuple2 tuple2 = new Tuple2(key2, value);
                Tuple2 tuple22 = this.keyValues().$colon$colon(tuple2).splitAt(this.maxCacheSize());
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                List newKeyValues = tuple22._1();
                List extra = tuple22._2();
                Tuple2 tuple23 = new Tuple2(newKeyValues, extra);
                List<Tuple2<K, V>> newKeyValues2 = tuple23._1();
                List extra2 = tuple23._2();
                this.keyValues_$eq(newKeyValues2);
                extra2.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(CachedFactory.$anonfun$withValue$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$2 -> {
                    CachedFactory.$anonfun$withValue$2(this, x$2);
                    return BoxedUnit.UNIT;
                });
            }
            throw throwable;
        }
        CachedFactory cachedFactory3 = this;
        synchronized (cachedFactory3) {
            Tuple2 tuple2 = new Tuple2(key2, value);
            Tuple2 tuple24 = this.keyValues().$colon$colon(tuple2).splitAt(this.maxCacheSize());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            List newKeyValues = tuple24._1();
            List extra = tuple24._2();
            Tuple2 tuple25 = new Tuple2(newKeyValues, extra);
            List<Tuple2<K, V>> newKeyValues3 = tuple25._1();
            List extra3 = tuple25._2();
            this.keyValues_$eq(newKeyValues3);
            extra3.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(CachedFactory.$anonfun$withValue$1(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$2 -> {
                CachedFactory.$anonfun$withValue$2(this, x$2);
                return BoxedUnit.UNIT;
            });
        }
        return r;
    }

    @Override
    public synchronized void close() {
        this.keyValues().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(CachedFactory.$anonfun$close$1(check$ifrefutable$2))).foreach((Function1<Tuple2, Object> & Serializable)x$3 -> {
            CachedFactory.$anonfun$close$2(this, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$withValue$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$withValue$2(CachedFactory $this, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            Object k = tuple2._1();
            Object v = tuple2._2();
            $this.teardown(k, v);
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$close$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$close$2(CachedFactory $this, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Object k = tuple2._1();
            Object v = tuple2._2();
            $this.teardown(k, v);
            return;
        }
        throw new MatchError(tuple2);
    }
}

