/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjarabrams;

import com.eed3si9n.jarjar.JJProcessor;
import com.eed3si9n.jarjar.Keep;
import com.eed3si9n.jarjar.PatternElement;
import com.eed3si9n.jarjar.Rule;
import com.eed3si9n.jarjar.RulesFileParser;
import com.eed3si9n.jarjar.Zap;
import com.eed3si9n.jarjar.util.EntryStruct;
import com.eed3si9n.jarjarabrams.ShadePattern;
import com.eed3si9n.jarjarabrams.ShadeRule;
import com.eed3si9n.jarjarabrams.ShadeRule$;
import com.eed3si9n.jarjarabrams.ShadeTarget;
import com.eed3si9n.jarjarabrams.ShadeTarget$;
import com.eed3si9n.jarjarabrams.Zip$;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Shader$ {
    public static final Shader$ MODULE$ = new Shader$();

    public void shadeFile(Seq<ShadeRule> rules, Path inputJar, Path outputJar, boolean verbose, boolean skipManifest, boolean resetTimestamp, boolean warnOnDuplicateClass) {
        Function2<byte[], String, Option<Tuple2<byte[], String>>> shader = this.bytecodeShader(rules, verbose, skipManifest);
        Zip$.MODULE$.transformJarFile(inputJar, outputJar, resetTimestamp, warnOnDuplicateClass, (Function1<EntryStruct, Option<EntryStruct>>)(Function1<EntryStruct, Option> & Serializable)struct0 -> ((Option)shader.apply(struct0.data, struct0.name)).map((Function1<Tuple2, EntryStruct> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                byte[] shadedBytes = (byte[])tuple2._1();
                String shadedName = (String)tuple2._2();
                return Zip$.MODULE$.entryStruct(shadedName, struct0$1.time, shadedBytes, struct0$1.skipTransform);
            }
            throw new MatchError(tuple2);
        }));
    }

    public List<Tuple2<Path, String>> makeMappings(Path dir) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(dir, new FileVisitOption[0]).iterator()).asScala()).toList().flatMap((Function1<Path, IterableOnce> & Serializable)x -> {
            Path path = x;
            Path path2 = dir;
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                return None$.MODULE$;
            }
            return new Some<Tuple2<Path, String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x), ((Object)dir.relativize((Path)x)).toString()));
        });
    }

    public void shadeDirectory(Seq<ShadeRule> rules, Path dir, Seq<Tuple2<Path, String>> mappings, boolean verbose) {
        this.shadeDirectory(rules, dir, mappings, verbose, true);
    }

    public void shadeDirectory(Seq<ShadeRule> rules, Path dir, Seq<Tuple2<Path, String>> mappings, boolean verbose, boolean skipManifest) {
        if (rules.isEmpty()) {
            return;
        }
        Function2<byte[], String, Option<Tuple2<byte[], String>>> shader = this.bytecodeShader(rules, verbose, skipManifest);
        ((IterableOps)mappings.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Shader$.$anonfun$shadeDirectory$1(check$ifrefutable$1))).withFilter((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(Shader$.$anonfun$shadeDirectory$2(x$1))).map((Function1<Tuple2, Tuple3> & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                byte[] bytes = Files.readAllBytes(path);
                Files.delete(path);
                BoxedUnit x$3 = BoxedUnit.UNIT;
                return new Tuple3<Tuple2, byte[], BoxedUnit>(tuple2, bytes, x$3);
            }
            throw new MatchError(tuple2);
        })).flatMap((Function1<Tuple3, Option> & Serializable)x$10 -> {
            Tuple3 tuple3 = x$10;
            if (tuple3 != null) {
                Tuple2 tuple2 = (Tuple2)tuple3._1();
                byte[] bytes = (byte[])tuple3._2();
                if (tuple2 != null) {
                    String name = (String)tuple2._2();
                    return ((Option)shader.apply(bytes, name)).withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(Shader$.$anonfun$shadeDirectory$5(check$ifrefutable$2))).map((Function1<Tuple2, Tuple4> & Serializable)x$8 -> {
                        Tuple2 tuple2 = x$8;
                        if (tuple2 != null) {
                            byte[] shadedBytes = (byte[])tuple2._1();
                            String shadedName = (String)tuple2._2();
                            Path out = dir.resolve(shadedName);
                            Zip$.MODULE$.createDirectories(out.getParent());
                            BoxedUnit x$6 = BoxedUnit.UNIT;
                            Path x$7 = Files.write(out, shadedBytes, StandardOpenOption.CREATE);
                            return new Tuple4<Tuple2, Path, BoxedUnit, Path>(tuple2, out, x$6, x$7);
                        }
                        throw new MatchError(tuple2);
                    }).map((Function1<Tuple4, Object> & Serializable)x$9 -> {
                        Shader$.$anonfun$shadeDirectory$7(x$9);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            throw new MatchError(tuple3);
        });
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(dir, new FileVisitOption[0]).iterator()).asScala()).toList().foreach((Function1<Path, Object> & Serializable)x -> {
            Path path = x;
            Path path2 = dir;
            if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                return BoxedUnit.UNIT;
            }
            return BoxesRunTime.boxToBoolean(Zip$.MODULE$.resetModifiedTime((Path)x));
        });
    }

    public Function2<byte[], String, Option<Tuple2<byte[], String>>> bytecodeShader(Seq<ShadeRule> rules, boolean verbose, boolean skipManifest) {
        if (rules.isEmpty()) {
            return (Function2<byte[], String, Some> & Serializable)(bytes, mapping) -> new Some<Tuple2<byte[], String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(bytes), mapping));
        }
        Seq jjrules = (Seq)rules.flatMap((Function1<ShadeRule, List> & Serializable)r -> {
            ShadePattern shadePattern = r.shadePattern();
            if (shadePattern instanceof ShadePattern.Rename) {
                ShadePattern.Rename rename = (ShadePattern.Rename)shadePattern;
                List<Tuple2<String, String>> patterns = rename.patterns();
                return patterns.map((Function1<Tuple2, Rule> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String from = (String)tuple2._1();
                        String to = (String)tuple2._2();
                        Rule jrule = new Rule();
                        jrule.setPattern(from);
                        jrule.setResult(to);
                        return jrule;
                    }
                    throw new MatchError(tuple2);
                });
            }
            if (shadePattern instanceof ShadePattern.Zap) {
                ShadePattern.Zap zap = (ShadePattern.Zap)shadePattern;
                List<String> patterns = zap.patterns();
                return patterns.map((Function1<String, Zap> & Serializable)pattern -> {
                    Zap jrule = new Zap();
                    jrule.setPattern((String)pattern);
                    return jrule;
                });
            }
            if (shadePattern instanceof ShadePattern.Keep) {
                ShadePattern.Keep keep = (ShadePattern.Keep)shadePattern;
                List<String> patterns = keep.patterns();
                return patterns.map((Function1<String, Keep> & Serializable)pattern -> {
                    Keep jrule = new Keep();
                    jrule.setPattern((String)pattern);
                    return jrule;
                });
            }
            return Nil$.MODULE$;
        });
        JJProcessor proc2 = new JJProcessor(jjrules, verbose, skipManifest, null);
        Set<String> excludes = proc2.getExcludes();
        return (Function2<byte[], String, Option> & Serializable)(bytes, mapping) -> {
            String sanitizedMapping = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString((String)mapping), '\\') ? mapping.replace('\\', '/') : mapping;
            EntryStruct entry = new EntryStruct();
            entry.data = bytes;
            entry.name = sanitizedMapping;
            entry.time = -1L;
            entry.skipTransform = false;
            if (!excludes.contains(entry.name) && proc2.process(entry)) {
                return new Some<Tuple2<byte[], String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.data), entry.name));
            }
            return None$.MODULE$;
        };
    }

    public List<ShadeRule> parseRulesFile(Path rulesFile) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(RulesFileParser.parse(rulesFile.toFile())).asScala()).map((Function1<PatternElement, ShadeRule> & Serializable)rule -> MODULE$.toShadeRule((PatternElement)rule))).toList();
    }

    public ShadeRule toShadeRule(PatternElement rule) {
        PatternElement patternElement = rule;
        if (patternElement instanceof Rule) {
            Rule rule2 = (Rule)patternElement;
            return ShadeRule$.MODULE$.apply(ShadeRule$.MODULE$.rename(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, String>(rule2.getPattern(), rule2.getResult())})), (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShadeTarget[]{ShadeTarget$.MODULE$.inAll()})));
        }
        if (patternElement instanceof Keep) {
            Keep keep = (Keep)patternElement;
            return ShadeRule$.MODULE$.apply(ShadeRule$.MODULE$.keep(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{keep.getPattern()})), (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShadeTarget[]{ShadeTarget$.MODULE$.inAll()})));
        }
        if (patternElement instanceof Zap) {
            Zap zap = (Zap)patternElement;
            return ShadeRule$.MODULE$.apply(ShadeRule$.MODULE$.zap(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{zap.getPattern()})), (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShadeTarget[]{ShadeTarget$.MODULE$.inAll()})));
        }
        throw new MatchError(patternElement);
    }

    public static final /* synthetic */ boolean $anonfun$shadeDirectory$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$shadeDirectory$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Path path = (Path)tuple2._1();
            return !Files.isDirectory(path, new LinkOption[0]);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$shadeDirectory$5(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$shadeDirectory$7(Tuple4 x$9) {
        Tuple2 tuple2;
        Tuple4 tuple4 = x$9;
        if (tuple4 != null && (tuple2 = (Tuple2)tuple4._1()) != null) {
            return;
        }
        throw new MatchError(tuple4);
    }

    private Shader$() {
    }
}

