;; Scheduling description for PowerPC 601 processor.
;;   Copyright (C) 2003-2026 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "ppc601,ppc601fp")
(define_cpu_unit "iu_ppc601" "ppc601")
(define_cpu_unit "fpu_ppc601" "ppc601fp")
(define_cpu_unit "bpu_ppc601" "ppc601")

;; PPC601  32-bit IU, FPU, BPU

(define_insn_reservation "ppc601-load" 2
  (and (eq_attr "type" "load,load_l,store_c,sync")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601")

(define_insn_reservation "ppc601-store" 2
  (and (eq_attr "type" "store")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601")

(define_insn_reservation "ppc601-fpload" 3
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601")

(define_insn_reservation "ppc601-fpstore" 3
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601+fpu_ppc601")

(define_insn_reservation "ppc601-integer" 1
  (and (ior (eq_attr "type" "integer,add,insert,trap,cntlz,isel")
	    (and (eq_attr "type" "shift,exts")
		 (eq_attr "dot" "no")))
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601")

(define_insn_reservation "ppc601-two" 1
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,iu_ppc601")

(define_insn_reservation "ppc601-three" 1
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,iu_ppc601,iu_ppc601")

(define_insn_reservation "ppc601-imul" 5
  (and (eq_attr "type" "mul")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601*5")

(define_insn_reservation "ppc601-idiv" 36
  (and (eq_attr "type" "div")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601*36")

; compare executes on integer unit, but feeds insns which
; execute on the branch unit.
(define_insn_reservation "ppc601-compare" 3
  (and (ior (eq_attr "type" "cmp")
	    (and (eq_attr "type" "shift,exts")
		 (eq_attr "dot" "yes")))
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,nothing,bpu_ppc601")

(define_insn_reservation "ppc601-fpcompare" 5
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc601"))
  "(fpu_ppc601+iu_ppc601*2),nothing*2,bpu_ppc601")

(define_insn_reservation "ppc601-fp" 4
  (and (eq_attr "type" "fp,fpsimple")
       (eq_attr "cpu" "ppc601"))
  "fpu_ppc601")

(define_insn_reservation "ppc601-dmul" 5
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc601"))
  "fpu_ppc601*2")

(define_insn_reservation "ppc601-sdiv" 17
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc601"))
  "fpu_ppc601*17")

(define_insn_reservation "ppc601-ddiv" 31
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc601"))
  "fpu_ppc601*31")

(define_insn_reservation "ppc601-mfcr" 2
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,bpu_ppc601")

(define_insn_reservation "ppc601-mtcr" 4
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,bpu_ppc601")

(define_insn_reservation "ppc601-crlogical" 4
  (and (eq_attr "type" "cr_logical")
       (eq_attr "cpu" "ppc601"))
  "bpu_ppc601")

(define_insn_reservation "ppc601-mtjmpr" 4
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,bpu_ppc601")

(define_insn_reservation "ppc601-mfjmpr" 2
  (and (eq_attr "type" "mfjmpr")
       (eq_attr "cpu" "ppc601"))
  "iu_ppc601,bpu_ppc601")

(define_insn_reservation "ppc601-branch" 1
  (and (eq_attr "type" "jmpreg,branch,isync")
       (eq_attr "cpu" "ppc601"))
  "bpu_ppc601")

