import { useState } from 'react';
function createDroppableRegistry() {
  const droppableMap = new Map();
  const getEntry = ({
    droppableId
  }) => {
    var _droppableMap$get;
    return (_droppableMap$get = droppableMap.get(droppableId)) !== null && _droppableMap$get !== void 0 ? _droppableMap$get : null;
  };
  let updateListener = null;
  const setUpdateListener = listener => {
    updateListener = listener;
  };
  const register = entry => {
    var _updateListener;
    droppableMap.set(entry.droppableId, entry);
    (_updateListener = updateListener) === null || _updateListener === void 0 ? void 0 : _updateListener(entry);
    return () => {
      droppableMap.delete(entry.droppableId);
    };
  };
  return {
    getEntry,
    register,
    setUpdateListener
  };
}
export function useDroppableRegistry() {
  const [droppableRegistry] = useState(createDroppableRegistry);
  return droppableRegistry;
}