// Source: https://github.com/atlassian/react-beautiful-dnd

export var getPercentage = function getPercentage(_ref) {
  var startOfRange = _ref.startOfRange,
    endOfRange = _ref.endOfRange,
    current = _ref.current;
  var range = endOfRange - startOfRange;
  if (range === 0) {
    /**
     * Detected distance range of 0 in the auto scroller
     * This is unexpected and would cause a divide by 0 issue.
     * Not allowing an auto scroll
     */
    return 0;
  }
  var currentInRange = current - startOfRange;
  var percentage = currentInRange / range;
  return percentage;
};