import _extends from "@babel/runtime/helpers/extends";
import React, { forwardRef, useMemo } from 'react';
import AnalyticsContext from '../components/AnalyticsContext';
const withAnalyticsContext = defaultData => WrappedComponent => {
  const WithAnalyticsContext = /*#__PURE__*/forwardRef(({
    analyticsContext,
    ...rest
  }, ref) => {
    const analyticsData = useMemo(() => ({
      ...defaultData,
      ...analyticsContext
    }), [analyticsContext]);
    return /*#__PURE__*/React.createElement(AnalyticsContext, {
      data: analyticsData
    }, /*#__PURE__*/React.createElement(WrappedComponent, _extends({}, rest, {
      ref: ref
    })));
  });
  WithAnalyticsContext.displayName = `WithAnalyticsContext(${WrappedComponent.displayName || WrappedComponent.name})`;
  return WithAnalyticsContext;
};
export default withAnalyticsContext;