//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armprivatedns

// ARecord - An A record.
type ARecord struct {
	// The IPv4 address of this A record.
	IPv4Address *string
}

// AaaaRecord - An AAAA record.
type AaaaRecord struct {
	// The IPv6 address of this AAAA record.
	IPv6Address *string
}

// CnameRecord - A CNAME record.
type CnameRecord struct {
	// The canonical name for this CNAME record.
	Cname *string
}

// MxRecord - An MX record.
type MxRecord struct {
	// The domain name of the mail host for this MX record.
	Exchange *string

	// The preference value for this MX record.
	Preference *int32
}

// PrivateZone - Describes a Private DNS zone.
type PrivateZone struct {
	// The ETag of the zone.
	Etag *string

	// The Azure Region where the resource lives
	Location *string

	// Properties of the Private DNS zone.
	Properties *PrivateZoneProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
	Type *string
}

// PrivateZoneListResult - The response to a Private DNS zone list operation.
type PrivateZoneListResult struct {
	// Information about the Private DNS zones.
	Value []*PrivateZone

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string
}

// PrivateZoneProperties - Represents the properties of the Private DNS zone.
type PrivateZoneProperties struct {
	// READ-ONLY; Private zone internal Id
	InternalID *string

	// READ-ONLY; The maximum number of record sets that can be created in this Private DNS zone. This is a read-only property
	// and any attempt to set this value will be ignored.
	MaxNumberOfRecordSets *int64

	// READ-ONLY; The maximum number of virtual networks that can be linked to this Private DNS zone. This is a read-only property
	// and any attempt to set this value will be ignored.
	MaxNumberOfVirtualNetworkLinks *int64

	// READ-ONLY; The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled.
	// This is a read-only property and any attempt to set this value will be ignored.
	MaxNumberOfVirtualNetworkLinksWithRegistration *int64

	// READ-ONLY; The current number of record sets in this Private DNS zone. This is a read-only property and any attempt to
	// set this value will be ignored.
	NumberOfRecordSets *int64

	// READ-ONLY; The current number of virtual networks that are linked to this Private DNS zone. This is a read-only property
	// and any attempt to set this value will be ignored.
	NumberOfVirtualNetworkLinks *int64

	// READ-ONLY; The current number of virtual networks that are linked to this Private DNS zone with registration enabled. This
	// is a read-only property and any attempt to set this value will be ignored.
	NumberOfVirtualNetworkLinksWithRegistration *int64

	// READ-ONLY; The provisioning state of the resource. This is a read-only property and any attempt to set this value will
	// be ignored.
	ProvisioningState *ProvisioningState
}

// ProxyResource - The resource model definition for an ARM proxy resource.
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
	Type *string
}

// PtrRecord - A PTR record.
type PtrRecord struct {
	// The PTR target domain name for this PTR record.
	Ptrdname *string
}

// RecordSet - Describes a DNS record set (a collection of DNS records with the same name and type) in a Private DNS zone.
type RecordSet struct {
	// The ETag of the record set.
	Etag *string

	// The properties of the record set.
	Properties *RecordSetProperties

	// READ-ONLY; Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
	Type *string
}

// RecordSetListResult - The response to a record set list operation.
type RecordSetListResult struct {
	// Information about the record sets in the response.
	Value []*RecordSet

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string
}

// RecordSetProperties - Represents the properties of the records in the record set.
type RecordSetProperties struct {
	// The list of A records in the record set.
	ARecords []*ARecord

	// The list of AAAA records in the record set.
	AaaaRecords []*AaaaRecord

	// The CNAME record in the record set.
	CnameRecord *CnameRecord

	// The metadata attached to the record set.
	Metadata map[string]*string

	// The list of MX records in the record set.
	MxRecords []*MxRecord

	// The list of PTR records in the record set.
	PtrRecords []*PtrRecord

	// The SOA record in the record set.
	SoaRecord *SoaRecord

	// The list of SRV records in the record set.
	SrvRecords []*SrvRecord

	// The TTL (time-to-live) of the records in the record set.
	TTL *int64

	// The list of TXT records in the record set.
	TxtRecords []*TxtRecord

	// READ-ONLY; Fully qualified domain name of the record set.
	Fqdn *string

	// READ-ONLY; Is the record set auto-registered in the Private DNS zone through a virtual network link?
	IsAutoRegistered *bool
}

// Resource - The core properties of ARM resources
type Resource struct {
	// READ-ONLY; Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
	Type *string
}

// SoaRecord - An SOA record.
type SoaRecord struct {
	// The email contact for this SOA record.
	Email *string

	// The expire time for this SOA record.
	ExpireTime *int64

	// The domain name of the authoritative name server for this SOA record.
	Host *string

	// The minimum value for this SOA record. By convention this is used to determine the negative caching duration.
	MinimumTTL *int64

	// The refresh value for this SOA record.
	RefreshTime *int64

	// The retry time for this SOA record.
	RetryTime *int64

	// The serial number for this SOA record.
	SerialNumber *int64
}

// SrvRecord - An SRV record.
type SrvRecord struct {
	// The port value for this SRV record.
	Port *int32

	// The priority value for this SRV record.
	Priority *int32

	// The target domain name for this SRV record.
	Target *string

	// The weight value for this SRV record.
	Weight *int32
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// Resource ID.
	ID *string
}

// TrackedResource - The resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// The Azure Region where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
	Type *string
}

// TxtRecord - A TXT record.
type TxtRecord struct {
	// The text value of this TXT record.
	Value []*string
}

// VirtualNetworkLink - Describes a link to virtual network for a Private DNS zone.
type VirtualNetworkLink struct {
	// The ETag of the virtual network link.
	Etag *string

	// The Azure Region where the resource lives
	Location *string

	// Properties of the virtual network link to the Private DNS zone.
	Properties *VirtualNetworkLinkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
	Type *string
}

// VirtualNetworkLinkListResult - The response to a list virtual network link to Private DNS zone operation.
type VirtualNetworkLinkListResult struct {
	// Information about the virtual network links to the Private DNS zones.
	Value []*VirtualNetworkLink

	// READ-ONLY; The continuation token for the next page of results.
	NextLink *string
}

// VirtualNetworkLinkProperties - Represents the properties of the Private DNS zone.
type VirtualNetworkLinkProperties struct {
	// Is auto-registration of virtual machine records in the virtual network in the Private DNS zone enabled?
	RegistrationEnabled *bool

	// The resolution policy on the virtual network link. Only applicable for virtual network links to privatelink zones, and
	// for A,AAAA,CNAME queries. When set to 'NxDomainRedirect', Azure DNS resolver
	// falls back to public resolution if private dns query resolution results in non-existent domain response.
	ResolutionPolicy *ResolutionPolicy

	// The reference of the virtual network.
	VirtualNetwork *SubResource

	// READ-ONLY; The provisioning state of the resource. This is a read-only property and any attempt to set this value will
	// be ignored.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The status of the virtual network link to the Private DNS zone. Possible values are 'InProgress' and 'Done'.
	// This is a read-only property and any attempt to set this value will be ignored.
	VirtualNetworkLinkState *VirtualNetworkLinkState
}
