//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// This operation will fetch records changes across the given record zones
    ///
    ///
    /// For each
    /// `previousServerChangeToken`passed in with a
    /// `CKFetchRecordZoneChangesConfiguration,`only records that have changed since that anchor will be fetched.
    /// If this is your first fetch of a zone or if you wish to re-fetch all records within a zone, do not include a
    /// `previousServerChangeToken.`Change tokens are opaque tokens and clients should not infer any behavior based on their content.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckfetchrecordzonechangesoperation?language=objc)
    #[unsafe(super(CKDatabaseOperation, CKOperation, NSOperation, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
    pub struct CKFetchRecordZoneChangesOperation;
);

#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for CKFetchRecordZoneChangesOperation {}
);

#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKFetchRecordZoneChangesOperation {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "CKRecordZoneID")]
        #[unsafe(method(initWithRecordZoneIDs:configurationsByRecordZoneID:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRecordZoneIDs_configurationsByRecordZoneID(
            this: Allocated<Self>,
            record_zone_i_ds: &NSArray<CKRecordZoneID>,
            configurations_by_record_zone_id: Option<
                &NSDictionary<CKRecordZoneID, CKFetchRecordZoneChangesConfiguration>,
            >,
        ) -> Retained<Self>;

        #[cfg(feature = "CKRecordZoneID")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(recordZoneIDs))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneIDs(&self) -> Option<Retained<NSArray<CKRecordZoneID>>>;

        #[cfg(feature = "CKRecordZoneID")]
        /// Setter for [`recordZoneIDs`][Self::recordZoneIDs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneIDs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneIDs(&self, record_zone_i_ds: Option<&NSArray<CKRecordZoneID>>);

        #[cfg(feature = "CKRecordZoneID")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(configurationsByRecordZoneID))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationsByRecordZoneID(
            &self,
        ) -> Option<Retained<NSDictionary<CKRecordZoneID, CKFetchRecordZoneChangesConfiguration>>>;

        #[cfg(feature = "CKRecordZoneID")]
        /// Setter for [`configurationsByRecordZoneID`][Self::configurationsByRecordZoneID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setConfigurationsByRecordZoneID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setConfigurationsByRecordZoneID(
            &self,
            configurations_by_record_zone_id: Option<
                &NSDictionary<CKRecordZoneID, CKFetchRecordZoneChangesConfiguration>,
            >,
        );

        /// Determines if the operation should fetch all changes from the server before completing.
        ///
        ///
        /// When set to YES, this operation will send repeated requests to the server until all record changes have been fetched.
        /// `recordZoneChangeTokensUpdatedBlock`will be invoked periodically, to give clients an updated change token so that already-fetched record changes don't need to be re-fetched on a subsequent operation.
        /// `recordZoneFetchCompletionBlock`will only be called once and
        /// `moreComing`will always be NO.
        ///
        /// When set to NO, it is the responsibility of the caller to issue subsequent fetch-changes operations when
        /// `moreComing`is YES in a
        /// `recordZoneFetchCompletionBlock`invocation.
        ///
        /// `fetchAllChanges`is YES by default
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(fetchAllChanges))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchAllChanges(&self) -> bool;

        /// Setter for [`fetchAllChanges`][Self::fetchAllChanges].
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setFetchAllChanges:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFetchAllChanges(&self, fetch_all_changes: bool);

        #[cfg(all(feature = "CKRecord", feature = "block2"))]
        /// If the replacement callback
        /// `recordWasChangedBlock`is set, this callback block is ignored.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer.
        /// - This might not be thread-safe.
        #[deprecated = "Use recordWasChangedBlock instead, which surfaces per-record errors"]
        #[unsafe(method(recordChangedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordChangedBlock(&self)
            -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecord>)>;

        #[cfg(all(feature = "CKRecord", feature = "block2"))]
        /// Setter for [`recordChangedBlock`][Self::recordChangedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated = "Use recordWasChangedBlock instead, which surfaces per-record errors"]
        #[unsafe(method(setRecordChangedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordChangedBlock(
            &self,
            record_changed_block: Option<&block2::DynBlock<dyn Fn(NonNull<CKRecord>)>>,
        );

        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// If a record fails in post-processing (say, a network failure materializing a
        /// `CKAsset`record field), the per-record error will be passed here.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - The returned block's argument 3 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(recordWasChangedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordWasChangedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordID>, *mut CKRecord, *mut NSError)>;

        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// Setter for [`recordWasChangedBlock`][Self::recordWasChangedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordWasChangedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordWasChangedBlock(
            &self,
            record_was_changed_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordID>, *mut CKRecord, *mut NSError)>,
            >,
        );

        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer.
        /// - This might not be thread-safe.
        #[unsafe(method(recordWithIDWasDeletedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordWithIDWasDeletedBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<CKRecordID>, NonNull<CKRecordType>)>;

        #[cfg(all(feature = "CKRecord", feature = "CKRecordID", feature = "block2"))]
        /// Setter for [`recordWithIDWasDeletedBlock`][Self::recordWithIDWasDeletedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordWithIDWasDeletedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordWithIDWasDeletedBlock(
            &self,
            record_with_id_was_deleted_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<CKRecordID>, NonNull<CKRecordType>)>,
            >,
        );

        #[cfg(all(
            feature = "CKRecordZoneID",
            feature = "CKServerChangeToken",
            feature = "block2"
        ))]
        /// Clients are responsible for saving this per-recordZone
        /// `serverChangeToken`and passing it in to the next call to
        /// `CKFetchRecordZoneChangesOperation.`Note that a fetch can fail partway. If that happens, an updated change token may be returned in this block so that already fetched records don't need to be re-downloaded on a subsequent operation.
        /// `recordZoneChangeTokensUpdatedBlock`will not be called after the last batch of changes in a zone; the
        /// `recordZoneFetchCompletionBlock`block will be called instead.
        /// The
        /// `clientChangeTokenData`from the most recent
        /// `CKModifyRecordsOperation`issued on this zone is also returned, or nil if none was provided.
        /// If the server returns a
        /// `CKErrorChangeTokenExpired`error, the
        /// `serverChangeToken`used for this record zone when initting this operation was too old and the client should toss its local cache and re-fetch the changes in this record zone starting with a nil
        /// `serverChangeToken.``recordZoneChangeTokensUpdatedBlock`will not be called if
        /// `fetchAllChanges`is NO.
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - The returned block's argument 3 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(recordZoneChangeTokensUpdatedBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneChangeTokensUpdatedBlock(
            &self,
        ) -> *mut block2::DynBlock<
            dyn Fn(NonNull<CKRecordZoneID>, *mut CKServerChangeToken, *mut NSData),
        >;

        #[cfg(all(
            feature = "CKRecordZoneID",
            feature = "CKServerChangeToken",
            feature = "block2"
        ))]
        /// Setter for [`recordZoneChangeTokensUpdatedBlock`][Self::recordZoneChangeTokensUpdatedBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneChangeTokensUpdatedBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneChangeTokensUpdatedBlock(
            &self,
            record_zone_change_tokens_updated_block: Option<
                &block2::DynBlock<
                    dyn Fn(NonNull<CKRecordZoneID>, *mut CKServerChangeToken, *mut NSData),
                >,
            >,
        );

        #[cfg(all(
            feature = "CKRecordZoneID",
            feature = "CKServerChangeToken",
            feature = "block2"
        ))]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - The returned block's argument 3 must be a valid pointer or null.
        /// - The returned block's argument 5 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(recordZoneFetchCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordZoneFetchCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<
            dyn Fn(
                NonNull<CKRecordZoneID>,
                *mut CKServerChangeToken,
                *mut NSData,
                Bool,
                *mut NSError,
            ),
        >;

        #[cfg(all(
            feature = "CKRecordZoneID",
            feature = "CKServerChangeToken",
            feature = "block2"
        ))]
        /// Setter for [`recordZoneFetchCompletionBlock`][Self::recordZoneFetchCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRecordZoneFetchCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordZoneFetchCompletionBlock(
            &self,
            record_zone_fetch_completion_block: Option<
                &block2::DynBlock<
                    dyn Fn(
                        NonNull<CKRecordZoneID>,
                        *mut CKServerChangeToken,
                        *mut NSData,
                        Bool,
                        *mut NSError,
                    ),
                >,
            >,
        );

        #[cfg(feature = "block2")]
        /// This block is called when the operation completes.
        ///
        ///
        /// `serverChangeToken-s`previously returned via a
        /// `recordZoneChangeTokensUpdatedBlock`or
        /// `recordZoneFetchCompletionBlock`invocation, along with the record changes that preceded it, are valid even if there is a subsequent
        /// `operationError`If the error is
        /// `CKErrorPartialFailure,`the error's userInfo dictionary contains a dictionary of recordIDs and zoneIDs to errors keyed off of
        /// `CKPartialErrorsByItemIDKey.`Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(fetchRecordZoneChangesCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchRecordZoneChangesCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(*mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`fetchRecordZoneChangesCompletionBlock`][Self::fetchRecordZoneChangesCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setFetchRecordZoneChangesCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFetchRecordZoneChangesCompletionBlock(
            &self,
            fetch_record_zone_changes_completion_block: Option<
                &block2::DynBlock<dyn Fn(*mut NSError)>,
            >,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKFetchRecordZoneChangesOperation {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// Deprecated.
#[cfg(all(feature = "CKDatabaseOperation", feature = "CKOperation"))]
impl CKFetchRecordZoneChangesOperation {
    extern_methods!(
        #[cfg(feature = "CKRecordZoneID")]
        #[deprecated]
        #[unsafe(method(initWithRecordZoneIDs:optionsByRecordZoneID:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRecordZoneIDs_optionsByRecordZoneID(
            this: Allocated<Self>,
            record_zone_i_ds: &NSArray<CKRecordZoneID>,
            options_by_record_zone_id: Option<
                &NSDictionary<CKRecordZoneID, CKFetchRecordZoneChangesOptions>,
            >,
        ) -> Retained<Self>;

        #[cfg(feature = "CKRecordZoneID")]
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated]
        #[unsafe(method(optionsByRecordZoneID))]
        #[unsafe(method_family = none)]
        pub unsafe fn optionsByRecordZoneID(
            &self,
        ) -> Option<Retained<NSDictionary<CKRecordZoneID, CKFetchRecordZoneChangesOptions>>>;

        #[cfg(feature = "CKRecordZoneID")]
        /// Setter for [`optionsByRecordZoneID`][Self::optionsByRecordZoneID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[deprecated]
        #[unsafe(method(setOptionsByRecordZoneID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOptionsByRecordZoneID(
            &self,
            options_by_record_zone_id: Option<
                &NSDictionary<CKRecordZoneID, CKFetchRecordZoneChangesOptions>,
            >,
        );
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckfetchrecordzonechangesconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKFetchRecordZoneChangesConfiguration;
);

extern_conformance!(
    unsafe impl NSCoding for CKFetchRecordZoneChangesConfiguration {}
);

extern_conformance!(
    unsafe impl NSCopying for CKFetchRecordZoneChangesConfiguration {}
);

unsafe impl CopyingHelper for CKFetchRecordZoneChangesConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKFetchRecordZoneChangesConfiguration {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKFetchRecordZoneChangesConfiguration {}
);

impl CKFetchRecordZoneChangesConfiguration {
    extern_methods!(
        #[cfg(feature = "CKServerChangeToken")]
        #[unsafe(method(previousServerChangeToken))]
        #[unsafe(method_family = none)]
        pub unsafe fn previousServerChangeToken(&self) -> Option<Retained<CKServerChangeToken>>;

        #[cfg(feature = "CKServerChangeToken")]
        /// Setter for [`previousServerChangeToken`][Self::previousServerChangeToken].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setPreviousServerChangeToken:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreviousServerChangeToken(
            &self,
            previous_server_change_token: Option<&CKServerChangeToken>,
        );

        #[unsafe(method(resultsLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn resultsLimit(&self) -> NSUInteger;

        /// Setter for [`resultsLimit`][Self::resultsLimit].
        #[unsafe(method(setResultsLimit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResultsLimit(&self, results_limit: NSUInteger);

        #[cfg(feature = "CKRecord")]
        /// Declares which user-defined keys should be fetched and added to the resulting CKRecords.
        ///
        ///
        /// If nil, declares the entire record should be downloaded. If set to an empty array, declares that no user fields should be downloaded.
        /// Defaults to
        /// `nil.`
        #[unsafe(method(desiredKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn desiredKeys(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`desiredKeys`][Self::desiredKeys].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDesiredKeys:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDesiredKeys(&self, desired_keys: Option<&NSArray<CKRecordFieldKey>>);
    );
}

/// Methods declared on superclass `NSObject`.
impl CKFetchRecordZoneChangesConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckfetchrecordzonechangesoptions?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated]
    pub struct CKFetchRecordZoneChangesOptions;
);

extern_conformance!(
    unsafe impl NSCoding for CKFetchRecordZoneChangesOptions {}
);

extern_conformance!(
    unsafe impl NSCopying for CKFetchRecordZoneChangesOptions {}
);

unsafe impl CopyingHelper for CKFetchRecordZoneChangesOptions {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKFetchRecordZoneChangesOptions {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKFetchRecordZoneChangesOptions {}
);

impl CKFetchRecordZoneChangesOptions {
    extern_methods!(
        #[cfg(feature = "CKServerChangeToken")]
        #[deprecated]
        #[unsafe(method(previousServerChangeToken))]
        #[unsafe(method_family = none)]
        pub unsafe fn previousServerChangeToken(&self) -> Option<Retained<CKServerChangeToken>>;

        #[cfg(feature = "CKServerChangeToken")]
        /// Setter for [`previousServerChangeToken`][Self::previousServerChangeToken].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setPreviousServerChangeToken:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreviousServerChangeToken(
            &self,
            previous_server_change_token: Option<&CKServerChangeToken>,
        );

        #[deprecated]
        #[unsafe(method(resultsLimit))]
        #[unsafe(method_family = none)]
        pub unsafe fn resultsLimit(&self) -> NSUInteger;

        /// Setter for [`resultsLimit`][Self::resultsLimit].
        #[deprecated]
        #[unsafe(method(setResultsLimit:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResultsLimit(&self, results_limit: NSUInteger);

        #[cfg(feature = "CKRecord")]
        #[deprecated]
        #[unsafe(method(desiredKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn desiredKeys(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`desiredKeys`][Self::desiredKeys].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated]
        #[unsafe(method(setDesiredKeys:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDesiredKeys(&self, desired_keys: Option<&NSArray<CKRecordFieldKey>>);
    );
}

/// Methods declared on superclass `NSObject`.
impl CKFetchRecordZoneChangesOptions {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
