# Contributing

Thank you for considering contributing to the Bracoxide project! We appreciate your support
and value the contributions from the community. This document outlines some guidelines to
help you get started with contributing.

## Code of Conduct

We expect all contributors to abide by our [Code of Conduct](CODE_OF_CONDUCT.md). Please
read it carefully before participating in the project.

## How to Contribute

1. Fork the repository and clone it to your local machine.
2. Create a new branch for your contribution: `git switch -c your-branch-name`.
3. Make your changes and ensure that the code passes all tests.
4. Write appropriate test cases to cover your changes.
5. Commit your changes with a descriptive commit message: `git commit -m "Your message"`.
6. Push your changes to your forked repository: `git push origin your-branch-name`.
7. Submit a pull request to the main repository, dev branch.
8. Your pull request will be reviewed, and feedback may be provided for further improvements
or changes.
9. Once approved, your changes will be merged into the main/dev branch.

## Reporting Issues

If you encounter any issues or bugs, don't hesitate to open an issue on the project's
[Issue Tracker](https://github.com/atahabaki/bracoxide/issues). We appreciate detailed
descriptions of the problem you're facing to help us understand and address it effectively.

If you have any questions or need assistance, feel free to open a discussion. We're here
to help and provide support.

## Feature Requests

If you have ideas for new features or improvements, we encourage you to open a feature request
on the project's [Issue Tracker](https://github.com/atahabaki/bracoxide/issues). Describe the
features or improvement you would like to see and provide any relevant context or examples.

## Code Style and Guidelines

- Follow the existing code style and conventions used in the project.
    - Before commiting any changes,
        - make sure to format with `cargo fmt`.
        - run cargo clippy, `cargo clippy -- -D clippy::unwrap_used`
- Write clear, concise, and self-explanatory code.
- Document your code using inline comments and appropriate docstrings.
- Write comprehensive test cases to validate your changes.
- Ensure that your changes do not introduce unnecessary dependencies.

## License

By contributing to the Bracoxide project, you agree that your contributions will be licensed
under the [MIT License](LICENSE).

We appreciate your interest in contributing to Bracoxide. Together, we can make it even better!

