// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/networking/trafficdirector/type/traffic_director_log_entry.proto

package _type

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines possible values of client type.
type TrafficDirectorLogEntry_ClientType int32

const (
	// Unspecified.
	TrafficDirectorLogEntry_CLIENT_TYPE_UNSPECIFIED TrafficDirectorLogEntry_ClientType = 0
	// Envoy client.
	TrafficDirectorLogEntry_ENVOY TrafficDirectorLogEntry_ClientType = 1
	// gRPC Java client.
	TrafficDirectorLogEntry_GRPC_JAVA TrafficDirectorLogEntry_ClientType = 2
	// gRPC C++ client.
	TrafficDirectorLogEntry_GRPC_CPP TrafficDirectorLogEntry_ClientType = 3
	// gRPC Python client.
	TrafficDirectorLogEntry_GRPC_PYTHON TrafficDirectorLogEntry_ClientType = 4
	// gRPC Go client.
	TrafficDirectorLogEntry_GRPC_GO TrafficDirectorLogEntry_ClientType = 5
	// gRPC Ruby client.
	TrafficDirectorLogEntry_GRPC_RUBY TrafficDirectorLogEntry_ClientType = 6
	// gRPC Ruby client.
	TrafficDirectorLogEntry_GRPC_PHP TrafficDirectorLogEntry_ClientType = 7
	// gRPC Node client.
	TrafficDirectorLogEntry_GRPC_NODE TrafficDirectorLogEntry_ClientType = 8
	// gRPC CSharp client.
	TrafficDirectorLogEntry_GRPC_CSHARP TrafficDirectorLogEntry_ClientType = 9
	// unknown client type.
	TrafficDirectorLogEntry_UNKNOWN TrafficDirectorLogEntry_ClientType = 10
)

// Enum value maps for TrafficDirectorLogEntry_ClientType.
var (
	TrafficDirectorLogEntry_ClientType_name = map[int32]string{
		0:  "CLIENT_TYPE_UNSPECIFIED",
		1:  "ENVOY",
		2:  "GRPC_JAVA",
		3:  "GRPC_CPP",
		4:  "GRPC_PYTHON",
		5:  "GRPC_GO",
		6:  "GRPC_RUBY",
		7:  "GRPC_PHP",
		8:  "GRPC_NODE",
		9:  "GRPC_CSHARP",
		10: "UNKNOWN",
	}
	TrafficDirectorLogEntry_ClientType_value = map[string]int32{
		"CLIENT_TYPE_UNSPECIFIED": 0,
		"ENVOY":                   1,
		"GRPC_JAVA":               2,
		"GRPC_CPP":                3,
		"GRPC_PYTHON":             4,
		"GRPC_GO":                 5,
		"GRPC_RUBY":               6,
		"GRPC_PHP":                7,
		"GRPC_NODE":               8,
		"GRPC_CSHARP":             9,
		"UNKNOWN":                 10,
	}
)

func (x TrafficDirectorLogEntry_ClientType) Enum() *TrafficDirectorLogEntry_ClientType {
	p := new(TrafficDirectorLogEntry_ClientType)
	*p = x
	return p
}

func (x TrafficDirectorLogEntry_ClientType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrafficDirectorLogEntry_ClientType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_enumTypes[0].Descriptor()
}

func (TrafficDirectorLogEntry_ClientType) Type() protoreflect.EnumType {
	return &file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_enumTypes[0]
}

func (x TrafficDirectorLogEntry_ClientType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrafficDirectorLogEntry_ClientType.Descriptor instead.
func (TrafficDirectorLogEntry_ClientType) EnumDescriptor() ([]byte, []int) {
	return file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescGZIP(), []int{0, 0}
}

// Defines possible values of API version.
type TrafficDirectorLogEntry_TransportApiVersion int32

const (
	// Unspecified.
	TrafficDirectorLogEntry_TRANSPORT_API_VERSION_UNSPECIFIED TrafficDirectorLogEntry_TransportApiVersion = 0
	// v2 xDS version.
	TrafficDirectorLogEntry_V2 TrafficDirectorLogEntry_TransportApiVersion = 1
	// v3 xDS version.
	TrafficDirectorLogEntry_V3 TrafficDirectorLogEntry_TransportApiVersion = 2
)

// Enum value maps for TrafficDirectorLogEntry_TransportApiVersion.
var (
	TrafficDirectorLogEntry_TransportApiVersion_name = map[int32]string{
		0: "TRANSPORT_API_VERSION_UNSPECIFIED",
		1: "V2",
		2: "V3",
	}
	TrafficDirectorLogEntry_TransportApiVersion_value = map[string]int32{
		"TRANSPORT_API_VERSION_UNSPECIFIED": 0,
		"V2":                                1,
		"V3":                                2,
	}
)

func (x TrafficDirectorLogEntry_TransportApiVersion) Enum() *TrafficDirectorLogEntry_TransportApiVersion {
	p := new(TrafficDirectorLogEntry_TransportApiVersion)
	*p = x
	return p
}

func (x TrafficDirectorLogEntry_TransportApiVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TrafficDirectorLogEntry_TransportApiVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_enumTypes[1].Descriptor()
}

func (TrafficDirectorLogEntry_TransportApiVersion) Type() protoreflect.EnumType {
	return &file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_enumTypes[1]
}

func (x TrafficDirectorLogEntry_TransportApiVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TrafficDirectorLogEntry_TransportApiVersion.Descriptor instead.
func (TrafficDirectorLogEntry_TransportApiVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescGZIP(), []int{0, 1}
}

// A common proto for describing how the Traffic Director handles
// xDS-connections/requests/responses.
type TrafficDirectorLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An ID of xDS-client connecting to the Traffic Director.
	NodeId string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// The string representation of IPv4 or IPv6 address of xDS-client
	// connecting to the Traffic Director.
	// IPv4 address must be in the format defined in RFC791, four octets separated
	// by a period. Size of a string is between 7-15 characters. Example: 1.2.3.4
	// IPv6 address must be in one of the formats defined in RFC4291. Size of a
	// string is between 7-39 characters. Example: 2001:DB8:0:0:8:800:200C:417A
	NodeIp string `protobuf:"bytes,2,opt,name=node_ip,json=nodeIp,proto3" json:"node_ip,omitempty"`
	// A free text describing details of the event.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Type of xDS-client connecting to Traffic Director
	ClientType TrafficDirectorLogEntry_ClientType `protobuf:"varint,5,opt,name=client_type,json=clientType,proto3,enum=google.networking.trafficdirector.type.TrafficDirectorLogEntry_ClientType" json:"client_type,omitempty"`
	// The version of xDS-client connecting to Traffic Director.
	ClientVersion string `protobuf:"bytes,6,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
	// The xDS API version used by xDS clients connecting to Traffic Director.
	TransportApiVersion TrafficDirectorLogEntry_TransportApiVersion `protobuf:"varint,7,opt,name=transport_api_version,json=transportApiVersion,proto3,enum=google.networking.trafficdirector.type.TrafficDirectorLogEntry_TransportApiVersion" json:"transport_api_version,omitempty"`
}

func (x *TrafficDirectorLogEntry) Reset() {
	*x = TrafficDirectorLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrafficDirectorLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficDirectorLogEntry) ProtoMessage() {}

func (x *TrafficDirectorLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficDirectorLogEntry.ProtoReflect.Descriptor instead.
func (*TrafficDirectorLogEntry) Descriptor() ([]byte, []int) {
	return file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescGZIP(), []int{0}
}

func (x *TrafficDirectorLogEntry) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (x *TrafficDirectorLogEntry) GetNodeIp() string {
	if x != nil {
		return x.NodeIp
	}
	return ""
}

func (x *TrafficDirectorLogEntry) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TrafficDirectorLogEntry) GetClientType() TrafficDirectorLogEntry_ClientType {
	if x != nil {
		return x.ClientType
	}
	return TrafficDirectorLogEntry_CLIENT_TYPE_UNSPECIFIED
}

func (x *TrafficDirectorLogEntry) GetClientVersion() string {
	if x != nil {
		return x.ClientVersion
	}
	return ""
}

func (x *TrafficDirectorLogEntry) GetTransportApiVersion() TrafficDirectorLogEntry_TransportApiVersion {
	if x != nil {
		return x.TransportApiVersion
	}
	return TrafficDirectorLogEntry_TRANSPORT_API_VERSION_UNSPECIFIED
}

var File_google_networking_trafficdirector_type_traffic_director_log_entry_proto protoreflect.FileDescriptor

var file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDesc = []byte{
	0x0a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x2f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63,
	0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x22, 0x95, 0x05, 0x0a, 0x17, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x17, 0x0a,
	0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x70, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x6b, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x87, 0x01, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
	0x6f, 0x72, 0x74, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x54,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x4c, 0x6f,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74,
	0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xb9, 0x01, 0x0a, 0x0a, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x4e, 0x56, 0x4f, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x4a,
	0x41, 0x56, 0x41, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x43, 0x50,
	0x50, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x50, 0x59, 0x54, 0x48,
	0x4f, 0x4e, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x47, 0x4f, 0x10,
	0x05, 0x12, 0x0d, 0x0a, 0x09, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x52, 0x55, 0x42, 0x59, 0x10, 0x06,
	0x12, 0x0c, 0x0a, 0x08, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x50, 0x48, 0x50, 0x10, 0x07, 0x12, 0x0d,
	0x0a, 0x09, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x08, 0x12, 0x0f, 0x0a,
	0x0b, 0x47, 0x52, 0x50, 0x43, 0x5f, 0x43, 0x53, 0x48, 0x41, 0x52, 0x50, 0x10, 0x09, 0x12, 0x0b,
	0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x0a, 0x22, 0x4c, 0x0a, 0x13, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f,
	0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x32, 0x10,
	0x01, 0x12, 0x06, 0x0a, 0x02, 0x56, 0x33, 0x10, 0x02, 0x42, 0xac, 0x02, 0x0a, 0x2a, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x2e, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x64, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x42, 0x1c, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x2f, 0x74, 0x79, 0x70, 0x65, 0xa2,
	0x02, 0x05, 0x54, 0x52, 0x46, 0x43, 0x44, 0xaa, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0xca, 0x02, 0x2c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x5c, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x5c, 0x54, 0x79, 0x70, 0x65, 0xea, 0x02, 0x30, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x3a, 0x3a, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x3a, 0x3a, 0x54, 0x79, 0x70, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescOnce sync.Once
	file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescData = file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDesc
)

func file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescGZIP() []byte {
	file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescOnce.Do(func() {
		file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescData)
	})
	return file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDescData
}

var file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_goTypes = []interface{}{
	(TrafficDirectorLogEntry_ClientType)(0),          // 0: google.networking.trafficdirector.type.TrafficDirectorLogEntry.ClientType
	(TrafficDirectorLogEntry_TransportApiVersion)(0), // 1: google.networking.trafficdirector.type.TrafficDirectorLogEntry.TransportApiVersion
	(*TrafficDirectorLogEntry)(nil),                  // 2: google.networking.trafficdirector.type.TrafficDirectorLogEntry
}
var file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_depIdxs = []int32{
	0, // 0: google.networking.trafficdirector.type.TrafficDirectorLogEntry.client_type:type_name -> google.networking.trafficdirector.type.TrafficDirectorLogEntry.ClientType
	1, // 1: google.networking.trafficdirector.type.TrafficDirectorLogEntry.transport_api_version:type_name -> google.networking.trafficdirector.type.TrafficDirectorLogEntry.TransportApiVersion
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_init() }
func file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_init() {
	if File_google_networking_trafficdirector_type_traffic_director_log_entry_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrafficDirectorLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_goTypes,
		DependencyIndexes: file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_depIdxs,
		EnumInfos:         file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_enumTypes,
		MessageInfos:      file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_msgTypes,
	}.Build()
	File_google_networking_trafficdirector_type_traffic_director_log_entry_proto = out.File
	file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_rawDesc = nil
	file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_goTypes = nil
	file_google_networking_trafficdirector_type_traffic_director_log_entry_proto_depIdxs = nil
}
