import shallowEqual from "./shallowEqual";
import { deserializeUrlNameMap } from "./urlName";
let cachedSearchString;
let cachedUrlNameMapString;
let cachedSearchStringToObjectFn;
let cachedParsedQuery = {};
const memoSearchStringToObject = (searchStringToObject, searchString, urlNameMapStr) => {
  if (cachedSearchString === searchString && cachedSearchStringToObjectFn === searchStringToObject && cachedUrlNameMapString === urlNameMapStr) {
    return cachedParsedQuery;
  }
  cachedSearchString = searchString;
  cachedSearchStringToObjectFn = searchStringToObject;
  const newParsedQuery = searchStringToObject(searchString != null ? searchString : "");
  cachedUrlNameMapString = urlNameMapStr;
  const urlNameMap = deserializeUrlNameMap(urlNameMapStr);
  for (let [key, value] of Object.entries(newParsedQuery)) {
    if (urlNameMap == null ? void 0 : urlNameMap[key]) {
      delete newParsedQuery[key];
      key = urlNameMap[key];
      newParsedQuery[key] = value;
    }
    const oldValue = cachedParsedQuery[key];
    if (shallowEqual(value, oldValue)) {
      newParsedQuery[key] = oldValue;
    }
  }
  cachedParsedQuery = newParsedQuery;
  return newParsedQuery;
};
export {
  memoSearchStringToObject
};
//# sourceMappingURL=memoSearchStringToObject.js.map
