import {
  StringParam
} from "serialize-query-params";
function convertInheritedParamStringsToParams(paramConfigMapWithInherit, options) {
  var _a, _b, _c;
  const paramConfigMap = {};
  let hasInherit = false;
  const hookKeys = Object.keys(paramConfigMapWithInherit);
  let paramKeys = hookKeys;
  const includeKnownParams = options.includeKnownParams || options.includeKnownParams !== false && hookKeys.length === 0;
  if (includeKnownParams) {
    const knownKeys = Object.keys((_a = options.params) != null ? _a : {});
    paramKeys.push(...knownKeys);
  }
  for (const key of paramKeys) {
    const param = paramConfigMapWithInherit[key];
    if (param != null && typeof param === "object") {
      paramConfigMap[key] = param;
      continue;
    }
    hasInherit = true;
    paramConfigMap[key] = (_c = (_b = options.params) == null ? void 0 : _b[key]) != null ? _c : StringParam;
  }
  if (!hasInherit)
    return paramConfigMapWithInherit;
  return paramConfigMap;
}
function extendParamConfigForKeys(baseParamConfigMap, paramKeys, inheritedParams, defaultParam) {
  var _a;
  if (!inheritedParams || !paramKeys.length)
    return baseParamConfigMap;
  let paramConfigMap = { ...baseParamConfigMap };
  let hasInherit = false;
  for (const paramKey of paramKeys) {
    if (!Object.prototype.hasOwnProperty.call(paramConfigMap, paramKey)) {
      paramConfigMap[paramKey] = (_a = inheritedParams[paramKey]) != null ? _a : defaultParam;
      hasInherit = true;
    }
  }
  if (!hasInherit)
    return baseParamConfigMap;
  return paramConfigMap;
}
export {
  convertInheritedParamStringsToParams,
  extendParamConfigForKeys
};
//# sourceMappingURL=inheritedParams.js.map
