package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAntiBruteForceRules invokes the sas.DescribeAntiBruteForceRules API synchronously
func (client *Client) DescribeAntiBruteForceRules(request *DescribeAntiBruteForceRulesRequest) (response *DescribeAntiBruteForceRulesResponse, err error) {
	response = CreateDescribeAntiBruteForceRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAntiBruteForceRulesWithChan invokes the sas.DescribeAntiBruteForceRules API asynchronously
func (client *Client) DescribeAntiBruteForceRulesWithChan(request *DescribeAntiBruteForceRulesRequest) (<-chan *DescribeAntiBruteForceRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeAntiBruteForceRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAntiBruteForceRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAntiBruteForceRulesWithCallback invokes the sas.DescribeAntiBruteForceRules API asynchronously
func (client *Client) DescribeAntiBruteForceRulesWithCallback(request *DescribeAntiBruteForceRulesRequest, callback func(response *DescribeAntiBruteForceRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAntiBruteForceRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAntiBruteForceRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAntiBruteForceRulesRequest is the request struct for api DescribeAntiBruteForceRules
type DescribeAntiBruteForceRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
}

// DescribeAntiBruteForceRulesResponse is the response struct for api DescribeAntiBruteForceRules
type DescribeAntiBruteForceRulesResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo             `json:"PageInfo" xml:"PageInfo"`
	Rules     []AntiBruteForceRule `json:"Rules" xml:"Rules"`
}

// CreateDescribeAntiBruteForceRulesRequest creates a request to invoke DescribeAntiBruteForceRules API
func CreateDescribeAntiBruteForceRulesRequest() (request *DescribeAntiBruteForceRulesRequest) {
	request = &DescribeAntiBruteForceRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeAntiBruteForceRules", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAntiBruteForceRulesResponse creates a response to parse from DescribeAntiBruteForceRules response
func CreateDescribeAntiBruteForceRulesResponse() (response *DescribeAntiBruteForceRulesResponse) {
	response = &DescribeAntiBruteForceRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
