package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGreyTagRoute invokes the sae.CreateGreyTagRoute API synchronously
func (client *Client) CreateGreyTagRoute(request *CreateGreyTagRouteRequest) (response *CreateGreyTagRouteResponse, err error) {
	response = CreateCreateGreyTagRouteResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGreyTagRouteWithChan invokes the sae.CreateGreyTagRoute API asynchronously
func (client *Client) CreateGreyTagRouteWithChan(request *CreateGreyTagRouteRequest) (<-chan *CreateGreyTagRouteResponse, <-chan error) {
	responseChan := make(chan *CreateGreyTagRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGreyTagRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGreyTagRouteWithCallback invokes the sae.CreateGreyTagRoute API asynchronously
func (client *Client) CreateGreyTagRouteWithCallback(request *CreateGreyTagRouteRequest, callback func(response *CreateGreyTagRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGreyTagRouteResponse
		var err error
		defer close(result)
		response, err = client.CreateGreyTagRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGreyTagRouteRequest is the request struct for api CreateGreyTagRoute
type CreateGreyTagRouteRequest struct {
	*requests.RoaRequest
	AppId       string `position:"Query" name:"AppId"`
	Name        string `position:"Query" name:"Name"`
	Description string `position:"Query" name:"Description"`
	DubboRules  string `position:"Query" name:"DubboRules"`
	ScRules     string `position:"Query" name:"ScRules"`
}

// CreateGreyTagRouteResponse is the response struct for api CreateGreyTagRoute
type CreateGreyTagRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateGreyTagRouteRequest creates a request to invoke CreateGreyTagRoute API
func CreateCreateGreyTagRouteRequest() (request *CreateGreyTagRouteRequest) {
	request = &CreateGreyTagRouteRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "CreateGreyTagRoute", "/pop/v1/sam/tagroute/greyTagRoute", "serverless", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGreyTagRouteResponse creates a response to parse from CreateGreyTagRoute response
func CreateCreateGreyTagRouteResponse() (response *CreateGreyTagRouteResponse) {
	response = &CreateGreyTagRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
