package multimediaai

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFaceGroup invokes the multimediaai.CreateFaceGroup API synchronously
// api document: https://help.aliyun.com/api/multimediaai/createfacegroup.html
func (client *Client) CreateFaceGroup(request *CreateFaceGroupRequest) (response *CreateFaceGroupResponse, err error) {
	response = CreateCreateFaceGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFaceGroupWithChan invokes the multimediaai.CreateFaceGroup API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/createfacegroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFaceGroupWithChan(request *CreateFaceGroupRequest) (<-chan *CreateFaceGroupResponse, <-chan error) {
	responseChan := make(chan *CreateFaceGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFaceGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFaceGroupWithCallback invokes the multimediaai.CreateFaceGroup API asynchronously
// api document: https://help.aliyun.com/api/multimediaai/createfacegroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFaceGroupWithCallback(request *CreateFaceGroupRequest, callback func(response *CreateFaceGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFaceGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateFaceGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFaceGroupRequest is the request struct for api CreateFaceGroup
type CreateFaceGroupRequest struct {
	*requests.RpcRequest
	Description   string `position:"Query" name:"Description"`
	FaceGroupName string `position:"Query" name:"FaceGroupName"`
}

// CreateFaceGroupResponse is the response struct for api CreateFaceGroup
type CreateFaceGroupResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	FaceGroupId int64  `json:"FaceGroupId" xml:"FaceGroupId"`
}

// CreateCreateFaceGroupRequest creates a request to invoke CreateFaceGroup API
func CreateCreateFaceGroupRequest() (request *CreateFaceGroupRequest) {
	request = &CreateFaceGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("multimediaai", "2019-08-10", "CreateFaceGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateFaceGroupResponse creates a response to parse from CreateFaceGroup response
func CreateCreateFaceGroupResponse() (response *CreateFaceGroupResponse) {
	response = &CreateFaceGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
