package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestFlowStrategy01 invokes the ft.TestFlowStrategy01 API synchronously
func (client *Client) TestFlowStrategy01(request *TestFlowStrategy01Request) (response *TestFlowStrategy01Response, err error) {
	response = CreateTestFlowStrategy01Response()
	err = client.DoAction(request, response)
	return
}

// TestFlowStrategy01WithChan invokes the ft.TestFlowStrategy01 API asynchronously
func (client *Client) TestFlowStrategy01WithChan(request *TestFlowStrategy01Request) (<-chan *TestFlowStrategy01Response, <-chan error) {
	responseChan := make(chan *TestFlowStrategy01Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestFlowStrategy01(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestFlowStrategy01WithCallback invokes the ft.TestFlowStrategy01 API asynchronously
func (client *Client) TestFlowStrategy01WithCallback(request *TestFlowStrategy01Request, callback func(response *TestFlowStrategy01Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestFlowStrategy01Response
		var err error
		defer close(result)
		response, err = client.TestFlowStrategy01(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestFlowStrategy01Request is the request struct for api TestFlowStrategy01
type TestFlowStrategy01Request struct {
	*requests.RpcRequest
	Names map[string]interface{} `position:"Body" name:"Names"`
}

// TestFlowStrategy01Response is the response struct for api TestFlowStrategy01
type TestFlowStrategy01Response struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	List      []string `json:"List" xml:"List"`
	Names     []string `json:"Names" xml:"Names"`
}

// CreateTestFlowStrategy01Request creates a request to invoke TestFlowStrategy01 API
func CreateTestFlowStrategy01Request() (request *TestFlowStrategy01Request) {
	request = &TestFlowStrategy01Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "TestFlowStrategy01", "", "")
	request.Method = requests.PUT
	return
}

// CreateTestFlowStrategy01Response creates a response to parse from TestFlowStrategy01 response
func CreateTestFlowStrategy01Response() (response *TestFlowStrategy01Response) {
	response = &TestFlowStrategy01Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
