package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySendStatistics invokes the dysmsapi.QuerySendStatistics API synchronously
func (client *Client) QuerySendStatistics(request *QuerySendStatisticsRequest) (response *QuerySendStatisticsResponse, err error) {
	response = CreateQuerySendStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySendStatisticsWithChan invokes the dysmsapi.QuerySendStatistics API asynchronously
func (client *Client) QuerySendStatisticsWithChan(request *QuerySendStatisticsRequest) (<-chan *QuerySendStatisticsResponse, <-chan error) {
	responseChan := make(chan *QuerySendStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySendStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySendStatisticsWithCallback invokes the dysmsapi.QuerySendStatistics API asynchronously
func (client *Client) QuerySendStatisticsWithCallback(request *QuerySendStatisticsRequest, callback func(response *QuerySendStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySendStatisticsResponse
		var err error
		defer close(result)
		response, err = client.QuerySendStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySendStatisticsRequest is the request struct for api QuerySendStatistics
type QuerySendStatisticsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	IsGlobe              requests.Integer `position:"Query" name:"IsGlobe"`
	StartDate            string           `position:"Query" name:"StartDate"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	PageIndex            requests.Integer `position:"Query" name:"PageIndex"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	EndDate              string           `position:"Query" name:"EndDate"`
}

// QuerySendStatisticsResponse is the response struct for api QuerySendStatistics
type QuerySendStatisticsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQuerySendStatisticsRequest creates a request to invoke QuerySendStatistics API
func CreateQuerySendStatisticsRequest() (request *QuerySendStatisticsRequest) {
	request = &QuerySendStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "QuerySendStatistics", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySendStatisticsResponse creates a response to parse from QuerySendStatistics response
func CreateQuerySendStatisticsResponse() (response *QuerySendStatisticsResponse) {
	response = &QuerySendStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
