package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDataSource invokes the dataworks_public.UpdateDataSource API synchronously
func (client *Client) UpdateDataSource(request *UpdateDataSourceRequest) (response *UpdateDataSourceResponse, err error) {
	response = CreateUpdateDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDataSourceWithChan invokes the dataworks_public.UpdateDataSource API asynchronously
func (client *Client) UpdateDataSourceWithChan(request *UpdateDataSourceRequest) (<-chan *UpdateDataSourceResponse, <-chan error) {
	responseChan := make(chan *UpdateDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDataSourceWithCallback invokes the dataworks_public.UpdateDataSource API asynchronously
func (client *Client) UpdateDataSourceWithCallback(request *UpdateDataSourceRequest, callback func(response *UpdateDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDataSourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDataSourceRequest is the request struct for api UpdateDataSource
type UpdateDataSourceRequest struct {
	*requests.RpcRequest
	EnvType      requests.Integer `position:"Query" name:"EnvType"`
	DataSourceId requests.Integer `position:"Query" name:"DataSourceId"`
	Description  string           `position:"Query" name:"Description"`
	Content      string           `position:"Query" name:"Content"`
	Status       string           `position:"Query" name:"Status"`
}

// UpdateDataSourceResponse is the response struct for api UpdateDataSource
type UpdateDataSourceResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDataSourceRequest creates a request to invoke UpdateDataSource API
func CreateUpdateDataSourceRequest() (request *UpdateDataSourceRequest) {
	request = &UpdateDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateDataSource", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateDataSourceResponse creates a response to parse from UpdateDataSource response
func CreateUpdateDataSourceResponse() (response *UpdateDataSourceResponse) {
	response = &UpdateDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
