package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySkillGroupEx invokes the cloudcallcenter.ModifySkillGroupEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyskillgroupex.html
func (client *Client) ModifySkillGroupEx(request *ModifySkillGroupExRequest) (response *ModifySkillGroupExResponse, err error) {
	response = CreateModifySkillGroupExResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySkillGroupExWithChan invokes the cloudcallcenter.ModifySkillGroupEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyskillgroupex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySkillGroupExWithChan(request *ModifySkillGroupExRequest) (<-chan *ModifySkillGroupExResponse, <-chan error) {
	responseChan := make(chan *ModifySkillGroupExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySkillGroupEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySkillGroupExWithCallback invokes the cloudcallcenter.ModifySkillGroupEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyskillgroupex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySkillGroupExWithCallback(request *ModifySkillGroupExRequest, callback func(response *ModifySkillGroupExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySkillGroupExResponse
		var err error
		defer close(result)
		response, err = client.ModifySkillGroupEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySkillGroupExRequest is the request struct for api ModifySkillGroupEx
type ModifySkillGroupExRequest struct {
	*requests.RpcRequest
	AllowPrivateOutboundNumber requests.Boolean `position:"Query" name:"AllowPrivateOutboundNumber"`
	Description                string           `position:"Query" name:"Description"`
	RoutingStrategy            string           `position:"Query" name:"RoutingStrategy"`
	UserId                     *[]string        `position:"Query" name:"UserId"  type:"Repeated"`
	SkillLevel                 *[]string        `position:"Query" name:"SkillLevel"  type:"Repeated"`
	InstanceId                 string           `position:"Query" name:"InstanceId"`
	OutboundPhoneNumberId      *[]string        `position:"Query" name:"OutboundPhoneNumberId"  type:"Repeated"`
	SkillGroupId               string           `position:"Query" name:"SkillGroupId"`
	Name                       string           `position:"Query" name:"Name"`
}

// ModifySkillGroupExResponse is the response struct for api ModifySkillGroupEx
type ModifySkillGroupExResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateModifySkillGroupExRequest creates a request to invoke ModifySkillGroupEx API
func CreateModifySkillGroupExRequest() (request *ModifySkillGroupExRequest) {
	request = &ModifySkillGroupExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifySkillGroupEx", "", "")
	request.Method = requests.POST
	return
}

// CreateModifySkillGroupExResponse creates a response to parse from ModifySkillGroupEx response
func CreateModifySkillGroupExResponse() (response *ModifySkillGroupExResponse) {
	response = &ModifySkillGroupExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
