package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvokeSendMessage invokes the cloudcallcenter.InvokeSendMessage API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/invokesendmessage.html
func (client *Client) InvokeSendMessage(request *InvokeSendMessageRequest) (response *InvokeSendMessageResponse, err error) {
	response = CreateInvokeSendMessageResponse()
	err = client.DoAction(request, response)
	return
}

// InvokeSendMessageWithChan invokes the cloudcallcenter.InvokeSendMessage API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/invokesendmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InvokeSendMessageWithChan(request *InvokeSendMessageRequest) (<-chan *InvokeSendMessageResponse, <-chan error) {
	responseChan := make(chan *InvokeSendMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvokeSendMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvokeSendMessageWithCallback invokes the cloudcallcenter.InvokeSendMessage API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/invokesendmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InvokeSendMessageWithCallback(request *InvokeSendMessageRequest, callback func(response *InvokeSendMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvokeSendMessageResponse
		var err error
		defer close(result)
		response, err = client.InvokeSendMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvokeSendMessageRequest is the request struct for api InvokeSendMessage
type InvokeSendMessageRequest struct {
	*requests.RpcRequest
	PhoneNumbers  string `position:"Query" name:"PhoneNumbers"`
	ConfigId      string `position:"Query" name:"ConfigId"`
	TenantId      string `position:"Query" name:"TenantId"`
	TemplateParam string `position:"Query" name:"TemplateParam"`
}

// InvokeSendMessageResponse is the response struct for api InvokeSendMessage
type InvokeSendMessageResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Payload        string `json:"Payload" xml:"Payload"`
}

// CreateInvokeSendMessageRequest creates a request to invoke InvokeSendMessage API
func CreateInvokeSendMessageRequest() (request *InvokeSendMessageRequest) {
	request = &InvokeSendMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "InvokeSendMessage", "", "")
	request.Method = requests.POST
	return
}

// CreateInvokeSendMessageResponse creates a response to parse from InvokeSendMessage response
func CreateInvokeSendMessageResponse() (response *InvokeSendMessageResponse) {
	response = &InvokeSendMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
