## RabbitMQ 4.0.4

RabbitMQ `4.0.4` is a maintenance release in the `4.0.x` [release series](https://www.rabbitmq.com/release-information).

It was re-tagged (but not rebuilt) to [`bdb30ca`](https://github.com/rabbitmq/rabbitmq-server/commit/bdb30ca0edc7065a5be58decb4714d2488ce7362) after its original release on Nov 21, 2024.
Packages were not rebuilt, only the tag was incorrect.

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

It is **strongly recommended** that you read [4.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v4.0.1)
in detail if upgrading from a version prior to `4.0.0`.


### Minimum Supported Erlang Version

This release requires Erlang 26 and supports Erlang versions up to `27.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.

Nodes **will fail to start** on older Erlang releases.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v4.0.x/release-notes).

### Core Broker

#### Bug Fixes

 * In rare cases quorum queue could end up without an elected leader because
   chosen candidate replica was not verified for aliveness.

   Contributed by @Ayanda-D.

   GitHub issues: [#12727](https://github.com/rabbitmq/rabbitmq-server/pull/12727), [#10423](https://github.com/rabbitmq/rabbitmq-server/discussions/10423), [#12701](https://github.com/rabbitmq/rabbitmq-server/discussions/12701)

 * Quorum queue follower replicas that have falled behind the leader could
   run into an exception after installing a snapshot.

   GitHub issue: [#12635](https://github.com/rabbitmq/rabbitmq-server/issues/12635)

 * Clusters with a large number of streams could run into confusing timeout
   exceptions.

   GitHub issue: [#12693](https://github.com/rabbitmq/rabbitmq-server/pull/12693)

 * Stream members could fail to start when their data directories had externally added files,
   for example, metadata of certain file systems.

   GitHub issue: [#12688](https://github.com/rabbitmq/rabbitmq-server/issues/12688)

 * Fetching metrics of AMQP 1.0 connections could fail with an exception.

   GitHub issue: [#12700](https://github.com/rabbitmq/rabbitmq-server/pull/12700)

 * Nodes using Khepri for schema data store now follow a set of `rabbitmqctl reset` procedures
   better aligned with those performed by nodes still using Mnesia.

   GitHub issue: [#12763](https://github.com/rabbitmq/rabbitmq-server/pull/12763)

#### Enhancements

 * Policy changes are now periodicaly re-applied (only if necessary) to quorum queues.
   Quorum queues that did not have an online elected leader at the time
   of policy change would now eventually "pick up" the settings from that policy.

   Contributed by @LoisSotoLopez.

   GitHub issue: [#12667](https://github.com/rabbitmq/rabbitmq-server/pull/12667)

 * Clusters with many streams and stream consumers will see a reduced per-stream CPU and network I/O
   footprint.

   GitHub issue: [#12685](https://github.com/rabbitmq/rabbitmq-server/pull/12685)

 * Clusters now can optionally be tagged with key-value pairs (cluster tags). The tags will
   be reported by `rabbitmq-diagnostics cluster_status` and the `GET /api/overview` HTTP API endpoint.

   Note that the Prometheus scraper API endpoint intentionally omits them because this kind of
   metadata in Prometheus is considered to be [deployment and not application metadata](https://github.com/rabbitmq/rabbitmq-server/issues/12552#issuecomment-2424985095).

   The tags are configured using `rabbitmq.conf`:

   ```ini
   cluster_tags.environment = production

   cluster_tags.region = us-east
   cluster_tags.az = us-east-3
   ```

   Contributed by @SimonUnge.

   GitHub issue: [#12552](https://github.com/rabbitmq/rabbitmq-server/issues/12552)

 * Nodes now can optionally be tagged with key-value pairs (node tags). The tags will
   be reported by `rabbitmq-diagnostics status` and the `GET /api/overview` HTTP API endpoint.

   Note that the Prometheus scraper API endpoint intentionally omits them because this kind of
   metadata in Prometheus is considered to be [deployment and not application metadata](https://github.com/rabbitmq/rabbitmq-server/issues/12552#issuecomment-2424985095).

   The tags are configured using `rabbitmq.conf`:

   ```ini
   nodes_tags.environment = production

   nodes_tags.region = us-east
   nodes_tags.az = us-east-3
   ```

   Contributed by @SimonUnge.

   GitHub issue: [#12703](https://github.com/rabbitmq/rabbitmq-server/pull/12703)

 * When a [max length](https://www.rabbitmq.com/docs/maxlength) limit is applied to a quorum queue with a larger backlog (e.g. millions of messages),
   the deletion of excess messages now carries a significantly more moderate spike in memory footprint
   of the queue.

   GitHub issue: [#12608](https://github.com/rabbitmq/rabbitmq-server/issues/12608)


### CLI Tools

#### Bug Fixes

 * `rabbitmq-diagnostics check_if_any_deprecated_features_are_used` now takes more deprecated features
   into account.

   GitHub issue: [#12734](https://github.com/rabbitmq/rabbitmq-server/pull/12734), [#12738](https://github.com/rabbitmq/rabbitmq-server/pull/12738)


### MQTT Plugin

#### Bug Fixes

 * A message with expiration (TTL) set, that was published by an AMQP 0-9-1 publusher,
   could not be converted for an MQTT consumer.

   GitHub issue: [#12711](https://github.com/rabbitmq/rabbitmq-server/pull/12711)

 * When x.509 (TLS) certificate-based authentication was used, two keys that controlled
   what SAN (Subject Alternative Name) fields were used to fetch client identity did not
   have any effect when used in `rabbitmq.conf`.

   Partially contributed by @janezturk.

   GitHub issue: [#12618](https://github.com/rabbitmq/rabbitmq-server/pull/12618)


### Prometheus Plugin and Grafana Dashboards

#### Bug Fixes

 * Tweaks for Grafana 11.3 compatibility.

   Contributed by @anhanhnguyen.

   GitHub issue: [#12720](https://github.com/rabbitmq/rabbitmq-server/pull/12720)


### Management Plugin

#### Enhancements

 * The endpoint that creates bindings now uses a much smaller HTTP request body
   size limit by default. Unlike the definition upload endpoint that accepts
   large definition documents, bindings do not need the generous multi-MiB limit.

   Note that the default HTTP request body size limit [can be configured](https://www.rabbitmq.com/docs/management#http-body-size-limit),
   for example, to reduce it across the board.

   GitHub issue: [#12697](https://github.com/rabbitmq/rabbitmq-server/pull/12697)

 * Improved alignment of optional queue arguments on the queue declaration page.

   Contributed by @markus812498.

   GitHub issue: [#12678](https://github.com/rabbitmq/rabbitmq-server/pull/12678)


### OAuth 2 Plugin

#### Bug Fixes

 * When configuring [multiple resource servers](https://www.rabbitmq.com/docs/oauth2#multiple-resource-servers-configuration),
  `additional_scopes_key` was not taken into account, which means some scopes were not considered
  when making an authorization decision.

  Contributed by @Hathoute.

   GitHub issue: [#12750](https://github.com/rabbitmq/rabbitmq-server/issues/12750)


### Debian Package

#### Enhancements

 * The package now lists Erlang 27.x as a supported series.

   GitHub issue: [#12603](https://github.com/rabbitmq/rabbitmq-server/issues/12603)

### RPM Package

#### Enhancements

 * The package now lists Erlang 27.x as a supported series.

   GitHub issue: [#12603](https://github.com/rabbitmq/rabbitmq-server/issues/12603)


### Dependency Changes

  * `osiris` was upgraded to [`1.8.4`](https://github.com/rabbitmq/osiris/releases/)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-4.0.4.tar.xz`
instead of the source tarball produced by GitHub.
