/*
 * Copyright (C) 2021-2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "Supplementable.h"
#include <wtf/CheckedRef.h>
#include <wtf/Forward.h>
#include <wtf/RefCounted.h>
#include <wtf/TZoneMalloc.h>

namespace WebCore {

class DeferredPromise;
class Navigator;

struct RequestCookieConsentOptions;

class NavigatorCookieConsent final : public Supplement<Navigator> {
    WTF_MAKE_TZONE_ALLOCATED(NavigatorCookieConsent);
public:
    explicit NavigatorCookieConsent(Navigator& navigator)
        : m_navigator(navigator)
    {
    }

    static void requestCookieConsent(Navigator&, RequestCookieConsentOptions&&, Ref<DeferredPromise>&&);

private:
    static NavigatorCookieConsent& from(Navigator&);
    static ASCIILiteral supplementName() { return "NavigatorCookieConsent"_s; }
    bool isNavigatorCookieConsent() const final { return true; }

    void requestCookieConsent(RequestCookieConsentOptions&&, Ref<DeferredPromise>&&);

    const CheckedRef<Navigator> m_navigator;
};

} // namespace WebCore

SPECIALIZE_TYPE_TRAITS_BEGIN(WebCore::NavigatorCookieConsent)
    static bool isType(const WebCore::SupplementBase& supplement) { return supplement.isNavigatorCookieConsent(); }
SPECIALIZE_TYPE_TRAITS_END()
