## TFSA-2020-028: Float cast overflow undefined behavior

### CVE Number
CVE-2020-15266

### Impact
When the `boxes` argument of `tf.image.crop_and_resize` has a very large value,
the CPU kernel implementation receives it as a C++ `nan` floating point value.
Attempting to operate on this is undefined behavior which later produces a
segmentation fault.

### Patches

We have patched the issue in
[c0319231333f0f16e1cc75ec83660b01fedd4182](https://github.com/tensorflow/tensorflow/commit/c0319231333f0f16e1cc75ec83660b01fedd4182)
and will release TensorFlow 2.4.0 containing the patch. TensorFlow nightly
packages after this commit will also have the issue resolved.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported in
[#42129](https://github.com/tensorflow/issues/42129).
