## TFSA-2020-021: Heap buffer overflow in SparseFillEmptyRowsGrad

### CVE Number
CVE-2020-15195

### Impact
The implementation of `SparseFillEmptyRowsGrad` uses a [double indexing
pattern](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/sparse_fill_empty_rows_op.cc#L263-L269):
```cc
      d_values(i) = grad_values(reverse_index_map(i));
```

It is possible for `reverse_index_map(i)` to be an index outside of bounds of
`grad_values`, thus resulting in a heap buffer overflow.

### Vulnerable Versions
TensorFlow 1.15.0, 1.15.1, 1.15.2, 1.15.3, 2.0.0, 2.0.1, 2.0.2, 2.1.0, 2.1.1,
2.2.0, 2.3.0.

### Patches
We have patched the issue in
[390611e0d45c5793c7066110af37c8514e6a6c54](https://github.com/tensorflow/tensorflow/commit/390611e0d45c5793c7066110af37c8514e6a6c54)
and will release a patch release for all affected versions.

We recommend users to upgrade to TensorFlow 1.15.4, 2.0.3, 2.1.2, 2.2.1, or
2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
