## TFSA-2018-003: TensorFlow Lite TOCO FlatBuffer Parsing Vulnerability

### CVE Number

CVE-2018-8825

### Issue Description

The TensorFlow Lite TOCO compiler does not perform correct boundary checks when
reading from some fields within TFLite files. 

As background, TFLite files are based on the FlatBuffers serialization format,
which does not have bounds checking built-in, rather it relies on the clients to
handle the appropriate security checks by themselves.

In particular, TOCO is not performing correct bounds checks in the following places:
* Out of bounds read in TOCO in import.cc:42
* Null dereference in TOCO in import.cc:135
* Out of bounds read in TOCO in import.cc:104
* Null dereference in TOCO in import.cc:121
* Out of bounds read in TOCO in import.cc:62
* Out of bounds read in TOCO in operator.cc:48
* Out of bounds read in TOCO graph_transformations (propagate_fixed_sizes.cc:93)


### Impact

Users passing a malformed or malicious version of a TFLite graph into TOCO will
cause TOCO to crash or cause a buffer overflow, potentially allowing malicious
code to be executed.

### Vulnerable Versions

TensorFlow 1.5.0, 1.5.1, 1.6.0, 1.7.0

### Mitigation

We have patched the vulnerability in GitHub commits [41335abb](https://github.com/tensorflow/tensorflow/commit/41335abb46f80ca644b5738550daef6136ba5476) and
[8badd11d](https://github.com/tensorflow/tensorflow/commit/8badd11d875a826bd318ed439909d5c47a7fb811).
If users are running the TensorFlow TFLite TOCO compiler in production or on
untrusted data, they are encouraged to apply this patch.

Additionally, we have released TensorFlow version 1.7.1 to mitigate this
vulnerability.

### Credits

This issue was discovered by the Blade Team of Tencent.
