/*
 * Decompiled with CFR 0.152.
 */
package adql.parser.feature;

import adql.db.FunctionDef;
import adql.parser.feature.LanguageFeature;
import adql.query.ClauseOffset;
import adql.query.SetOperationType;
import adql.query.WithItem;
import adql.query.constraint.ComparisonOperator;
import adql.query.operand.function.InUnitFunction;
import adql.query.operand.function.cast.CastFunction;
import adql.query.operand.function.conditional.CoalesceFunction;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.query.operand.function.string.LowerFunction;
import adql.query.operand.function.string.UpperFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class FeatureSet
implements Iterable<LanguageFeature> {
    protected final Map<String, Set<LanguageFeature>> supportedFeatures = new HashMap<String, Set<LanguageFeature>>();
    static LanguageFeature[] availableFeatures = new LanguageFeature[]{CoalesceFunction.FEATURE, SetOperationType.UNION.getFeatureDescription(), SetOperationType.EXCEPT.getFeatureDescription(), SetOperationType.INTERSECT.getFeatureDescription(), CastFunction.FEATURE, WithItem.FEATURE, InUnitFunction.FEATURE, ClauseOffset.FEATURE, ComparisonOperator.ILIKE.getFeatureDescription(), LowerFunction.FEATURE, UpperFunction.FEATURE, AreaFunction.FEATURE, BoxFunction.FEATURE, CentroidFunction.FEATURE, CircleFunction.FEATURE, ContainsFunction.FEATURE, ExtractCoord.FEATURE_COORD1, ExtractCoord.FEATURE_COORD2, ExtractCoordSys.FEATURE, DistanceFunction.FEATURE, IntersectsFunction.FEATURE, PointFunction.FEATURE, PolygonFunction.FEATURE, RegionFunction.FEATURE, RegionFunction.FEATURE_UNION, RegionFunction.FEATURE_INTERSECT};

    public FeatureSet() {
        this(true);
    }

    public FeatureSet(boolean allSupported) {
        if (allSupported) {
            this.supportAll();
        }
    }

    public boolean support(LanguageFeature feature) {
        if (feature == null || feature.type == null || !feature.optional) {
            return false;
        }
        Set<LanguageFeature> features = this.supportedFeatures.get(feature.type);
        if (features == null) {
            features = new HashSet<LanguageFeature>();
            this.supportedFeatures.put(feature.type, features);
        }
        features.add(feature);
        return true;
    }

    public final boolean supportAll(String type) {
        boolean done = false;
        if (type != null) {
            for (LanguageFeature feature : availableFeatures) {
                if (!type.equals(feature.type)) continue;
                done = this.support(feature) || done;
            }
        }
        return done;
    }

    public final void supportAll() {
        for (LanguageFeature feature : availableFeatures) {
            this.support(feature);
        }
    }

    public boolean unsupport(LanguageFeature feature) {
        if (feature == null || feature.type == null || !feature.optional) {
            return false;
        }
        Set<LanguageFeature> features = this.supportedFeatures.get(feature.type);
        if (features == null) {
            return true;
        }
        boolean done = features.remove(feature);
        if (features.isEmpty()) {
            this.supportedFeatures.remove(feature.type);
        }
        return done;
    }

    public final boolean unsupportAll(String type) {
        boolean done = false;
        if (type != null) {
            for (LanguageFeature feature : availableFeatures) {
                if (!type.equals(feature.type)) continue;
                done = this.unsupport(feature) || done;
            }
        }
        return done;
    }

    public final void unsupportAll() {
        for (LanguageFeature feature : this) {
            this.unsupport(feature);
        }
    }

    public boolean isSupporting(LanguageFeature feature) {
        if (feature == null || feature.type == null || !feature.optional) {
            return false;
        }
        Set<LanguageFeature> features = this.supportedFeatures.get(feature.type);
        return features != null && features.contains(feature);
    }

    public Iterator<LanguageFeature> getSupportedFeatures() {
        HashSet allSupportedFeatures = new HashSet(availableFeatures.length);
        for (String type : this.supportedFeatures.keySet()) {
            allSupportedFeatures.addAll(this.supportedFeatures.get(type));
        }
        return allSupportedFeatures.iterator();
    }

    public Iterator<LanguageFeature> getUnsupportedFeatures() {
        HashSet<LanguageFeature> allUnsupportedFeatures = new HashSet<LanguageFeature>(availableFeatures.length);
        for (LanguageFeature feature : availableFeatures) {
            if (this.isSupporting(feature)) continue;
            allUnsupportedFeatures.add(feature);
        }
        return allUnsupportedFeatures.iterator();
    }

    public Iterator<LanguageFeature> getSupportedFeatures(String type) {
        Set<LanguageFeature> features;
        Set<LanguageFeature> set = features = type == null ? null : this.supportedFeatures.get(type);
        if (features != null) {
            return features.iterator();
        }
        return new Iterator<LanguageFeature>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public LanguageFeature next() {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public final Iterator<LanguageFeature> iterator() {
        return this.getSupportedFeatures();
    }

    public final Collection<FunctionDef> getSupportedUDFList() {
        Set<LanguageFeature> supportedUDFs = this.supportedFeatures.get("ivo://ivoa.net/std/TAPRegExt#features-udf");
        if (supportedUDFs != null) {
            ArrayList<FunctionDef> definitions = new ArrayList<FunctionDef>(supportedUDFs.size());
            for (LanguageFeature feature : supportedUDFs) {
                definitions.add(feature.udfDefinition);
            }
            return definitions;
        }
        return new HashSet<FunctionDef>(0);
    }

    public static Iterator<LanguageFeature> getAvailableFeatures() {
        return new Iterator<LanguageFeature>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index + 1 < availableFeatures.length;
            }

            @Override
            public LanguageFeature next() {
                return availableFeatures[++this.index];
            }
        };
    }
}

