# 2021-01-26 Triage Log

This week continues a trend of relatively large rollups, which often contain
perf-sensitive PRs. We need to get better at marking PRs as rollup=never or
otherwise not including them, but it is unclear how precisely to go about doing
so. The tooling for testing individual PRs merged in rollups should also be
improved to work better in the next few days, though.

Other than that, this week saw several regressions, most of which were not
easily explained. We are seeking feedback from PR authors and reviewers on
whether the results are expected and if anything can be done.

Triage done by **@rylevick** and **@simulacrum**.
Revision range: [e05409a02c6e73a3dea6da98798468db2910ca59..1483e67addd37d9bd20ba3b4613b678ee9ad4d68](https://perf.rust-lang.org/?start=e05409a02c6e73a3dea6da98798468db2910ca59&end=1483e67addd37d9bd20ba3b4613b678ee9ad4d68&absolute=false&stat=instructions%3Au)

5 Regressions, 2 Improvements, 1 Mixed;
3 of them in rollups

#### Regressions

Deprecate-in-future the constants superceded by RFC 2700 [#80958](https://github.com/rust-lang/rust/issues/80958)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=57a71ac0e17e4f7070b090ab7bdc5474d8e37ecc&end=339e19697a39a78f4d669c217b7d21109215de41&stat=instructions:u) (up to 2.4% on `incr-patched: Job` builds of `regex-check`)
- Unsure why this might be causing performance regressions as this change does not touch much code and only produces lint warnings when the user opts into them.
- The author of the PR [was asked why this might be the case](https://github.com/rust-lang/rust/pull/80958#issuecomment-767837811), and a nag noted.

Rollup of 11 pull requests [#81240](https://github.com/rust-lang/rust/issues/81240)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=339e19697a39a78f4d669c217b7d21109215de41&end=a243ad280a4ac57c1b8427e30e31c5b505cf10de&stat=instructions:u) (up to 2.0% on `full` builds of `keccak-check`)
- Revert kicked off [here](https://github.com/rust-lang/rust/pull/81420) to test a possible culprit in [#81178](https://github.com/rust-lang/rust/pull/81178).

Generate metadata by iterating on DefId instead of traversing the HIR tree 1/N [#80919](https://github.com/rust-lang/rust/issues/80919)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=446cbc9db080c63c8742c418bcaa44c808f7e033&end=85e355ea9bd86ac6580a5d422a65dbf689845808&stat=instructions:u) (up to 1.0% on `incr-patched: println` builds of `style-servo-check`)
- Contact the PR author to see why the perf regressions were not discussed in the initial PR (even though perf runs were done). Waiting on [their response](https://github.com/rust-lang/rust/pull/80919#issuecomment-767854932).

Rollup of 14 pull requests [#81355](https://github.com/rust-lang/rust/issues/81355)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1d0d76f8dd4f5f6ecbeab575b87edaf1c9f56bb8&end=d3163e96553ae8cb1fca0e62084b124e8b98310b&stat=instructions:u) (up to 12.6% on `full` builds of `deeply-nested-async-debug`)

Prevent query cycles in the MIR inliner [#68828](https://github.com/rust-lang/rust/issues/68828)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7fba12bb1d3877870758a7a53e2fe766bb19bd60&end=f4eb5d9f719cd3c849befc8914ad8ce0ddcf34ed&stat=instructions:u) (up to 2.1% on `full` builds of `keccak-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7fba12bb1d3877870758a7a53e2fe766bb19bd60&end=f4eb5d9f719cd3c849befc8914ad8ce0ddcf34ed&stat=instructions:u) (up to -1.8% on `full` builds of `ctfe-stress-4-check`)
- Nag filed

#### Improvements

Visit only terminators when removing unneeded drops [#81122](https://github.com/rust-lang/rust/issues/81122)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a243ad280a4ac57c1b8427e30e31c5b505cf10de&end=65767e56537e20903b54ecde7c371cbfb1b201b0&stat=instructions:u) (up to -2.0% on `full` builds of `keccak-check`)

Rollup of 15 pull requests [#81304](https://github.com/rust-lang/rust/issues/81304)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4d0dd02ee07bddad9136f95c9f7846ebf3eb3fc5&end=1279b3b9232e4c44112d98f19cfa8846776d1fe8&stat=instructions:u) (up to -1.1% on `incr-unchanged` builds of `helloworld-opt`)

#### Mixed

mark raw_vec::ptr with inline [#79113](https://github.com/rust-lang/rust/issues/79113)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f4eb5d9f719cd3c849befc8914ad8ce0ddcf34ed&end=ff6ee2a70218543f410e557f390e246131847572&stat=instructions:u) (up to 4.2% on `full` builds of `cranelift-codegen-opt`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f4eb5d9f719cd3c849befc8914ad8ce0ddcf34ed&end=ff6ee2a70218543f410e557f390e246131847572&stat=instructions:u) (up to -1.5% on `incr-patched: println` builds of `cargo-opt`)

#### Nags requiring follow up

- Deprecate in future regression [#80958](https://github.com/rust-lang/rust/pull/80958#issuecomment-767837811)
- Waiting on [response](https://github.com/rust-lang/rust/pull/80919#issuecomment-767854932) to inquiry.
- Regression in prevent query cycles in the MIR inliner - expected? [#68828](https://github.com/rust-lang/rust/pull/68828#issuecomment-767872361)
