# 2024-10-01 Triage Log

A quiet week without too many perf. changes, although there was a nice perf. win on documentation
builds thanks to [#130857](https://github.com/rust-lang/rust/pull/130857). Overall the results were positive.

Triage done by **@kobzol**.
Revision range: [4cadeda9..c87004a1](https://perf.rust-lang.org/?start=4cadeda932d5c261a9a0b1bbd25c4486e4e0a4c6&end=c87004a1f5be671e3f03f69fb13d8915bdbb6a52&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.8%]    | 11    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.6%]    | 19    |
| Improvements ✅ <br /> (primary)   | -1.2% | [-14.9%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.3%, -0.3%]  | 5     |
| All ❌✅ (primary)                 | -0.6% | [-14.9%, 0.8%]  | 32    |


3 Regressions, 4 Improvements, 3 Mixed; 2 of them in rollups
47 artifact comparisons made in total

#### Regressions

Add `optimize_for_size` variants for stable and unstable sort as well as select_nth_unstable [#129587](https://github.com/rust-lang/rust/pull/129587) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67bb749c2e1cf503fee64842963dd3e72a417a3f&end=363ae4188316b8b22cf6c1890bc73d84d05f70a4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 3     |

- This PR improved the binary size of stdlib's sorting algorithms when compiled with the `optimize_for_size`
cfg option.
- It caused some small codegen perturbations, but it does not seem to warrant further changes.
- Marked as triaged.

Rollup of 6 pull requests [#130847](https://github.com/rust-lang/rust/pull/130847) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b5117538e934f81e39eb9c326fdcc6574d144cb7&end=0399709cdc3c5cc22327e9f657dc7956546a0457&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.3%, 0.9%] | 9     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.3%, 1.8%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.3%, 0.9%] | 9     |

- Regression comes from [#130735](https://github.com/rust-lang/rust/pull/130735), which implements
a new form of MIR validation.
- Marked as triaged.

bump few deps [#130874](https://github.com/rust-lang/rust/pull/130874) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b6576e3f63916034810d24172c35a5ac1c0ef704&end=851f698682aa2e4c226e1a2c1af30adbcb63aae2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.4% | [3.4%, 3.4%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 3.4% | [3.4%, 3.4%] | 1     |

- Noise, marked as triaged.

#### Improvements

Run `cargo update` in the project root [#129624](https://github.com/rust-lang/rust/pull/129624) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4428a051679ec6194a118424f4616d922249a1e6&end=2bd1e894efde3b6be857ad345914a3b1cea51def&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.2%, -0.1%] | 14    |
| Improvements ✅ <br /> (secondary) | -1.0% | [-2.5%, -0.2%] | 7     |
| All ❌✅ (primary)                 | -0.5% | [-1.2%, -0.1%] | 14    |


rustdoc perf: clone `clean::Item` less [#130857](https://github.com/rust-lang/rust/pull/130857) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b9dc4a30e116c6bd1b873fa79379ea70e102c47b&end=a3f76a26e045a760bb1163b7eab36872985242d5&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -9.3% | [-15.5%, -3.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -               | 0     |
| All ❌✅ (primary)                 | -9.3% | [-15.5%, -3.1%] | 2     |


library: Compute `RUST_EXCEPTION_CLASS` from native-endian bytes [#130897](https://github.com/rust-lang/rust/pull/130897) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=851f698682aa2e4c226e1a2c1af30adbcb63aae2&end=150247c338a54cb3d08614d8530d1bb491fa90db&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -3.3% | [-3.3%, -3.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -3.3% | [-3.3%, -3.3%] | 1     |


Improve autovectorization of to_lowercase / to_uppercase functions [#123778](https://github.com/rust-lang/rust/pull/123778) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ed04567ba1d5956d1080fb8121caa005ce059e12&end=55cb7359c7a43fb084d4717088e4f6ad7d7964f4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-2.2%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 21    |


#### Mixed

Revert "Apply EarlyOtherwiseBranch to scalar value #129047" [#130775](https://github.com/rust-lang/rust/pull/130775) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4cbfcf1b7f16245176488e581f57b39a7e32bc31&end=67bb749c2e1cf503fee64842963dd3e72a417a3f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-1.1%, 0.6%]  | 2     |

- Revert of a PR because of correctness issues.

Rollup of 7 pull requests [#130807](https://github.com/rust-lang/rust/pull/130807) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3f99982c633dbca746140db60ed52ba7fa112803&end=1b5aa96d6016bafe50e071b45d4d2e3c90fd766f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.7%]   | 5     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-2.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | 0.2%  | [-0.4%, 0.7%]  | 6     |

- The doc build regressions were fixed (and in fact much improved) in [#130857](https://github.com/rust-lang/rust/pull/130857).
- Marked as triaged.

properly elaborate effects implied bounds for super traits [#129499](https://github.com/rust-lang/rust/pull/129499) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0d6e13019609d8fa27cb4fafa7878c9e09279e14&end=4e91cedaedba39d06748c5873347f1a7341937ae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-2.0%, -2.0%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.3%, 0.3%]   | 4     |

- Small genuine regression caused by a change in trait elaboration.
- Marked as triaged.
