Inline assembly (`asm!`) is not supported on this target.

Example of erroneous code:

```ignore (cannot-change-target)
// compile-flags: --target sparc64-unknown-linux-gnu
#![no_std]

use core::arch::asm;

fn main() {
    unsafe {
        asm!(""); // error: inline assembly is not supported on this target
    }
}
```

The Rust compiler does not support inline assembly, with the `asm!` macro
(previously `llvm_asm!`), for all targets. All Tier 1 targets do support this
macro but support among Tier 2 and 3 targets is not guaranteed (even when they
have `std` support). Note that this error is related to
`error[E0658]: inline assembly is not stable yet on this architecture`, but
distinct in that with `E0472` support is not planned or in progress.

There is no way to easily fix this issue, however:
 * Consider if you really need inline assembly, is there some other way to
   achieve your goal (intrinsics, etc)?
 * Consider writing your assembly externally, linking with it and calling it
   from Rust.
 * Consider contributing to <https://github.com/rust-lang/rust> and help
   integrate support for your target!
