### New features

* [#3666](https://github.com/rubocop/rubocop/issues/3666): Add new `Naming/UncommunicativeBlockParamName` cop. ([@garettarrowood][])
* [#3666](https://github.com/rubocop/rubocop/issues/3666): Add new `Naming/UncommunicativeMethodParamName` cop. ([@garettarrowood][])
* [#5356](https://github.com/rubocop/rubocop/issues/5356): Add new `Lint/UnneededCopEnableDirective` cop. ([@garettarrowood][])
* [#5248](https://github.com/rubocop/rubocop/pull/5248): Add new `Lint/BigDecimalNew` cop. ([@koic][])
* Add new `Style/TrailingBodyOnClass` cop. ([@garettarrowood][])
* Add new `Style/TrailingBodyOnModule` cop. ([@garettarrowood][])
* [#3394](https://github.com/rubocop/rubocop/issues/3394): Add new `Style/TrailingCommaInArrayLiteral` cop. ([@garettarrowood][])
* [#3394](https://github.com/rubocop/rubocop/issues/3394): Add new `Style/TrailingCommaInHashLiteral` cop. ([@garettarrowood][])
* [#5319](https://github.com/rubocop/rubocop/pull/5319): Add new `Security/Open` cop. ([@mame][])
* Add `EnforcedStyleForEmptyBrackets` configuration to `Layout/SpaceInsideReferenceBrackets`. ([@garettarrowood][])
* [#5050](https://github.com/rubocop/rubocop/issues/5050): Add auto-correction to `Style/ModuleFunction`. ([@garettarrowood][])
* [#5358](https://github.com/rubocop/rubocop/pull/5358):  `--no-auto-gen-timestamp` CLI option suppresses the inclusion of the date and time it was generated in auto-generated config. ([@dominicsayers][])
* [#4274](https://github.com/rubocop/rubocop/issues/4274): Add new `Layout/EmptyComment` cop. ([@koic][])
* [#4477](https://github.com/rubocop/rubocop/issues/4477): Add new configuration directive: `inherit_mode` for merging arrays. ([@leklund][])
* [#5532](https://github.com/rubocop/rubocop/pull/5532): Include `.axlsx` file by default. ([@georf][])
* [#5490](https://github.com/rubocop/rubocop/issues/5490): Add new `Lint/OrderedMagicComments` cop. ([@koic][])
* [#4008](https://github.com/rubocop/rubocop/issues/4008): Add new `Style/ExpandPathArguments` cop. ([@koic][])
* [#4812](https://github.com/rubocop/rubocop/issues/4812): Add `beginning_only` and `ending_only` style options to `Layout/EmptyLinesAroundClassBody` cop. ([@jmks][])
* [#5591](https://github.com/rubocop/rubocop/pull/5591): Include `.arb` file by default. ([@deivid-rodriguez][])
* [#5473](https://github.com/rubocop/rubocop/issues/5473): Use `gems.locked` or `Gemfile.lock` to determine the best `TargetRailsVersion` when it is not specified in the config. ([@roberts1000][])
* Add new `Naming/MemoizedInstanceVariableName` cop. ([@satyap][])
* [#5376](https://github.com/rubocop/rubocop/issues/5376): Add new `Style/EmptyLineAfterGuardClause` cop. ([@unkmas][])
* Add new `Rails/ActiveRecordAliases` cop. ([@elebow][])

### Bug fixes

* [#4105](https://github.com/rubocop/rubocop/issues/4105): Fix `Lint/IndentationWidth` when `Lint/EndAlignment` is configured with `start_of_line`. ([@brandonweiss][])
* [#5453](https://github.com/rubocop/rubocop/issues/5453): Fix erroneous downcase in `Performance/Casecmp` auto-correction. ([@walinga][])
* [#5343](https://github.com/rubocop/rubocop/issues/5343): Fix offense detection in `Style/TrailingMethodEndStatement`. ([@garettarrowood][])
* [#5334](https://github.com/rubocop/rubocop/issues/5334): Fix semicolon removal for `Style/TrailingBodyOnMethodDefinition` autocorrection. ([@garettarrowood][])
* [#5350](https://github.com/rubocop/rubocop/issues/5350): Fix `Metric/LineLength` false offenses for URLs in double quotes. ([@garettarrowood][])
* [#5333](https://github.com/rubocop/rubocop/issues/5333): Fix `Layout/EmptyLinesAroundArguments` false positives for inline access modifiers. ([@garettarrowood][])
* [#5339](https://github.com/rubocop/rubocop/issues/5339): Fix `Layout/EmptyLinesAroundArguments` false positives for multiline heredoc arguments. ([@garettarrowood][])
* [#5383](https://github.com/rubocop/rubocop/issues/5383): Fix `Rails/Presence` false detection of receiver for locally defined `blank?` & `present?` methods. ([@garettarrowood][])
* [#5314](https://github.com/rubocop/rubocop/issues/5314): Fix false positives for `Lint/NestedPercentLiteral` when percent characters are nested. ([@asherkach][])
* [#5357](https://github.com/rubocop/rubocop/issues/5357): Fix `Lint/InterpolationCheck` false positives on escaped interpolations. ([@pocke][])
* [#5409](https://github.com/rubocop/rubocop/issues/5409): Fix multiline indent for `Style/SymbolArray` and `Style/WordArray` autocorrect. ([@flyerhzm][])
* [#5393](https://github.com/rubocop/rubocop/issues/5393): Fix `Rails/Delegate`'s false positive with a method call with arguments. ([@pocke][])
* [#5348](https://github.com/rubocop/rubocop/issues/5348): Fix false positive for `Style/SafeNavigation` when safe guarding more comparison methods. ([@rrosenblum][])
* [#4889](https://github.com/rubocop/rubocop/issues/4889): Auto-correcting `Style/SafeNavigation` will add safe navigation to all methods in a method chain. ([@rrosenblum][])
* [#5287](https://github.com/rubocop/rubocop/issues/5287): Do not register an offense in `Style/SafeNavigation` if there is an unsafe method used in a method chain. ([@rrosenblum][])
* [#5401](https://github.com/rubocop/rubocop/issues/5401): Fix `Style/RedundantReturn` to trigger when begin-end, rescue, and ensure blocks present. ([@asherkach][])
* [#5426](https://github.com/rubocop/rubocop/issues/5426): Make `Rails/InverseOf` accept `inverse_of: nil` to opt-out. ([@wata727][])
* [#5448](https://github.com/rubocop/rubocop/issues/5448): Improve `Rails/LexicallyScopedActionFilter`. ([@wata727][])
* [#3947](https://github.com/rubocop/rubocop/issues/3947): Fix false positive for `Rails/FilePath` when using `Rails.root.join` in string interpolation of argument. ([@koic][])
* [#5479](https://github.com/rubocop/rubocop/issues/5479): Fix false positives for `Rails/Presence` when using with `elsif`. ([@wata727][])
* [#5427](https://github.com/rubocop/rubocop/pull/5427): Fix exception when executing from a different drive on Windows. ([@orgads][])
* [#5429](https://github.com/rubocop/rubocop/issues/5429): Detect tabs other than indentation by `Layout/Tab`. ([@pocke][])
* [#5496](https://github.com/rubocop/rubocop/pull/5496): Fix a false positive of `Style/FormatStringToken` with unrelated `format` call. ([@pocke][])
* [#5503](https://github.com/rubocop/rubocop/issues/5503): Fix `Rails/CreateTableWithTimestamps` false positive when using `to_proc` syntax. ([@wata727][])
* [#5512](https://github.com/rubocop/rubocop/issues/5512): Improve `Lint/Void` to detect `Kernel#tap` as method that ignores the block's value. ([@untitaker][])
* [#5520](https://github.com/rubocop/rubocop/issues/5520): Fix `Style/RedundantException` auto-correction does not keep parenthesization. ([@dpostorivo][])
* [#5524](https://github.com/rubocop/rubocop/issues/5524): Return the instance based on the new type when calls `RuboCop::AST::Node#updated`. ([@wata727][])
* [#5527](https://github.com/rubocop/rubocop/issues/5527): Avoid behavior-changing corrections in `Style/SafeNavigation`. ([@jonas054][])
* [#5539](https://github.com/rubocop/rubocop/pull/5539): Fix compilation error and ruby code generation when passing args to funcall and predicates. ([@Edouard-chin][])
* [#4669](https://github.com/rubocop/rubocop/issues/4669): Use binary file contents for cache key so changing EOL characters invalidates the cache. ([@jonas054][])
* [#3947](https://github.com/rubocop/rubocop/issues/3947): Fix false positive for `Performance::RegexpMatch` when using `MatchData` before guard clause. ([@koic][])
* [#5515](https://github.com/rubocop/rubocop/issues/5515): Fix `Style/EmptyElse` autocorrect for nested if and case statements. ([@asherkach][])
* [#5582](https://github.com/rubocop/rubocop/issues/5582): Fix `end` alignment for variable assignment with line break after `=` in `Layout/EndAlignment`. ([@jonas054][])
* [#5602](https://github.com/rubocop/rubocop/pull/5602): Fix false positive for `Style/ColonMethodCall` when using Java package namespace. ([@koic][])
* [#5603](https://github.com/rubocop/rubocop/pull/5603): Fix falsey offense for `Style/RedundantSelf` with pseudo variables. ([@pocke][])
* [#5547](https://github.com/rubocop/rubocop/issues/5547): Fix auto-correction of `Layout/BlockEndNewline` when there is top level code outside of a class. ([@rrosenblum][])
* [#5599](https://github.com/rubocop/rubocop/issues/5599): Fix the suggestion being used by `Lint/NumberConversion` to use base 10 with Integer. ([@rrosenblum][])
* [#5534](https://github.com/rubocop/rubocop/issues/5534): Fix `Style/EachWithObject` auto-correction leaves an empty line. ([@flyerhzm][])

### Changes

* [#5589](https://github.com/rubocop/rubocop/issues/5589): Remove `Performance/HashEachMethods` cop as it no longer provides a performance benefit. ([@urbanautomaton][])
* [#3394](https://github.com/rubocop/rubocop/issues/3394): Remove `Style/TrailingCommaInLiteral` in favor of two new cops. ([@garettarrowood][])
* Rename `Lint/UnneededDisable` to `Lint/UnneededCopDisableDirective`. ([@garettarrowood][])
* [#5365](https://github.com/rubocop/rubocop/pull/5365): Add `*.gemfile` to Bundler cop target. ([@sue445][])
* [#4477](https://github.com/rubocop/rubocop/issues/4477): Warn when user configuration overrides other user configuration. ([@jonas054][])
* [#5240](https://github.com/rubocop/rubocop/pull/5240): Make `Style/StringHashKeys` to accepts environment variables. ([@pocke][])
* [#5395](https://github.com/rubocop/rubocop/pull/5395): Always exit 2 when specified configuration file does not exist. ([@pocke][])
* [#5402](https://github.com/rubocop/rubocop/pull/5402): Remove undefined `ActiveSupport::TimeZone#strftime` method from defined dangerous methods of `Rails/TimeZone` cop. ([@koic][])
* [#4704](https://github.com/rubocop/rubocop/issues/4704): Move `Lint/EndAlignment`, `Lint/DefEndAlignment`, `Lint/BlockAlignment`, and `Lint/ConditionPosition` to the `Layout` namespace. ([@bquorning][])
* [#5283](https://github.com/rubocop/rubocop/issues/5283): Change file path output by `Formatter::JSONFormatter` from relative path to smart path. ([@koic][])
* `Style/SafeNavigation` will now register an offense for methods that `nil` responds to. ([@rrosenblum][])
* [#5542](https://github.com/rubocop/rubocop/pull/5542): Exclude `.git/` by default. ([@pocke][])
* Tell Read the Docs to build downloadable docs. ([@eostrom][])
* Change `Style/SafeNavigation` to no longer register an offense for method chains exceeding 2 methods. ([@rrosenblum][])
* Remove auto-correction from `Lint/SafeNavigationChain`. ([@rrosenblum][])
* Change the highlighting of `Lint/SafeNavigationChain` to highlight the entire method chain beyond the safe navigation portion. ([@rrosenblum][])

[@garettarrowood]: https://github.com/garettarrowood
[@koic]: https://github.com/koic
[@mame]: https://github.com/mame
[@dominicsayers]: https://github.com/dominicsayers
[@leklund]: https://github.com/leklund
[@georf]: https://github.com/georf
[@jmks]: https://github.com/jmks
[@deivid-rodriguez]: https://github.com/deivid-rodriguez
[@roberts1000]: https://github.com/roberts1000
[@satyap]: https://github.com/satyap
[@unkmas]: https://github.com/unkmas
[@elebow]: https://github.com/elebow
[@brandonweiss]: https://github.com/brandonweiss
[@walinga]: https://github.com/walinga
[@asherkach]: https://github.com/asherkach
[@pocke]: https://github.com/pocke
[@flyerhzm]: https://github.com/flyerhzm
[@rrosenblum]: https://github.com/rrosenblum
[@wata727]: https://github.com/wata727
[@orgads]: https://github.com/orgads
[@untitaker]: https://github.com/untitaker
[@dpostorivo]: https://github.com/dpostorivo
[@jonas054]: https://github.com/jonas054
[@Edouard-chin]: https://github.com/Edouard-chin
[@urbanautomaton]: https://github.com/urbanautomaton
[@sue445]: https://github.com/sue445
[@bquorning]: https://github.com/bquorning
[@eostrom]: https://github.com/eostrom
