/*
 * Copyright © 2014 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including
 * the next paragraph) shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "libhsakmt.h"
#include "pmc_table.h"

/****** CB ******/
static uint32_t gfx7_cb_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225
};

static uint32_t gfx8_cb_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395
};

static uint32_t gfx9_cb_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436,
437
};

static uint32_t gfx10_cb_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436,
437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452,
453, 454, 455, 456, 457, 458, 459, 460
};

/****** CPF ******/
static uint32_t gfx7_cpf_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16
};

static uint32_t gfx8_cpf_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19
};

static uint32_t gfx9_cpf_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
};

static uint32_t gfx10_cpf_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39
};

/****** CPG ******/
static uint32_t gfx7_cpg_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45
};

static uint32_t gfx8_cpg_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48
};

static uint32_t gfx9_cpg_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58
};

static uint32_t gfx10_cpg_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81
};

/****** DB ******/
static uint32_t gfx7_db_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256
};
/* gfx8_db_counter_ids are the same as gfx7_db_counter_ids */

static uint32_t gfx9_db_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327
};

static uint32_t gfx10_db_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369
};

/****** GDS ******/
static uint32_t gfx7_gds_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120
};
/* gfx8_gds_counter_ids are the same as gfx7_gds_counter_ids */
/* gfx9_gds_counter_ids are the same as gfx7_gds_counter_ids */

static uint32_t gfx10_gds_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122
};

/****** GRBM ******/
static uint32_t gfx7_grbm_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33
};
/* gfx8_grbm_counter_ids are the same as gfx7_grbm_counter_ids */

static uint32_t gfx9_grbm_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37
};

static uint32_t gfx10_grbm_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46
};

/****** GRBMSE ******/
static uint32_t gfx7_grbmse_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14
};
/* gfx8_grbmse_counter_ids are the same as gfx7_grbmse_counter_ids */

static uint32_t gfx9_grbmse_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15
};

static uint32_t gfx10_grbmse_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18
};

/****** IA ******/
static uint32_t gfx7_ia_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17
};

static uint32_t gfx8_ia_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23
};

static uint32_t gfx9_ia_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31
};
/* gfx10 doesn't have IA */

/****** PASC ******/
static uint32_t gfx7_pasc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394
};

static uint32_t gfx8_pasc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395, 396
};

static uint32_t gfx9_pasc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436,
437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452,
453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484,
485, 486, 487, 488, 489, 490
};

static uint32_t gfx10_pasc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436,
437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452,
453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484,
485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500,
501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516,
517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532,
533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548,
549, 550, 551
};

/****** PASU ******/
static uint32_t gfx7_pasu_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152
};
/* gfx8_pasu_counter_ids are the same as gfx7_pasu_counter_ids */

static uint32_t gfx9_pasu_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291
};

static uint32_t gfx10_pasu_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265
};

/****** SPI ******/
static uint32_t gfx7_spi_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185
};

static uint32_t gfx8_spi_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196
};

static uint32_t gfx9_spi_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195
};

static uint32_t gfx10_spi_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328
};

/****** SQ ******/
/* Unused counters - 163-167 */
static uint32_t gfx7_sq_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 168, 169,
170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185,
186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217,
218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233,
234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
250
};

/* Unused counters - 166, 292 - 297 */
static uint32_t gfx8_sq_counter_ids[] = {
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133,
134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165,
167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182,
183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198,
199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214,
215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230,
231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246,
247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262,
263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278,
279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 298
};

/* Polaris 10/11/12 have the same SQ cpunter IDs but different from other gfx8's. */
/* Unused counters - 167 and 275 are *_DUMMY_LAST */
static uint32_t gfx8_pl_sq_counter_ids[] = {
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
158, 159, 160, 161, 162, 163, 164, 165, 168, 169, 170, 171, 172, 173, 174,
175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234,
235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264,
265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 276, 277, 278, 279, 280,
281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295
};

static uint32_t gfx9_sq_counter_ids[] = {
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172,
173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 255, 256, 257, 258,
259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303,
304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318,
319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348,
349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363,
364, 365, 366, 367, 368, 369, 370, 371, 372
};

static uint32_t gfx10_sq_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292,
293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308,
309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340,
341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356,
357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372,
373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388,
389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404,
405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420,
421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436,
437, 438, 439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452,
453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484,
485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500,
501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511
};

/****** SRBM ******/
static uint32_t gfx7_srbm_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18
};

static uint32_t gfx8_srbm_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27
};
/* gfx9 doesn't have SRBM */
/* gfx10 doesn't have SRBM */

/****** SX ******/
static uint32_t gfx7_sx_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33
};
/* gfx8_sx_counter_ids are the same as gfx7_sx_counter_ids */

static uint32_t gfx9_sx_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207
};

static uint32_t gfx10_sx_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224
};

/****** TA ******/
static uint32_t gfx7_ta_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110
};

static uint32_t gfx8_ta_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118
};
/* gfx9_ta_counter_ids is same as gfx8_ta_counter_ids */

static uint32_t gfx10_ta_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225
};

/****** TCA ******/
static uint32_t gfx7_tca_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38
};

static uint32_t gfx8_tca_counter_ids[] = {
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34
};
/* gfx9_tca_counter_ids is same as gfx8_tca_counter_ids */
/* gfx10 doesn't have TCA */

/****** TCC ******/
static uint32_t gfx7_tcc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 159
};

static uint32_t gfx8_tcc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 128, 129, 130, 131, 132, 133, 134, 135, 136,
137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152,
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168,
169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184,
185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232,
233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248,
249, 250, 251, 252, 253, 254, 255
};

static uint32_t gfx8_cz_tcc_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 128, 129, 130, 131, 132, 133, 134, 135, 136,
137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152,
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168,
169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184,
185, 186, 187, 188, 189, 190, 191
};
/* gfx9_tcc_counter_ids is same as gfx8_tcc_counter_ids */
/* gfx10 doesn't have TCC */

/****** TCP ******/
static uint32_t gfx7_tcp_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153
};

static uint32_t gfx8_tcp_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148,
149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180,
181, 182
};

static uint32_t gfx9_tcp_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84
};

static uint32_t gfx10_tcp_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76
};

/****** TCS ******/
static uint32_t gfx7_tcs_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 64,
65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103,
104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
120, 121, 122, 123, 124, 125, 126, 127
};
/* gfx8 doesn't have TCS */
/* gfx9 doesn't have TCS */
/* gfx10 doesn't have TCS */

/****** TD ******/
static uint32_t gfx7_td_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54
};
/* gfx8_td_counter_ids are the same as gfx7_td_counter_ids */

static uint32_t gfx9_td_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56
};

static uint32_t gfx10_td_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60
};

/****** VGT ******/
static uint32_t gfx7_vgt_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139
};

static uint32_t gfx8_vgt_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145
};

static uint32_t gfx8_pl_vgt_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146
};

static uint32_t gfx9_vgt_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147
};
/* gfx10 doesn't have VGT */

/****** WD ******/
static uint32_t gfx7_wd_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9
};

static uint32_t gfx8_wd_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36
};

static uint32_t gfx9_wd_counter_ids[] = {
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57
};
/* gfx10 doesn't have WD */

static struct perf_counter_block kaveri_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 8,
		.num_of_counters = sizeof(gfx7_sq_counter_ids) /
					sizeof(*gfx7_sq_counter_ids),
		.counter_ids = gfx7_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

static struct perf_counter_block hawaii_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__CB] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx7_cb_counter_ids) /
					sizeof(*gfx7_cb_counter_ids),
		.counter_ids = gfx7_cb_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPF] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx7_cpf_counter_ids) /
					sizeof(*gfx7_cpf_counter_ids),
		.counter_ids = gfx7_cpf_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPG] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx7_cpg_counter_ids) /
					sizeof(*gfx7_cpg_counter_ids),
		.counter_ids = gfx7_cpg_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__DB] = {
		.num_of_slots = 12,
		.num_of_counters = sizeof(gfx7_db_counter_ids) /
					sizeof(*gfx7_db_counter_ids),
		.counter_ids = gfx7_db_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GDS] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_gds_counter_ids) /
					sizeof(*gfx7_gds_counter_ids),
		.counter_ids = gfx7_gds_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx7_grbm_counter_ids) /
					sizeof(*gfx7_grbm_counter_ids),
		.counter_ids = gfx7_grbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBMSE] = {
		.num_of_slots = 1,
		.num_of_counters = sizeof(gfx7_grbmse_counter_ids) /
					sizeof(*gfx7_grbmse_counter_ids),
		.counter_ids = gfx7_grbmse_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__IA] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx7_ia_counter_ids) /
					sizeof(*gfx7_ia_counter_ids),
		.counter_ids = gfx7_ia_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASC] = {
		.num_of_slots = 11,
		.num_of_counters = sizeof(gfx7_pasc_counter_ids) /
					sizeof(*gfx7_pasc_counter_ids),
		.counter_ids = gfx7_pasc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASU] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_pasu_counter_ids) /
					sizeof(*gfx7_pasu_counter_ids),
		.counter_ids = gfx7_pasu_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SPI] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_spi_counter_ids) /
					sizeof(*gfx7_spi_counter_ids),
		.counter_ids = gfx7_spi_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx7_srbm_counter_ids) /
					sizeof(*gfx7_srbm_counter_ids),
		.counter_ids = gfx7_srbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 8,
		.num_of_counters = sizeof(gfx7_sq_counter_ids) /
					sizeof(*gfx7_sq_counter_ids),
		.counter_ids = gfx7_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SX] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_sx_counter_ids) /
					sizeof(*gfx7_sx_counter_ids),
		.counter_ids = gfx7_sx_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TA] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx7_ta_counter_ids) /
					sizeof(*gfx7_ta_counter_ids),
		.counter_ids = gfx7_ta_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCA] = {
		.num_of_slots = 10, /* same as CZ */
		.num_of_counters = sizeof(gfx7_tca_counter_ids) /
					sizeof(*gfx7_tca_counter_ids),
		.counter_ids = gfx7_tca_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCC] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_tcc_counter_ids) /
					sizeof(*gfx7_tcc_counter_ids),
		.counter_ids = gfx7_tcc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCP] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_tcp_counter_ids) /
					sizeof(*gfx7_tcp_counter_ids),
		.counter_ids = gfx7_tcp_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCS] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx7_tcs_counter_ids) /
					sizeof(*gfx7_tcs_counter_ids),
		.counter_ids = gfx7_tcs_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TD] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx7_td_counter_ids) /
					sizeof(*gfx7_td_counter_ids),
		.counter_ids = gfx7_td_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__VGT] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_vgt_counter_ids) /
					sizeof(*gfx7_vgt_counter_ids),
		.counter_ids = gfx7_vgt_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__WD] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_wd_counter_ids) /
					sizeof(*gfx7_wd_counter_ids),
		.counter_ids = gfx7_wd_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

static struct perf_counter_block carrizo_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__CB] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx8_cb_counter_ids) /
					sizeof(*gfx8_cb_counter_ids),
		.counter_ids = gfx8_cb_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPF] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx8_cpf_counter_ids) /
					sizeof(*gfx8_cpf_counter_ids),
		.counter_ids = gfx8_cpf_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPG] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx8_cpg_counter_ids) /
					sizeof(*gfx8_cpg_counter_ids),
		.counter_ids = gfx8_cpg_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__DB] = {
		.num_of_slots = 12,
		.num_of_counters = sizeof(gfx7_db_counter_ids) /
					sizeof(*gfx7_db_counter_ids),
		.counter_ids = gfx7_db_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GDS] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_gds_counter_ids) /
					sizeof(*gfx7_gds_counter_ids),
		.counter_ids = gfx7_gds_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx7_grbm_counter_ids) /
					sizeof(*gfx7_grbm_counter_ids),
		.counter_ids = gfx7_grbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBMSE] = {
		.num_of_slots = 1,
		.num_of_counters = sizeof(gfx7_grbmse_counter_ids) /
					sizeof(*gfx7_grbmse_counter_ids),
		.counter_ids = gfx7_grbmse_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__IA] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx8_ia_counter_ids) /
					sizeof(*gfx8_ia_counter_ids),
		.counter_ids = gfx8_ia_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASC] = {
		.num_of_slots = 11,
		.num_of_counters = sizeof(gfx8_pasc_counter_ids) /
					sizeof(*gfx8_pasc_counter_ids),
		.counter_ids = gfx8_pasc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASU] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_pasu_counter_ids) /
					sizeof(*gfx7_pasu_counter_ids),
		.counter_ids = gfx7_pasu_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SPI] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx8_spi_counter_ids) /
					sizeof(*gfx8_spi_counter_ids),
		.counter_ids = gfx8_spi_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx8_srbm_counter_ids) /
					sizeof(*gfx8_srbm_counter_ids),
		.counter_ids = gfx8_srbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 8,
		.num_of_counters = sizeof(gfx8_sq_counter_ids) /
					sizeof(*gfx8_sq_counter_ids),
		.counter_ids = gfx8_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SX] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_sx_counter_ids) /
					sizeof(*gfx7_sx_counter_ids),
		.counter_ids = gfx7_sx_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TA] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx8_ta_counter_ids) /
					sizeof(*gfx8_ta_counter_ids),
		.counter_ids = gfx8_ta_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCA] = {
		/* PMC0: PERF_SEL~PERF_SEL3, PMC1: PERF_SEL~PERF_SEL3,
		 * PMC2: PERF_SEL, PMC3: PERF_SEL. So 10 PERF_SELs in total
		 */
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tca_counter_ids) /
					sizeof(*gfx8_tca_counter_ids),
		.counter_ids = gfx8_tca_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCC] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_cz_tcc_counter_ids) /
					sizeof(*gfx8_cz_tcc_counter_ids),
		.counter_ids = gfx8_cz_tcc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCP] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tcp_counter_ids) /
					sizeof(*gfx8_tcp_counter_ids),
		.counter_ids = gfx8_tcp_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TD] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx7_td_counter_ids) /
					sizeof(*gfx7_td_counter_ids),
		.counter_ids = gfx7_td_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__VGT] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_vgt_counter_ids) /
					sizeof(*gfx8_vgt_counter_ids),
		.counter_ids = gfx8_vgt_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__WD] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx8_wd_counter_ids) /
					sizeof(*gfx8_wd_counter_ids),
		.counter_ids = gfx8_wd_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

static struct perf_counter_block fiji_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__CB] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx8_cb_counter_ids) /
					sizeof(*gfx8_cb_counter_ids),
		.counter_ids = gfx8_cb_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPF] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx8_cpf_counter_ids) /
					sizeof(*gfx8_cpf_counter_ids),
		.counter_ids = gfx8_cpf_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPG] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx8_cpg_counter_ids) /
					sizeof(*gfx8_cpg_counter_ids),
		.counter_ids = gfx8_cpg_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__DB] = {
		.num_of_slots = 12,
		.num_of_counters = sizeof(gfx7_db_counter_ids) /
					sizeof(*gfx7_db_counter_ids),
		.counter_ids = gfx7_db_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GDS] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_gds_counter_ids) /
					sizeof(*gfx7_gds_counter_ids),
		.counter_ids = gfx7_gds_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx7_grbm_counter_ids) /
					sizeof(*gfx7_grbm_counter_ids),
		.counter_ids = gfx7_grbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBMSE] = {
		.num_of_slots = 1,
		.num_of_counters = sizeof(gfx7_grbmse_counter_ids) /
					sizeof(*gfx7_grbmse_counter_ids),
		.counter_ids = gfx7_grbmse_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__IA] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx8_ia_counter_ids) /
					sizeof(*gfx8_ia_counter_ids),
		.counter_ids = gfx8_ia_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASC] = {
		.num_of_slots = 11,
		.num_of_counters = sizeof(gfx8_pasc_counter_ids) /
					sizeof(*gfx8_pasc_counter_ids),
		.counter_ids = gfx8_pasc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASU] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_pasu_counter_ids) /
					sizeof(*gfx7_pasu_counter_ids),
		.counter_ids = gfx7_pasu_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SPI] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx8_spi_counter_ids) /
					sizeof(*gfx8_spi_counter_ids),
		.counter_ids = gfx8_spi_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx8_srbm_counter_ids) /
					sizeof(*gfx8_srbm_counter_ids),
		.counter_ids = gfx8_srbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 8,
		.num_of_counters = sizeof(gfx8_sq_counter_ids) /
					sizeof(*gfx8_sq_counter_ids),
		.counter_ids = gfx8_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SX] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_sx_counter_ids) /
					sizeof(*gfx7_sx_counter_ids),
		.counter_ids = gfx7_sx_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TA] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx8_ta_counter_ids) /
					sizeof(*gfx8_ta_counter_ids),
		.counter_ids = gfx8_ta_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCA] = {
		.num_of_slots = 10, /* same as CZ */
		.num_of_counters = sizeof(gfx8_tca_counter_ids) /
					sizeof(*gfx8_tca_counter_ids),
		.counter_ids = gfx8_tca_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCC] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tcc_counter_ids) /
					sizeof(*gfx8_tcc_counter_ids),
		.counter_ids = gfx8_tcc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCP] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tcp_counter_ids) /
					sizeof(*gfx8_tcp_counter_ids),
		.counter_ids = gfx8_tcp_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TD] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx7_td_counter_ids) /
					sizeof(*gfx7_td_counter_ids),
		.counter_ids = gfx7_td_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__VGT] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_vgt_counter_ids) /
					sizeof(*gfx8_vgt_counter_ids),
		.counter_ids = gfx8_vgt_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__WD] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx8_wd_counter_ids) /
					sizeof(*gfx8_wd_counter_ids),
		.counter_ids = gfx8_wd_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

static struct perf_counter_block polaris_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__CB] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx8_cb_counter_ids) /
					sizeof(*gfx8_cb_counter_ids),
		.counter_ids = gfx8_cb_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPF] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx8_cpf_counter_ids) /
					sizeof(*gfx8_cpf_counter_ids),
		.counter_ids = gfx8_cpf_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPG] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx8_cpg_counter_ids) /
					sizeof(*gfx8_cpg_counter_ids),
		.counter_ids = gfx8_cpg_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__DB] = {
		.num_of_slots = 12,
		.num_of_counters = sizeof(gfx7_db_counter_ids) /
					sizeof(*gfx7_db_counter_ids),
		.counter_ids = gfx7_db_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GDS] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_gds_counter_ids) /
					sizeof(*gfx7_gds_counter_ids),
		.counter_ids = gfx7_gds_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx7_grbm_counter_ids) /
					sizeof(*gfx7_grbm_counter_ids),
		.counter_ids = gfx7_grbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBMSE] = {
		.num_of_slots = 1,
		.num_of_counters = sizeof(gfx7_grbmse_counter_ids) /
					sizeof(*gfx7_grbmse_counter_ids),
		.counter_ids = gfx7_grbmse_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__IA] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx8_ia_counter_ids) /
					sizeof(*gfx8_ia_counter_ids),
		.counter_ids = gfx8_ia_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASC] = {
		.num_of_slots = 11,
		.num_of_counters = sizeof(gfx8_pasc_counter_ids) /
					sizeof(*gfx8_pasc_counter_ids),
		.counter_ids = gfx8_pasc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASU] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx7_pasu_counter_ids) /
					sizeof(*gfx7_pasu_counter_ids),
		.counter_ids = gfx7_pasu_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SPI] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx8_spi_counter_ids) /
					sizeof(*gfx8_spi_counter_ids),
		.counter_ids = gfx8_spi_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 8,
		.num_of_counters = sizeof(gfx8_pl_sq_counter_ids) /
					sizeof(*gfx8_pl_sq_counter_ids),
		.counter_ids = gfx8_pl_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx8_srbm_counter_ids) /
					sizeof(*gfx8_srbm_counter_ids),
		.counter_ids = gfx8_srbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SX] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_sx_counter_ids) /
					sizeof(*gfx7_sx_counter_ids),
		.counter_ids = gfx7_sx_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TA] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx8_ta_counter_ids) /
					sizeof(*gfx8_ta_counter_ids),
		.counter_ids = gfx8_ta_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCA] = {
		.num_of_slots = 10, /* same as CZ */
		.num_of_counters = sizeof(gfx8_tca_counter_ids) /
					sizeof(*gfx8_tca_counter_ids),
		.counter_ids = gfx8_tca_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCC] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tcc_counter_ids) /
					sizeof(*gfx8_tcc_counter_ids),
		.counter_ids = gfx8_tcc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCP] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tcp_counter_ids) /
					sizeof(*gfx8_tcp_counter_ids),
		.counter_ids = gfx8_tcp_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TD] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx7_td_counter_ids) /
					sizeof(*gfx7_td_counter_ids),
		.counter_ids = gfx7_td_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__VGT] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_pl_vgt_counter_ids) /
					sizeof(*gfx8_pl_vgt_counter_ids),
		.counter_ids = gfx8_pl_vgt_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__WD] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx8_wd_counter_ids) /
					sizeof(*gfx8_wd_counter_ids),
		.counter_ids = gfx8_wd_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

static struct perf_counter_block vega_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__CB] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx9_cb_counter_ids) /
					sizeof(*gfx9_cb_counter_ids),
		.counter_ids = gfx9_cb_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPF] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx9_cpf_counter_ids) /
					sizeof(*gfx9_cpf_counter_ids),
		.counter_ids = gfx9_cpf_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPG] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx9_cpg_counter_ids) /
					sizeof(*gfx9_cpg_counter_ids),
		.counter_ids = gfx9_cpg_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__DB] = {
		.num_of_slots = 12,
		.num_of_counters = sizeof(gfx9_db_counter_ids) /
					sizeof(*gfx9_db_counter_ids),
		.counter_ids = gfx9_db_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GDS] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx7_gds_counter_ids) /
					sizeof(*gfx7_gds_counter_ids),
		.counter_ids = gfx7_gds_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx9_grbm_counter_ids) /
					sizeof(*gfx9_grbm_counter_ids),
		.counter_ids = gfx9_grbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBMSE] = {
		.num_of_slots = 1,
		.num_of_counters = sizeof(gfx9_grbmse_counter_ids) /
					sizeof(*gfx9_grbmse_counter_ids),
		.counter_ids = gfx9_grbmse_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__IA] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx9_ia_counter_ids) /
					sizeof(*gfx9_ia_counter_ids),
		.counter_ids = gfx9_ia_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASC] = {
		.num_of_slots = 11,
		.num_of_counters = sizeof(gfx9_pasc_counter_ids) /
					sizeof(*gfx9_pasc_counter_ids),
		.counter_ids = gfx9_pasc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASU] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx9_pasu_counter_ids) /
					sizeof(*gfx9_pasu_counter_ids),
		.counter_ids = gfx9_pasu_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SPI] = {
		.num_of_slots = 18,
		.num_of_counters = sizeof(gfx9_spi_counter_ids) /
					sizeof(*gfx9_spi_counter_ids),
		.counter_ids = gfx9_spi_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 16,
		.num_of_counters = sizeof(gfx9_sq_counter_ids) /
					sizeof(*gfx9_sq_counter_ids),
		.counter_ids = gfx9_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SX] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx9_sx_counter_ids) /
					sizeof(*gfx9_sx_counter_ids),
		.counter_ids = gfx9_sx_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TA] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx8_ta_counter_ids) /
					sizeof(*gfx8_ta_counter_ids),
		.counter_ids = gfx8_ta_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCA] = {
		.num_of_slots = 10, /* same as Fiji */
		/* Greenland has the same TCA counter IDs with Fiji */
		.num_of_counters = sizeof(gfx8_tca_counter_ids) /
					sizeof(*gfx8_tca_counter_ids),
		.counter_ids = gfx8_tca_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCC] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx8_tcc_counter_ids) /
					sizeof(*gfx8_tcc_counter_ids),
		.counter_ids = gfx8_tcc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCP] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx9_tcp_counter_ids) /
					sizeof(*gfx9_tcp_counter_ids),
		.counter_ids = gfx9_tcp_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TD] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx9_td_counter_ids) /
					sizeof(*gfx9_td_counter_ids),
		.counter_ids = gfx9_td_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__VGT] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx9_vgt_counter_ids) /
					sizeof(*gfx9_vgt_counter_ids),
		.counter_ids = gfx9_vgt_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__WD] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx9_wd_counter_ids) /
					sizeof(*gfx9_wd_counter_ids),
		.counter_ids = gfx9_wd_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

static struct perf_counter_block navi_blocks[PERFCOUNTER_BLOCKID__MAX] = {
	[PERFCOUNTER_BLOCKID__CB] = {
		.num_of_slots = 7,
		.num_of_counters = sizeof(gfx10_cb_counter_ids) /
					sizeof(*gfx10_cb_counter_ids),
		.counter_ids = gfx10_cb_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPF] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx10_cpf_counter_ids) /
					sizeof(*gfx10_cpf_counter_ids),
		.counter_ids = gfx10_cpf_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__CPG] = {
		.num_of_slots = 6,
		.num_of_counters = sizeof(gfx10_cpg_counter_ids) /
					sizeof(*gfx10_cpg_counter_ids),
		.counter_ids = gfx10_cpg_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__DB] = {
		.num_of_slots = 12,
		.num_of_counters = sizeof(gfx10_db_counter_ids) /
					sizeof(*gfx10_db_counter_ids),
		.counter_ids = gfx10_db_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GDS] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx10_gds_counter_ids) /
					sizeof(*gfx10_gds_counter_ids),
		.counter_ids = gfx10_gds_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBM] = {
		.num_of_slots = 2,
		.num_of_counters = sizeof(gfx10_grbm_counter_ids) /
					sizeof(*gfx10_grbm_counter_ids),
		.counter_ids = gfx10_grbm_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__GRBMSE] = {
		.num_of_slots = 1,
		.num_of_counters = sizeof(gfx10_grbmse_counter_ids) /
					sizeof(*gfx10_grbmse_counter_ids),
		.counter_ids = gfx10_grbmse_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASC] = {
		.num_of_slots = 11,
		.num_of_counters = sizeof(gfx10_pasc_counter_ids) /
					sizeof(*gfx10_pasc_counter_ids),
		.counter_ids = gfx10_pasc_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__PASU] = {
		.num_of_slots = 16,
		.num_of_counters = sizeof(gfx10_pasu_counter_ids) /
					sizeof(*gfx10_pasu_counter_ids),
		.counter_ids = gfx10_pasu_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SPI] = {
		.num_of_slots = 18,
		.num_of_counters = sizeof(gfx10_spi_counter_ids) /
					sizeof(*gfx10_spi_counter_ids),
		.counter_ids = gfx10_spi_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SQ] = {
		.num_of_slots = 16,
		.num_of_counters = sizeof(gfx10_sq_counter_ids) /
					sizeof(*gfx10_sq_counter_ids),
		.counter_ids = gfx10_sq_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__SX] = {
		.num_of_slots = 4,
		.num_of_counters = sizeof(gfx10_sx_counter_ids) /
					sizeof(*gfx10_sx_counter_ids),
		.counter_ids = gfx10_sx_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TA] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx10_ta_counter_ids) /
					sizeof(*gfx10_ta_counter_ids),
		.counter_ids = gfx10_ta_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TCP] = {
		.num_of_slots = 10,
		.num_of_counters = sizeof(gfx10_tcp_counter_ids) /
					sizeof(*gfx10_tcp_counter_ids),
		.counter_ids = gfx10_tcp_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
	[PERFCOUNTER_BLOCKID__TD] = {
		.num_of_slots = 5,
		.num_of_counters = sizeof(gfx10_td_counter_ids) /
					sizeof(*gfx10_td_counter_ids),
		.counter_ids = gfx10_td_counter_ids,
		.counter_size_in_bits = 64,
		.counter_mask = BITMASK(64)
	},
};

HSAKMT_STATUS hsakmt_get_block_properties(uint32_t node_id,
				   enum perf_block_id block_id,
				   struct perf_counter_block *block)
{
	uint32_t gfxv = hsakmt_get_gfxv_by_node_id(node_id);
	uint16_t dev_id = hsakmt_get_device_id_by_node_id(node_id);

	if (block_id >= PERFCOUNTER_BLOCKID__MAX ||
			block_id < PERFCOUNTER_BLOCKID__FIRST)
		return HSAKMT_STATUS_INVALID_PARAMETER;

	/* Major GFX Version */
	switch (gfxv >> 16) {
	case 7:
		if (gfxv == GFX_VERSION_KAVERI)
			*block = kaveri_blocks[block_id];
		else
			*block = hawaii_blocks[block_id];
		break;
	case 8:
		if (gfxv == GFX_VERSION_TONGA)
			return HSAKMT_STATUS_INVALID_PARAMETER;
		else if (gfxv == GFX_VERSION_CARRIZO)
			*block = carrizo_blocks[block_id];
		else {
			/*
			 * Fiji/Polaris/VegaM cards are of the same GFXIP Engine Version (8.0.3).
			 * Only way to differentiate b/t Fiji and Polaris/VegaM is via DID.
			 */
			if (dev_id == 0x7300 || dev_id == 0x730F)
				*block = fiji_blocks[block_id];
			else
				*block = polaris_blocks[block_id];
		}
		break;
	case 9:
		*block = vega_blocks[block_id];
		break;
	case 10:
		*block = navi_blocks[block_id];
		break;
	default:
		return HSAKMT_STATUS_INVALID_PARAMETER;
	}

	return HSAKMT_STATUS_SUCCESS;
}
